/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.typeutils.impl.annotations;

import de.siphalor.tweed5.typeutils.api.annotations.AnnotationRepeatType;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jspecify.annotations.Nullable;

public class AnnotationRepeatTypeResolver {
    private static final Map<Class<? extends Annotation>, AnnotationRepeatType> CACHE = new HashMap<Class<? extends Annotation>, AnnotationRepeatType>();
    private static final ReadWriteLock CACHE_LOCK = new ReentrantReadWriteLock();

    public static AnnotationRepeatType getType(Class<? extends Annotation> annotationClass) {
        CACHE_LOCK.readLock().lock();
        try {
            AnnotationRepeatType cachedValue = CACHE.get(annotationClass);
            if (cachedValue != null) {
                AnnotationRepeatType annotationRepeatType = cachedValue;
                return annotationRepeatType;
            }
        }
        finally {
            CACHE_LOCK.readLock().unlock();
        }
        return AnnotationRepeatTypeResolver.determineType(annotationClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AnnotationRepeatType determineType(Class<? extends Annotation> annotationClass) {
        Class<? extends Annotation> container = AnnotationRepeatTypeResolver.getRepeatableContainerFromComponentAnnotation(annotationClass);
        if (container != null) {
            CACHE_LOCK.writeLock().lock();
            try {
                AnnotationRepeatType.Repeatable type = new AnnotationRepeatType.Repeatable(annotationClass, container);
                CACHE.put(annotationClass, type);
                CACHE.put(container, new AnnotationRepeatType.RepeatableContainer(container, annotationClass));
                AnnotationRepeatType.Repeatable repeatable = type;
                return repeatable;
            }
            finally {
                CACHE_LOCK.writeLock().unlock();
            }
        }
        Class<? extends Annotation> component = AnnotationRepeatTypeResolver.getRepeatableComponentFromContainerAnnotation(annotationClass);
        if (component != null) {
            CACHE_LOCK.writeLock().lock();
            try {
                AnnotationRepeatType.RepeatableContainer type = new AnnotationRepeatType.RepeatableContainer(annotationClass, component);
                CACHE.put(annotationClass, type);
                CACHE.put(component, new AnnotationRepeatType.Repeatable(component, annotationClass));
                AnnotationRepeatType.RepeatableContainer repeatableContainer = type;
                return repeatableContainer;
            }
            finally {
                CACHE_LOCK.writeLock().unlock();
            }
        }
        AnnotationRepeatType.NonRepeatable type = new AnnotationRepeatType.NonRepeatable(annotationClass);
        CACHE_LOCK.writeLock().lock();
        try {
            CACHE.put(annotationClass, type);
        }
        finally {
            CACHE_LOCK.writeLock().unlock();
        }
        return type;
    }

    private static @Nullable Class<? extends Annotation> getRepeatableContainerFromComponentAnnotation(Class<? extends Annotation> annotationClass) {
        Repeatable repeatableDeclaration = annotationClass.getAnnotation(Repeatable.class);
        if (repeatableDeclaration == null) {
            return null;
        }
        return repeatableDeclaration.value();
    }

    private static @Nullable Class<? extends Annotation> getRepeatableComponentFromContainerAnnotation(Class<? extends Annotation> annotationClass) {
        try {
            Method method = annotationClass.getMethod("value", new Class[0]);
            Class<?> returnType = method.getReturnType();
            if (!returnType.isArray()) {
                return null;
            }
            Class<?> componentType = returnType.getComponentType();
            if (!componentType.isAnnotation()) {
                return null;
            }
            Repeatable repeatableDeclaration = componentType.getAnnotation(Repeatable.class);
            if (repeatableDeclaration == null) {
                return null;
            }
            if (repeatableDeclaration.value() != annotationClass) {
                return null;
            }
            return componentType;
        }
        catch (NoSuchMethodException ignored) {
            return null;
        }
    }
}

