/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.utils.api.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class InheritanceMap<T> {
    private static final InheritanceMap<Object> EMPTY = InheritanceMap.unmodifiable(new InheritanceMap<Object>(Object.class));
    private final Class<T> baseClass;
    private final Map<T, Collection<Class<? extends T>>> instanceToClasses;
    private final Map<Class<? extends T>, Collection<T>> classToInstances;

    public static <T> InheritanceMap<T> empty() {
        return EMPTY;
    }

    public static <T> InheritanceMap<T> unmodifiable(InheritanceMap<T> map) {
        return new Unmodifiable<T>(map);
    }

    public InheritanceMap(Class<T> baseClass) {
        this(baseClass, new IdentityHashMap(), new HashMap<Class<? extends T>, Collection<T>>());
    }

    public int size() {
        return this.instanceToClasses.size();
    }

    public boolean isEmpty() {
        return this.instanceToClasses.isEmpty();
    }

    public boolean containsAnyInstanceForClass(Class<? extends T> clazz) {
        return !((Collection)this.classToInstances.getOrDefault(clazz, Collections.emptyList())).isEmpty();
    }

    public boolean containsSingleInstanceForClass(Class<? extends T> clazz) {
        return ((Collection)this.classToInstances.getOrDefault(clazz, Collections.emptyList())).size() == 1;
    }

    public boolean containsInstance(T instance) {
        return this.instanceToClasses.containsKey(instance);
    }

    public <V extends T> Collection<V> getAllInstances(Class<V> clazz) {
        return this.classToInstances.getOrDefault(clazz, Collections.emptyList());
    }

    public <V extends T> @Nullable V getSingleInstance(Class<V> clazz) throws NonUniqueResultException {
        Collection instances = this.classToInstances.getOrDefault(clazz, Collections.emptyList());
        if (instances.isEmpty()) {
            return null;
        }
        if (instances.size() == 1) {
            return (V)instances.iterator().next();
        }
        throw new NonUniqueResultException("Multiple instances for class " + clazz.getName() + " exist.");
    }

    public boolean putAll(T ... instances) {
        boolean changed = false;
        for (T instance : instances) {
            changed = this.put(instance) || changed;
        }
        return changed;
    }

    public boolean put(T instance) {
        if (this.instanceToClasses.containsKey(instance)) {
            return false;
        }
        this.putInternal(instance);
        return true;
    }

    public boolean putIfAbsent(T instance) {
        Collection existingInstances = this.classToInstances.getOrDefault(instance.getClass(), Collections.emptyList());
        if (existingInstances.isEmpty()) {
            this.putInternal(instance);
            return true;
        }
        return false;
    }

    public <V extends T> @Nullable V removeInstance(V instance) {
        if (!this.instanceToClasses.containsKey(instance)) {
            return null;
        }
        Collection classes = this.instanceToClasses.getOrDefault(instance, Collections.emptyList());
        for (Class implemented : classes) {
            ((Collection)this.classToInstances.getOrDefault(implemented, Collections.emptyList())).remove(instance);
        }
        this.instanceToClasses.remove(instance);
        return instance;
    }

    public void clear() {
        this.instanceToClasses.clear();
        this.classToInstances.clear();
    }

    public Set<T> values() {
        return this.instanceToClasses.keySet();
    }

    private void putInternal(T instance) {
        Collection<Class<?>> classes = this.findClasses(instance.getClass());
        this.instanceToClasses.put(instance, classes);
        for (Class<?> implementedClass : classes) {
            this.classToInstances.computeIfAbsent(implementedClass, c -> new ArrayList()).add(instance);
        }
    }

    private Collection<Class<? extends T>> findClasses(Class<? extends T> clazz) {
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        for (Class<T> superClass = clazz; superClass != Object.class && superClass != this.baseClass && this.baseClass.isAssignableFrom(superClass); superClass = superClass.getSuperclass()) {
            classes.add(superClass);
            if (this.baseClass != Object.class && !this.baseClass.isInterface()) continue;
            classes.addAll(this.findOnlyInterfaces(superClass));
        }
        return classes;
    }

    private Collection<Class<? extends T>> findOnlyInterfaces(Class<? extends T> clazz) {
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        for (Class<?> implemented : clazz.getInterfaces()) {
            if (this.baseClass == implemented || !this.baseClass.isAssignableFrom(implemented)) continue;
            classes.add(implemented);
            classes.addAll(this.findOnlyInterfaces(implemented));
        }
        return classes;
    }

    @Generated
    protected InheritanceMap(Class<T> baseClass, Map<T, Collection<Class<? extends T>>> instanceToClasses, Map<Class<? extends T>, Collection<T>> classToInstances) {
        this.baseClass = baseClass;
        this.instanceToClasses = instanceToClasses;
        this.classToInstances = classToInstances;
    }

    private static class Unmodifiable<T>
    extends InheritanceMap<T> {
        public Unmodifiable(InheritanceMap<T> delegate) {
            super(((InheritanceMap)delegate).baseClass, ((InheritanceMap)delegate).instanceToClasses, ((InheritanceMap)delegate).classToInstances);
        }

        @Override
        public boolean put(T instance) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean putIfAbsent(T instance) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <V extends T> V removeInstance(V instance) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    public static class NonUniqueResultException
    extends Exception {
        public NonUniqueResultException(String message) {
            super(message);
        }
    }
}

