/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.weaver.pojoext.serde.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PrimitiveIterator;
import lombok.Generated;

public final class SerdePojoReaderWriterSpec {
    private final String identifier;
    private final List<SerdePojoReaderWriterSpec> arguments;

    public static SerdePojoReaderWriterSpec parse(String input) throws ParseException {
        Lexer lexer = new Lexer(input.codePoints().iterator());
        SerdePojoReaderWriterSpec spec = SerdePojoReaderWriterSpec.parseSpec(lexer);
        lexer.chompWhitespace();
        int codePoint = lexer.nextCodePoint();
        if (codePoint != -1) {
            throw lexer.createException("Found trailing text after spec", codePoint);
        }
        return spec;
    }

    private static SerdePojoReaderWriterSpec parseSpec(Lexer lexer) throws ParseException {
        lexer.chompWhitespace();
        String identifier = lexer.nextIdentifier();
        lexer.chompWhitespace();
        int codePoint = lexer.peekCodePoint();
        if (codePoint == 40) {
            lexer.nextCodePoint();
            lexer.chompWhitespace();
            if (lexer.peekCodePoint() == 41) {
                lexer.nextCodePoint();
                return new SerdePojoReaderWriterSpec(identifier, Collections.emptyList());
            }
            SerdePojoReaderWriterSpec spec = new SerdePojoReaderWriterSpec(identifier, SerdePojoReaderWriterSpec.parseSpecList(lexer));
            codePoint = lexer.nextCodePoint();
            if (codePoint != 41) {
                throw lexer.createException("Argument list must be ended with a closing parenthesis", codePoint);
            }
            return spec;
        }
        return new SerdePojoReaderWriterSpec(identifier, Collections.emptyList());
    }

    private static List<SerdePojoReaderWriterSpec> parseSpecList(Lexer lexer) throws ParseException {
        ArrayList<SerdePojoReaderWriterSpec> specs = new ArrayList<SerdePojoReaderWriterSpec>();
        while (true) {
            specs.add(SerdePojoReaderWriterSpec.parseSpec(lexer));
            lexer.chompWhitespace();
            int codePoint = lexer.peekCodePoint();
            if (codePoint != 44) break;
            lexer.nextCodePoint();
        }
        return Collections.unmodifiableList(specs);
    }

    @Generated
    public SerdePojoReaderWriterSpec(String identifier, List<SerdePojoReaderWriterSpec> arguments) {
        this.identifier = identifier;
        this.arguments = arguments;
    }

    @Generated
    public String identifier() {
        return this.identifier;
    }

    @Generated
    public List<SerdePojoReaderWriterSpec> arguments() {
        return this.arguments;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerdePojoReaderWriterSpec)) {
            return false;
        }
        SerdePojoReaderWriterSpec other = (SerdePojoReaderWriterSpec)o;
        String this$identifier = this.identifier();
        String other$identifier = other.identifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        List<SerdePojoReaderWriterSpec> this$arguments = this.arguments();
        List<SerdePojoReaderWriterSpec> other$arguments = other.arguments();
        return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $identifier = this.identifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        List<SerdePojoReaderWriterSpec> $arguments = this.arguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SerdePojoReaderWriterSpec(identifier=" + this.identifier() + ", arguments=" + this.arguments() + ")";
    }

    private static class Lexer {
        private static final int EMPTY = -2;
        private final PrimitiveIterator.OfInt codePointIterator;
        private int peek = -2;
        private int index;

        public String nextIdentifier() throws ParseException {
            int codePoint = this.nextCodePoint();
            if (codePoint == -1) {
                throw this.createException("Expected identifier, got end of input", codePoint);
            }
            if (!this.isIdentifierChar(codePoint)) {
                throw this.createException("Expected identifier (alphanumeric character)", codePoint);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.appendCodePoint(codePoint);
            boolean dot = false;
            while ((codePoint = this.peekCodePoint()) >= 0) {
                if (this.isIdentifierChar(codePoint)) {
                    stringBuilder.appendCodePoint(this.nextCodePoint());
                    dot = false;
                    continue;
                }
                if (codePoint != 46) break;
                if (dot) {
                    throw this.createException("Unexpected double dot in identifier", codePoint);
                }
                stringBuilder.appendCodePoint(this.nextCodePoint());
                dot = true;
            }
            if (dot) {
                throw this.createException("Identifier must not end with dot", codePoint);
            }
            return stringBuilder.toString();
        }

        private boolean isIdentifierChar(int codePoint) {
            return codePoint >= 48 && codePoint <= 57 || codePoint >= 97 && codePoint <= 122 || codePoint >= 65 && codePoint <= 90;
        }

        public void chompWhitespace() {
            while (Character.isWhitespace(this.peekCodePoint())) {
                this.nextCodePoint();
            }
        }

        private int peekCodePoint() {
            if (this.peek == -2) {
                this.peek = this.nextCodePoint();
            }
            return this.peek;
        }

        private int nextCodePoint() {
            if (this.peek != -2) {
                int codePoint = this.peek;
                this.peek = -2;
                return codePoint;
            }
            if (this.codePointIterator.hasNext()) {
                ++this.index;
                return this.codePointIterator.nextInt();
            }
            return -1;
        }

        public ParseException createException(String message, int codePoint) {
            return new ParseException(message, this.index, codePoint);
        }

        @Generated
        public Lexer(PrimitiveIterator.OfInt codePointIterator) {
            this.codePointIterator = codePointIterator;
        }
    }

    public static class ParseException
    extends Exception {
        private final int index;
        private final int codePoint;

        public ParseException(String message, int index, int codePoint) {
            super(message);
            this.index = index;
            this.codePoint = codePoint;
        }

        @Override
        public String getMessage() {
            String message = super.getMessage();
            StringBuilder stringBuilder = new StringBuilder(30 + message.length()).append("Parse error at index ").append(this.index).append(" \"");
            if (this.codePoint == -1) {
                stringBuilder.append("EOF");
            } else {
                stringBuilder.appendCodePoint(this.codePoint);
            }
            return stringBuilder.append("\": ").append(message).toString();
        }

        @Generated
        public int index() {
            return this.index;
        }

        @Generated
        public int codePoint() {
            return this.codePoint;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParseException)) {
                return false;
            }
            ParseException other = (ParseException)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.index() != other.index()) {
                return false;
            }
            return this.codePoint() == other.codePoint();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParseException;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.index();
            result = result * 59 + this.codePoint();
            return result;
        }

        @Override
        @Generated
        public String toString() {
            return "SerdePojoReaderWriterSpec.ParseException(super=" + super.toString() + ", index=" + this.index() + ", codePoint=" + this.codePoint() + ")";
        }
    }
}

