/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.weaver.pojoext.serde.api;

import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.data.extension.api.ReadWriteExtension;
import de.siphalor.tweed5.data.extension.api.TweedEntryReader;
import de.siphalor.tweed5.data.extension.api.TweedEntryWriter;
import de.siphalor.tweed5.data.extension.api.TweedReaderWriterProvider;
import de.siphalor.tweed5.data.extension.impl.TweedEntryReaderWriterImpls;
import de.siphalor.tweed5.shadowed.org.apache.commons.logging.Log;
import de.siphalor.tweed5.shadowed.org.apache.commons.logging.LogFactory;
import de.siphalor.tweed5.typeutils.api.type.ActualType;
import de.siphalor.tweed5.weaver.pojo.api.weaving.TweedPojoWeavingExtension;
import de.siphalor.tweed5.weaver.pojo.api.weaving.WeavingContext;
import de.siphalor.tweed5.weaver.pojoext.serde.api.EntryReadWriteConfig;
import de.siphalor.tweed5.weaver.pojoext.serde.impl.ReaderWriterLoader;
import de.siphalor.tweed5.weaver.pojoext.serde.impl.SerdePojoReaderWriterSpec;
import java.util.Arrays;
import java.util.ServiceLoader;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class ReadWritePojoWeavingProcessor
implements TweedPojoWeavingExtension {
    @Generated
    private static final Log log = LogFactory.getLog(ReadWritePojoWeavingProcessor.class);
    private final ReadWriteExtension readWriteExtension;
    private final ReaderWriterLoader readerWriterLoader = new ReaderWriterLoader();

    public ReadWritePojoWeavingProcessor(ConfigContainer<?> configContainer) {
        this.readWriteExtension = (ReadWriteExtension)configContainer.extension(ReadWriteExtension.class).orElseThrow(() -> new IllegalStateException("You must register a " + ReadWriteExtension.class.getSimpleName() + " to use the " + this.getClass().getSimpleName()));
    }

    public void setup(TweedPojoWeavingExtension.SetupContext context) {
        this.loadProviders();
    }

    private void loadProviders() {
        ServiceLoader<TweedReaderWriterProvider> serviceLoader = ServiceLoader.load(TweedReaderWriterProvider.class);
        serviceLoader.forEach(this.readerWriterLoader::load);
    }

    public <T> void afterWeaveEntry(ActualType<T> valueType, ConfigEntry<T> configEntry, WeavingContext context) {
        EntryReadWriteConfig entryConfig = context.annotations().getAnnotation(EntryReadWriteConfig.class);
        if (entryConfig == null) {
            return;
        }
        try {
            this.readWriteExtension.setEntryReaderWriter(configEntry, this.resolveReader(entryConfig), this.resolveWriter(entryConfig));
        }
        catch (Exception e) {
            log.warn((Object)("Unexpected exception while resolving serde reader and writer for " + Arrays.toString(context.path()) + ". Entry will not be included in serde."), (Throwable)e);
        }
    }

    private TweedEntryReader<?, ?> resolveReader(EntryReadWriteConfig entryConfig) {
        String specText = entryConfig.reader().isEmpty() ? entryConfig.value() : entryConfig.reader();
        SerdePojoReaderWriterSpec spec = this.specFromText(specText);
        if (spec == null) {
            return TweedEntryReaderWriterImpls.NOOP_READER_WRITER;
        }
        return this.readerWriterLoader.resolveReaderFromSpec(spec);
    }

    private TweedEntryWriter<?, ?> resolveWriter(EntryReadWriteConfig entryConfig) {
        String specText = entryConfig.writer().isEmpty() ? entryConfig.value() : entryConfig.writer();
        SerdePojoReaderWriterSpec spec = this.specFromText(specText);
        if (spec == null) {
            return TweedEntryReaderWriterImpls.NOOP_READER_WRITER;
        }
        return this.readerWriterLoader.resolveWriterFromSpec(spec);
    }

    private @Nullable SerdePojoReaderWriterSpec specFromText(String specText) {
        if (specText.isEmpty()) {
            return null;
        }
        try {
            return SerdePojoReaderWriterSpec.parse(specText);
        }
        catch (SerdePojoReaderWriterSpec.ParseException e) {
            throw new IllegalArgumentException("Failed to parse definition for reader or writer: \"" + specText + "\"", e);
        }
    }
}

