package de.siphalor.tweed5.weaver.pojo.api.entry;

import de.siphalor.tweed5.construct.api.TweedConstructFactory;
import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.entry.CompoundConfigEntry;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import org.jspecify.annotations.Nullable;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

/**
 * {@inheritDoc}
 * <br />
 * A constructor taking the value {@link Class} and a {@link Supplier} that allows to instantiate the value Class with no arguments.
 */
public interface WeavableCompoundConfigEntry<T> extends CompoundConfigEntry<T> {
	@SuppressWarnings("rawtypes")
	TweedConstructFactory<WeavableCompoundConfigEntry> FACTORY =  // the value class
	// constructor for the value class
	// List of SubEntry's
	TweedConstructFactory.builder(WeavableCompoundConfigEntry.class).typedArg(ConfigContainer.class).typedArg(Class.class).typedArg(Supplier.class).namedArg("subEntries", List.class).build();


	final class SubEntry {
		private final String name;
		private final ConfigEntry<?> configEntry;
		@Nullable
		private final MethodHandle getter;
		@Nullable
		private final MethodHandle setter;

		public String name() {
			return this.name;
		}

		public ConfigEntry<?> configEntry() {
			return this.configEntry;
		}

		@Nullable
		public MethodHandle getter() {
			return this.getter;
		}

		@Nullable
		public MethodHandle setter() {
			return this.setter;
		}

		@Override
		public boolean equals(final Object o) {
			if (o == this) return true;
			if (!(o instanceof WeavableCompoundConfigEntry.SubEntry)) return false;
			final WeavableCompoundConfigEntry.SubEntry other = (WeavableCompoundConfigEntry.SubEntry) o;
			final Object this$name = this.name();
			final Object other$name = other.name();
			if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
			final Object this$configEntry = this.configEntry();
			final Object other$configEntry = other.configEntry();
			if (this$configEntry == null ? other$configEntry != null : !this$configEntry.equals(other$configEntry)) return false;
			final Object this$getter = this.getter();
			final Object other$getter = other.getter();
			if (this$getter == null ? other$getter != null : !this$getter.equals(other$getter)) return false;
			final Object this$setter = this.setter();
			final Object other$setter = other.setter();
			if (this$setter == null ? other$setter != null : !this$setter.equals(other$setter)) return false;
			return true;
		}

		@Override
		public int hashCode() {
			final int PRIME = 59;
			int result = 1;
			final Object $name = this.name();
			result = result * PRIME + ($name == null ? 43 : $name.hashCode());
			final Object $configEntry = this.configEntry();
			result = result * PRIME + ($configEntry == null ? 43 : $configEntry.hashCode());
			final Object $getter = this.getter();
			result = result * PRIME + ($getter == null ? 43 : $getter.hashCode());
			final Object $setter = this.setter();
			result = result * PRIME + ($setter == null ? 43 : $setter.hashCode());
			return result;
		}

		@Override
		public String toString() {
			return "WeavableCompoundConfigEntry.SubEntry(name=" + this.name() + ", configEntry=" + this.configEntry() + ", getter=" + this.getter() + ", setter=" + this.setter() + ")";
		}

		public SubEntry(final String name, final ConfigEntry<?> configEntry, @Nullable final MethodHandle getter, @Nullable final MethodHandle setter) {
			this.name = name;
			this.configEntry = configEntry;
			this.getter = getter;
			this.setter = setter;
		}
	}
}
