package de.siphalor.tweed5.weaver.pojo.impl.weaving.compound;

import de.siphalor.tweed5.namingformat.api.NamingFormat;
import de.siphalor.tweed5.weaver.pojo.api.entry.WeavableCompoundConfigEntry;
import org.jspecify.annotations.Nullable;

public final class CompoundWeavingConfigImpl implements CompoundWeavingConfig {
	@Nullable
	private final NamingFormat compoundSourceNamingFormat;
	@Nullable
	private final NamingFormat compoundTargetNamingFormat;
	@SuppressWarnings("rawtypes")
	@Nullable
	private final Class<? extends WeavableCompoundConfigEntry> compoundEntryClass;

	public static CompoundWeavingConfigImpl withOverrides(CompoundWeavingConfig self, CompoundWeavingConfig overrides) {
		return CompoundWeavingConfigImpl.builder().compoundSourceNamingFormat(overrides.compoundSourceNamingFormat() != null ? overrides.compoundSourceNamingFormat() : self.compoundSourceNamingFormat()).compoundTargetNamingFormat(overrides.compoundTargetNamingFormat() != null ? overrides.compoundTargetNamingFormat() : self.compoundTargetNamingFormat()).compoundEntryClass(overrides.compoundEntryClass() != null ? overrides.compoundEntryClass() : self.compoundEntryClass()).build();
	}

	CompoundWeavingConfigImpl(@Nullable final NamingFormat compoundSourceNamingFormat, @Nullable final NamingFormat compoundTargetNamingFormat, @Nullable final Class<? extends WeavableCompoundConfigEntry> compoundEntryClass) {
		this.compoundSourceNamingFormat = compoundSourceNamingFormat;
		this.compoundTargetNamingFormat = compoundTargetNamingFormat;
		this.compoundEntryClass = compoundEntryClass;
	}


	public static class CompoundWeavingConfigImplBuilder {
		private NamingFormat compoundSourceNamingFormat;
		private NamingFormat compoundTargetNamingFormat;
		private Class<? extends WeavableCompoundConfigEntry> compoundEntryClass;

		CompoundWeavingConfigImplBuilder() {
		}

		/**
		 * @return {@code this}.
		 */
		public CompoundWeavingConfigImpl.CompoundWeavingConfigImplBuilder compoundSourceNamingFormat(@Nullable final NamingFormat compoundSourceNamingFormat) {
			this.compoundSourceNamingFormat = compoundSourceNamingFormat;
			return this;
		}

		/**
		 * @return {@code this}.
		 */
		public CompoundWeavingConfigImpl.CompoundWeavingConfigImplBuilder compoundTargetNamingFormat(@Nullable final NamingFormat compoundTargetNamingFormat) {
			this.compoundTargetNamingFormat = compoundTargetNamingFormat;
			return this;
		}

		/**
		 * @return {@code this}.
		 */
		public CompoundWeavingConfigImpl.CompoundWeavingConfigImplBuilder compoundEntryClass(@Nullable final Class<? extends WeavableCompoundConfigEntry> compoundEntryClass) {
			this.compoundEntryClass = compoundEntryClass;
			return this;
		}

		public CompoundWeavingConfigImpl build() {
			return new CompoundWeavingConfigImpl(this.compoundSourceNamingFormat, this.compoundTargetNamingFormat, this.compoundEntryClass);
		}

		@Override
		public String toString() {
			return "CompoundWeavingConfigImpl.CompoundWeavingConfigImplBuilder(compoundSourceNamingFormat=" + this.compoundSourceNamingFormat + ", compoundTargetNamingFormat=" + this.compoundTargetNamingFormat + ", compoundEntryClass=" + this.compoundEntryClass + ")";
		}
	}

	public static CompoundWeavingConfigImpl.CompoundWeavingConfigImplBuilder builder() {
		return new CompoundWeavingConfigImpl.CompoundWeavingConfigImplBuilder();
	}

	@Nullable
	public NamingFormat compoundSourceNamingFormat() {
		return this.compoundSourceNamingFormat;
	}

	@Nullable
	public NamingFormat compoundTargetNamingFormat() {
		return this.compoundTargetNamingFormat;
	}

	@Nullable
	public Class<? extends WeavableCompoundConfigEntry> compoundEntryClass() {
		return this.compoundEntryClass;
	}

	@Override
	public boolean equals(final Object o) {
		if (o == this) return true;
		if (!(o instanceof CompoundWeavingConfigImpl)) return false;
		final CompoundWeavingConfigImpl other = (CompoundWeavingConfigImpl) o;
		final Object this$compoundSourceNamingFormat = this.compoundSourceNamingFormat();
		final Object other$compoundSourceNamingFormat = other.compoundSourceNamingFormat();
		if (this$compoundSourceNamingFormat == null ? other$compoundSourceNamingFormat != null : !this$compoundSourceNamingFormat.equals(other$compoundSourceNamingFormat)) return false;
		final Object this$compoundTargetNamingFormat = this.compoundTargetNamingFormat();
		final Object other$compoundTargetNamingFormat = other.compoundTargetNamingFormat();
		if (this$compoundTargetNamingFormat == null ? other$compoundTargetNamingFormat != null : !this$compoundTargetNamingFormat.equals(other$compoundTargetNamingFormat)) return false;
		final Object this$compoundEntryClass = this.compoundEntryClass();
		final Object other$compoundEntryClass = other.compoundEntryClass();
		if (this$compoundEntryClass == null ? other$compoundEntryClass != null : !this$compoundEntryClass.equals(other$compoundEntryClass)) return false;
		return true;
	}

	@Override
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		final Object $compoundSourceNamingFormat = this.compoundSourceNamingFormat();
		result = result * PRIME + ($compoundSourceNamingFormat == null ? 43 : $compoundSourceNamingFormat.hashCode());
		final Object $compoundTargetNamingFormat = this.compoundTargetNamingFormat();
		result = result * PRIME + ($compoundTargetNamingFormat == null ? 43 : $compoundTargetNamingFormat.hashCode());
		final Object $compoundEntryClass = this.compoundEntryClass();
		result = result * PRIME + ($compoundEntryClass == null ? 43 : $compoundEntryClass.hashCode());
		return result;
	}

	@Override
	public String toString() {
		return "CompoundWeavingConfigImpl(compoundSourceNamingFormat=" + this.compoundSourceNamingFormat() + ", compoundTargetNamingFormat=" + this.compoundTargetNamingFormat() + ", compoundEntryClass=" + this.compoundEntryClass() + ")";
	}
}
