/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.weaver.pojo.impl.weaving;

import de.siphalor.tweed5.annotationinheritance.api.AnnotationInheritanceAwareAnnotatedElement;
import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.container.ConfigContainerSetupPhase;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.core.api.extension.TweedExtension;
import de.siphalor.tweed5.patchwork.api.Patchwork;
import de.siphalor.tweed5.patchwork.api.PatchworkFactory;
import de.siphalor.tweed5.shadowed.org.apache.commons.logging.Log;
import de.siphalor.tweed5.shadowed.org.apache.commons.logging.LogFactory;
import de.siphalor.tweed5.typeutils.api.type.ActualType;
import de.siphalor.tweed5.weaver.pojo.api.TweedPojoWeaver;
import de.siphalor.tweed5.weaver.pojo.api.annotation.PojoWeaving;
import de.siphalor.tweed5.weaver.pojo.api.annotation.PojoWeavingExtension;
import de.siphalor.tweed5.weaver.pojo.api.weaving.ProtoWeavingContext;
import de.siphalor.tweed5.weaver.pojo.api.weaving.TweedPojoWeavingExtension;
import de.siphalor.tweed5.weaver.pojo.api.weaving.WeavingContext;
import de.siphalor.tweed5.weaver.pojo.impl.weaving.PojoWeavingException;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class TweedPojoWeaverImpl<T>
implements TweedPojoWeaver<T> {
    @Generated
    private static final Log log = LogFactory.getLog(TweedPojoWeaverImpl.class);
    private final Class<T> pojoClass;
    private final AnnotatedElement pojoAnnotations;
    private final PojoWeaving rootWeavingConfig;
    private final Set<Class<? extends TweedPojoWeavingExtension>> weavingExtensionClasses = new LinkedHashSet<Class<? extends TweedPojoWeavingExtension>>();
    private @Nullable Collection<TweedPojoWeavingExtension> weavingExtensions;
    private @Nullable ConfigContainer<T> configContainer;
    private final Set<Class<? extends TweedExtension>> extensionClasses = new LinkedHashSet<Class<? extends TweedExtension>>();
    private final WeavingContext.WeavingFn weavingContextFn = new WeavingContext.WeavingFn(){

        public <U> ConfigEntry<U> weaveEntry(ActualType<U> valueType, Patchwork extensionsData, ProtoWeavingContext context) {
            return TweedPojoWeaverImpl.this.weaveEntry(valueType, extensionsData, context);
        }

        public <U> ConfigEntry<U> weavePseudoEntry(WeavingContext parentContext, String pseudoEntryName, Patchwork extensionsData) {
            return TweedPojoWeaverImpl.this.weavePseudoEntry(parentContext, pseudoEntryName, extensionsData);
        }
    };
    private @Nullable PatchworkFactory weavingExtensionsPatchworkFactory;

    public static <T> TweedPojoWeaverImpl<T> implForClass(Class<T> pojoClass) {
        AnnotationInheritanceAwareAnnotatedElement pojoAnnotations = new AnnotationInheritanceAwareAnnotatedElement(pojoClass);
        PojoWeaving rootWeavingConfig = TweedPojoWeaverImpl.expectAnnotation((AnnotatedElement)pojoAnnotations, PojoWeaving.class);
        return new TweedPojoWeaverImpl<T>(pojoClass, (AnnotatedElement)pojoAnnotations, rootWeavingConfig);
    }

    private static <A extends Annotation> A expectAnnotation(AnnotatedElement element, Class<A> annotationClass) {
        A annotation = element.getAnnotation(annotationClass);
        if (annotation == null) {
            throw new PojoWeavingException("Annotation " + annotationClass.getName() + " must be defined on class " + element);
        }
        return annotation;
    }

    @Override
    public TweedPojoWeaver<T> withConfigContainer(ConfigContainer<T> container) {
        if (this.configContainer != null) {
            throw new IllegalStateException("Config container already set");
        }
        this.configContainer = container;
        return this;
    }

    @Override
    public ConfigContainer<T> configContainer() {
        if (this.configContainer != null) {
            return this.configContainer;
        }
        this.configContainer = TweedPojoWeaverImpl.createConfigContainer(this.rootWeavingConfig.container());
        for (de.siphalor.tweed5.weaver.pojo.api.annotation.TweedExtension annotation : (de.siphalor.tweed5.weaver.pojo.api.annotation.TweedExtension[])this.pojoAnnotations.getAnnotationsByType(de.siphalor.tweed5.weaver.pojo.api.annotation.TweedExtension.class)) {
            this.extensionClasses.add(annotation.value());
        }
        this.configContainer.registerExtensions(this.extensionClasses.toArray(new Class[0]));
        return this.configContainer;
    }

    private static ConfigContainer<?> createConfigContainer(Class<? extends ConfigContainer<?>> containerClass) {
        try {
            return (ConfigContainer)ConfigContainer.FACTORY.construct(containerClass).finish();
        }
        catch (Exception e) {
            throw new PojoWeavingException("Failed to instantiate config container");
        }
    }

    @Override
    public TweedPojoWeaver<T> withWeavingExtension(Class<? extends TweedPojoWeavingExtension> weavingExtension) {
        if (this.configContainer != null && this.configContainer.setupPhase().compareTo((Enum)ConfigContainerSetupPhase.TREE_ATTACHED) >= 0) {
            throw new IllegalStateException("Cannot add weaving extensions after the tree has been attached");
        }
        this.weavingExtensionClasses.add(weavingExtension);
        return this;
    }

    @Override
    public TweedPojoWeaver<T> withExtension(Class<? extends TweedExtension> extension) {
        if (this.configContainer != null && this.configContainer.setupPhase().compareTo((Enum)ConfigContainerSetupPhase.EXTENSIONS_SETUP) > 0) {
            throw new IllegalStateException("Cannot add extensions after the extensions have been finalized");
        }
        this.extensionClasses.add(extension);
        if (this.configContainer != null) {
            this.configContainer.registerExtension(extension);
        }
        return this;
    }

    @Override
    public ConfigContainer<T> weave() {
        ConfigContainer<T> configContainer = this.configContainer();
        if (configContainer.setupPhase().compareTo((Enum)ConfigContainerSetupPhase.TREE_ATTACHED) >= 0) {
            throw new IllegalStateException("Cannot weave twice");
        }
        if (configContainer.setupPhase() == ConfigContainerSetupPhase.EXTENSIONS_SETUP) {
            configContainer.finishExtensionSetup();
        }
        ConfigEntry rootEntry = this.weaveEntry(ActualType.ofClass(this.pojoClass), this.weavingExtensionsPatchworkFactory().create(), ProtoWeavingContext.create(configContainer, this.pojoAnnotations));
        configContainer.attachTree(rootEntry);
        this.runAfterWeaveHooks();
        return configContainer;
    }

    private PatchworkFactory weavingExtensionsPatchworkFactory() {
        if (this.weavingExtensionsPatchworkFactory != null) {
            return this.weavingExtensionsPatchworkFactory;
        }
        PatchworkFactory.Builder weavingExtensionsPatchworkFactoryBuilder = PatchworkFactory.builder();
        TweedPojoWeavingExtension.SetupContext setupContext = arg_0 -> ((PatchworkFactory.Builder)weavingExtensionsPatchworkFactoryBuilder).registerPart(arg_0);
        for (TweedPojoWeavingExtension weavingExtension : this.weavingExtensions()) {
            weavingExtension.setup(setupContext);
        }
        this.weavingExtensionsPatchworkFactory = weavingExtensionsPatchworkFactoryBuilder.build();
        return this.weavingExtensionsPatchworkFactory;
    }

    private Collection<TweedPojoWeavingExtension> weavingExtensions() {
        if (this.weavingExtensions != null) {
            return this.weavingExtensions;
        }
        for (PojoWeavingExtension annotation : (PojoWeavingExtension[])this.pojoAnnotations.getAnnotationsByType(PojoWeavingExtension.class)) {
            this.weavingExtensionClasses.add(annotation.value());
        }
        this.weavingExtensions = this.weavingExtensionClasses.stream().map(weavingExtensionClass -> (TweedPojoWeavingExtension)TweedPojoWeavingExtension.FACTORY.construct(weavingExtensionClass).typedArg(ConfigContainer.class, this.configContainer).finish()).collect(Collectors.toList());
        return this.weavingExtensions;
    }

    private <U> ConfigEntry<U> weaveEntry(ActualType<U> valueType, Patchwork extensionsData, ProtoWeavingContext protoContext) {
        assert (this.configContainer != null && this.weavingExtensions != null);
        extensionsData = extensionsData.copy();
        this.runBeforeWeaveEntryHooks(valueType, extensionsData, protoContext);
        WeavingContext context = WeavingContext.builder().parent(protoContext.parent()).weavingFunction(this.weavingContextFn).configContainer(this.configContainer).valueType(valueType).path(protoContext.path()).extensionsData(extensionsData).annotations((AnnotatedElement)new AnnotationInheritanceAwareAnnotatedElement(protoContext.annotations())).build();
        for (TweedPojoWeavingExtension weavingExtension : this.weavingExtensions) {
            try {
                ConfigEntry<U> configEntry = weavingExtension.weaveEntry(valueType, context);
                if (configEntry == null) continue;
                this.runAfterWeaveEntryHooks(valueType, configEntry, context);
                return configEntry;
            }
            catch (Exception e) {
                log.error((Object)("Failed to run Tweed POJO weaver (" + weavingExtension.getClass().getName() + ") for entry at " + Arrays.toString(context.path())), (Throwable)e);
            }
        }
        throw new PojoWeavingException("Failed to weave entry for " + valueType + " at " + Arrays.toString(context.path()) + ": No matching weavers found.\nRegistered weaving extensions: " + this.weavingExtensions.stream().map((Function<TweedPojoWeavingExtension, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Lde/siphalor/tweed5/weaver/pojo/api/weaving/TweedPojoWeavingExtension;)Ljava/lang/Class;)()).map(Class::getName).collect(Collectors.joining(", ")));
    }

    private <U> ConfigEntry<U> weavePseudoEntry(WeavingContext parentContext, String pseudoEntryName, Patchwork extensionsData) {
        assert (this.configContainer != null && this.weavingExtensions != null);
        extensionsData = extensionsData.copy();
        ActualType<?> valueType = parentContext.valueType();
        String[] path = Arrays.copyOf(parentContext.path(), parentContext.path().length + 1);
        path[path.length - 1] = ":" + pseudoEntryName;
        WeavingContext context = WeavingContext.builder().parent(parentContext).weavingFunction(this.weavingContextFn).configContainer(this.configContainer).path(path).valueType(parentContext.valueType()).isPseudo(true).extensionsData(extensionsData).annotations(parentContext.annotations()).build();
        for (TweedPojoWeavingExtension weavingExtension : this.weavingExtensions) {
            try {
                ConfigEntry<?> configEntry = weavingExtension.weaveEntry(valueType, context);
                if (configEntry == null) continue;
                this.runAfterWeaveEntryHooks(valueType, configEntry, context);
                return configEntry;
            }
            catch (Exception e) {
                log.error((Object)("Failed to run Tweed POJO weaver (" + weavingExtension.getClass().getName() + ") for pseudo entry at " + Arrays.toString(context.path())), (Throwable)e);
            }
        }
        throw new PojoWeavingException("Failed to weave pseudo entry for " + valueType + " at " + Arrays.toString(context.path()) + ": No matching weavers found");
    }

    private <U> void runBeforeWeaveEntryHooks(ActualType<U> dataClass, Patchwork extensionsData, ProtoWeavingContext protoContext) {
        assert (this.weavingExtensions != null);
        for (TweedPojoWeavingExtension weavingExtension : this.weavingExtensions) {
            try {
                weavingExtension.beforeWeaveEntry(dataClass, extensionsData, protoContext);
            }
            catch (Exception e) {
                log.error((Object)("Failed to apply Tweed POJO weaver before weave hook (" + weavingExtension.getClass().getName() + ")"), (Throwable)e);
            }
        }
    }

    private <U> void runAfterWeaveEntryHooks(ActualType<U> dataClass, ConfigEntry<U> configEntry, WeavingContext context) {
        assert (this.weavingExtensions != null);
        for (TweedPojoWeavingExtension weavingExtension : this.weavingExtensions) {
            try {
                weavingExtension.afterWeaveEntry(dataClass, configEntry, context);
            }
            catch (Exception e) {
                log.error((Object)("Failed to apply Tweed POJO weaver after weave hook (" + weavingExtension.getClass().getName() + ")"), (Throwable)e);
            }
        }
    }

    private void runAfterWeaveHooks() {
        assert (this.weavingExtensions != null);
        for (TweedPojoWeavingExtension weavingExtension : this.weavingExtensions) {
            weavingExtension.afterWeave();
        }
    }

    @Generated
    private TweedPojoWeaverImpl(Class<T> pojoClass, AnnotatedElement pojoAnnotations, PojoWeaving rootWeavingConfig) {
        this.pojoClass = pojoClass;
        this.pojoAnnotations = pojoAnnotations;
        this.rootWeavingConfig = rootWeavingConfig;
    }

    @Override
    @Generated
    public Class<T> pojoClass() {
        return this.pojoClass;
    }
}

