/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.annotationinheritance.api;

import de.siphalor.tweed5.annotationinheritance.api.AnnotationInheritance;
import de.siphalor.tweed5.annotationinheritance.impl.AnnotationInheritanceResolver;
import de.siphalor.tweed5.typeutils.api.annotations.AnnotationRepeatType;
import de.siphalor.tweed5.utils.api.collection.ClassToInstanceMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NonNull;

public class AnnotationInheritanceAwareAnnotatedElement
implements AnnotatedElement {
    private final AnnotatedElement inner;
    @Nullable
    private ClassToInstanceMap<Annotation> resolvedAnnotations;

    @Override
    @Nullable
    public <T extends Annotation> T getAnnotation(@NonNull Class<T> annotationClass) {
        AnnotationRepeatType repeatType;
        if (this.resolvedAnnotations != null) {
            return (T)((Annotation)this.resolvedAnnotations.get(annotationClass));
        }
        Annotation[] annotations = this.inner.getAnnotations();
        boolean metaEncountered = false;
        Annotation foundAnnotation = null;
        for (Annotation annotation : annotations) {
            if (annotation.annotationType().equals(annotationClass)) {
                foundAnnotation = annotation;
                continue;
            }
            if (metaEncountered) continue;
            metaEncountered = annotation.annotationType().isAnnotationPresent(AnnotationInheritance.class);
        }
        if (foundAnnotation != null && (repeatType = AnnotationRepeatType.getType(annotationClass)) instanceof AnnotationRepeatType.NonRepeatable) {
            return (T)foundAnnotation;
        }
        if (!metaEncountered) {
            return (T)foundAnnotation;
        }
        return (T)((Annotation)this.getOrResolveAnnotations().get(annotationClass));
    }

    @Override
    public <T extends Annotation> @NonNull @NotNull T[] getAnnotationsByType(@NonNull Class<T> annotationClass) {
        Annotation annotation = (Annotation)this.getOrResolveAnnotations().get(annotationClass);
        if (annotation != null) {
            Annotation[] array = (Annotation[])Array.newInstance(annotationClass, 1);
            array[0] = annotation;
            return array;
        }
        AnnotationRepeatType repeatType = AnnotationRepeatType.getType(annotationClass);
        if (repeatType instanceof AnnotationRepeatType.Repeatable) {
            AnnotationRepeatType.RepeatableContainer containerRepeatType = ((AnnotationRepeatType.Repeatable)repeatType).containerRepeatType();
            Annotation containerAnnotation = (Annotation)this.getOrResolveAnnotations().get(containerRepeatType.annotationClass());
            if (containerAnnotation != null) {
                return containerRepeatType.elements(containerAnnotation);
            }
        }
        return (Annotation[])Array.newInstance(annotationClass, 0);
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        return this.getOrResolveAnnotations().values().toArray(new Annotation[0]);
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        return this.inner.getDeclaredAnnotations();
    }

    private ClassToInstanceMap<Annotation> getOrResolveAnnotations() {
        if (this.resolvedAnnotations == null) {
            this.resolvedAnnotations = new AnnotationInheritanceResolver(this.inner).resolve();
        }
        return this.resolvedAnnotations;
    }

    @Generated
    public AnnotationInheritanceAwareAnnotatedElement(AnnotatedElement inner) {
        this.inner = inner;
    }
}

