/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.attributesextension.impl.serde.filter;

import de.siphalor.tweed5.attributesextension.api.AttributesExtension;
import de.siphalor.tweed5.attributesextension.api.AttributesRelatedExtension;
import de.siphalor.tweed5.attributesextension.api.serde.filter.AttributesReadWriteFilterExtension;
import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.container.ConfigContainerSetupPhase;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.core.api.entry.ConfigEntryVisitor;
import de.siphalor.tweed5.core.api.extension.TweedExtensionSetupContext;
import de.siphalor.tweed5.core.api.middleware.Middleware;
import de.siphalor.tweed5.data.extension.api.TweedEntryReadException;
import de.siphalor.tweed5.data.extension.api.TweedEntryReader;
import de.siphalor.tweed5.data.extension.api.TweedEntryWriter;
import de.siphalor.tweed5.data.extension.api.TweedReadContext;
import de.siphalor.tweed5.data.extension.api.extension.ReadWriteExtensionSetupContext;
import de.siphalor.tweed5.data.extension.api.extension.ReadWriteRelatedExtension;
import de.siphalor.tweed5.data.extension.impl.TweedEntryReaderWriterImpls;
import de.siphalor.tweed5.dataapi.api.DelegatingTweedDataWriter;
import de.siphalor.tweed5.dataapi.api.TweedDataReader;
import de.siphalor.tweed5.dataapi.api.TweedDataUnsupportedValueException;
import de.siphalor.tweed5.dataapi.api.TweedDataVisitor;
import de.siphalor.tweed5.dataapi.api.decoration.TweedDataDecoration;
import de.siphalor.tweed5.patchwork.api.Patchwork;
import de.siphalor.tweed5.patchwork.api.PatchworkPartAccess;
import de.siphalor.tweed5.utils.api.UniqueSymbol;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class AttributesReadWriteFilterExtensionImpl
implements AttributesReadWriteFilterExtension,
AttributesRelatedExtension,
ReadWriteRelatedExtension {
    private static final Set<String> MIDDLEWARES_MUST_COME_BEFORE = Collections.emptySet();
    private static final Set<String> MIDDLEWARES_MUST_COME_AFTER = new HashSet<String>(Arrays.asList("$default.end", "validation"));
    private static final UniqueSymbol TWEED_DATA_NOTHING_VALUE = new UniqueSymbol("nothing (skip value)");
    private final ConfigContainer<?> configContainer;
    private @Nullable AttributesExtension attributesExtension;
    private final Set<String> filterableAttributes = new HashSet<String>();
    private final PatchworkPartAccess<EntryCustomData> entryDataAccess;
    private @Nullable PatchworkPartAccess<ReadWriteContextCustomData> readWriteContextDataAccess;

    public AttributesReadWriteFilterExtensionImpl(ConfigContainer<?> configContainer, TweedExtensionSetupContext setupContext) {
        this.configContainer = configContainer;
        this.entryDataAccess = setupContext.registerEntryExtensionData(EntryCustomData.class);
    }

    public void setupReadWriteExtension(ReadWriteExtensionSetupContext context) {
        this.readWriteContextDataAccess = context.registerReadWriteContextExtensionData(ReadWriteContextCustomData.class);
        context.registerReaderMiddleware((Middleware)new ReaderMiddleware());
        context.registerWriterMiddleware((Middleware)new WriterMiddleware());
    }

    @Override
    public void markAttributeForFiltering(String key) {
        this.requireUninitialized();
        this.filterableAttributes.add(key);
    }

    @Override
    public void afterAttributesInitialized() {
        this.attributesExtension = (AttributesExtension)this.configContainer.extension(AttributesExtension.class).orElseThrow(() -> new IllegalStateException("You must register a " + AttributesExtension.class.getSimpleName() + " before initializing the " + AttributesReadWriteFilterExtension.class.getSimpleName()));
        this.configContainer.rootEntry().visitInOrder(new ConfigEntryVisitor(){
            private final Deque<Map<String, Set<String>>> attributesCollectors = new ArrayDeque<Map<String, Set<String>>>();

            public void visitEntry(ConfigEntry<?> entry) {
                Map<String, Set<String>> currentAttributesCollector = this.attributesCollectors.peekFirst();
                if (currentAttributesCollector != null) {
                    for (String filterableAttribute : AttributesReadWriteFilterExtensionImpl.this.filterableAttributes) {
                        List<String> values = AttributesReadWriteFilterExtensionImpl.this.attributesExtension.getAttributeValues(entry, filterableAttribute);
                        if (values.isEmpty()) continue;
                        currentAttributesCollector.computeIfAbsent(filterableAttribute, k -> new HashSet()).addAll(values);
                    }
                }
            }

            public boolean enterStructuredEntry(ConfigEntry<?> entry) {
                this.attributesCollectors.push(new HashMap());
                this.visitEntry(entry);
                return true;
            }

            public void leaveStructuredEntry(ConfigEntry<?> entry) {
                this.leaveContainerEntry(entry);
            }

            private void leaveContainerEntry(ConfigEntry<?> entry) {
                Map<String, Set<String>> entryAttributesCollector = this.attributesCollectors.pop();
                entry.extensionsData().set(AttributesReadWriteFilterExtensionImpl.this.entryDataAccess, (Object)new EntryCustomData(entryAttributesCollector));
                Map<String, Set<String>> outerAttributesCollector = this.attributesCollectors.peekFirst();
                if (outerAttributesCollector != null) {
                    entryAttributesCollector.forEach((key, value) -> outerAttributesCollector.computeIfAbsent((String)key, k -> new HashSet()).addAll(value));
                }
            }
        });
    }

    @Override
    public void addFilter(Patchwork contextExtensionsData, String key, String value) {
        this.requireInitialized();
        ReadWriteContextCustomData contextCustomData = this.getOrCreateReadWriteContextCustomData(contextExtensionsData);
        this.addFilterToRWContextData(key, value, contextCustomData);
    }

    private ReadWriteContextCustomData getOrCreateReadWriteContextCustomData(Patchwork patchwork) {
        assert (this.readWriteContextDataAccess != null);
        ReadWriteContextCustomData readWriteContextCustomData = (ReadWriteContextCustomData)patchwork.get(this.readWriteContextDataAccess);
        if (readWriteContextCustomData == null) {
            readWriteContextCustomData = new ReadWriteContextCustomData();
            patchwork.set(this.readWriteContextDataAccess, (Object)readWriteContextCustomData);
        }
        return readWriteContextCustomData;
    }

    private void addFilterToRWContextData(String key, String value, ReadWriteContextCustomData contextCustomData) {
        if (!this.filterableAttributes.contains(key)) {
            throw new IllegalArgumentException("The attribute " + key + " has not been marked for filtering");
        }
        contextCustomData.attributeFilters().computeIfAbsent(key, k -> new HashSet()).add(value);
    }

    private void requireUninitialized() {
        if (this.configContainer.setupPhase().compareTo((Enum)ConfigContainerSetupPhase.INITIALIZED) >= 0) {
            throw new IllegalStateException("Attribute optimization is only editable until the config has been initialized");
        }
    }

    private void requireInitialized() {
        if (this.configContainer.setupPhase().compareTo((Enum)ConfigContainerSetupPhase.INITIALIZED) < 0) {
            throw new IllegalStateException("Config container must already be initialized");
        }
    }

    private boolean doFiltersMatch(ConfigEntry<?> entry, ReadWriteContextCustomData contextData) {
        assert (this.attributesExtension != null);
        EntryCustomData entryCustomData = (EntryCustomData)entry.extensionsData().get(this.entryDataAccess);
        if (entryCustomData == null) {
            for (Map.Entry<String, Set<String>> attributeFilter : contextData.attributeFilters().entrySet()) {
                List<String> values = this.attributesExtension.getAttributeValues(entry, attributeFilter.getKey());
                if (values.containsAll((Collection)attributeFilter.getValue())) continue;
                return false;
            }
            return true;
        }
        for (Map.Entry<String, Set<String>> attributeFilter : contextData.attributeFilters().entrySet()) {
            Set values = entryCustomData.optimizedAttributes().getOrDefault(attributeFilter.getKey(), Collections.emptySet());
            if (values.containsAll((Collection)attributeFilter.getValue())) continue;
            return false;
        }
        return true;
    }

    private static class ReadWriteContextCustomData {
        private final Map<String, Set<String>> attributeFilters = new HashMap<String, Set<String>>();
        private boolean writerInstalled;

        private ReadWriteContextCustomData() {
        }

        @Generated
        public Map<String, Set<String>> attributeFilters() {
            return this.attributeFilters;
        }

        @Generated
        public boolean writerInstalled() {
            return this.writerInstalled;
        }

        @Generated
        public ReadWriteContextCustomData writerInstalled(boolean writerInstalled) {
            this.writerInstalled = writerInstalled;
            return this;
        }
    }

    private static class EntryCustomData {
        private final Map<String, Set<String>> optimizedAttributes;

        @Generated
        public Map<String, Set<String>> optimizedAttributes() {
            return this.optimizedAttributes;
        }

        @Generated
        public EntryCustomData(Map<String, Set<String>> optimizedAttributes) {
            this.optimizedAttributes = optimizedAttributes;
        }
    }

    private class ReaderMiddleware
    implements Middleware<TweedEntryReader<?, ?>> {
        private ReaderMiddleware() {
        }

        public String id() {
            return "attributes-read-write-filter";
        }

        public Set<String> mustComeBefore() {
            return MIDDLEWARES_MUST_COME_BEFORE;
        }

        public Set<String> mustComeAfter() {
            return MIDDLEWARES_MUST_COME_AFTER;
        }

        public TweedEntryReader<?, ?> process(TweedEntryReader<?, ?> inner) {
            assert (AttributesReadWriteFilterExtensionImpl.this.readWriteContextDataAccess != null);
            final TweedEntryReader<?, ?> innerCasted = inner;
            return new TweedEntryReader<Object, ConfigEntry<Object>>(){
                final /* synthetic */ ReaderMiddleware this$1;
                {
                    this.this$1 = this$1;
                }

                public @Nullable Object read(TweedDataReader reader, ConfigEntry<Object> entry, TweedReadContext context) throws TweedEntryReadException {
                    ReadWriteContextCustomData contextData = (ReadWriteContextCustomData)context.extensionsData().get(this.this$1.AttributesReadWriteFilterExtensionImpl.this.readWriteContextDataAccess);
                    if (contextData == null || this.this$1.AttributesReadWriteFilterExtensionImpl.this.doFiltersMatch(entry, contextData)) {
                        return innerCasted.read(reader, entry, context);
                    }
                    TweedEntryReaderWriterImpls.NOOP_READER_WRITER.read(reader, entry, context);
                    return null;
                }
            };
        }
    }

    private class WriterMiddleware
    implements Middleware<TweedEntryWriter<?, ?>> {
        private WriterMiddleware() {
        }

        public String id() {
            return "attributes-read-write-filter";
        }

        public Set<String> mustComeBefore() {
            return MIDDLEWARES_MUST_COME_BEFORE;
        }

        public Set<String> mustComeAfter() {
            return MIDDLEWARES_MUST_COME_AFTER;
        }

        public TweedEntryWriter<?, ?> process(TweedEntryWriter<?, ?> inner) {
            assert (AttributesReadWriteFilterExtensionImpl.this.readWriteContextDataAccess != null);
            TweedEntryWriter<?, ?> innerCasted = inner;
            return (writer, value, entry, context) -> {
                ReadWriteContextCustomData contextData = (ReadWriteContextCustomData)context.extensionsData().get(AttributesReadWriteFilterExtensionImpl.this.readWriteContextDataAccess);
                if (contextData == null || contextData.attributeFilters().isEmpty()) {
                    innerCasted.write(writer, value, entry, context);
                    return;
                }
                if (!contextData.writerInstalled()) {
                    writer = new MapEntryKeyDeferringWriter(writer);
                    contextData.writerInstalled(true);
                }
                if (AttributesReadWriteFilterExtensionImpl.this.doFiltersMatch(entry, contextData)) {
                    innerCasted.write(writer, value, entry, context);
                } else {
                    try {
                        writer.visitValue((Object)TWEED_DATA_NOTHING_VALUE);
                    }
                    catch (TweedDataUnsupportedValueException tweedDataUnsupportedValueException) {
                        // empty catch block
                    }
                }
            };
        }
    }

    private static class MapEntryKeyDeferringWriter
    extends DelegatingTweedDataWriter {
        private final Deque<Boolean> mapContext = new ArrayDeque<Boolean>();
        private final Deque<TweedDataDecoration> preDecorationQueue = new ArrayDeque<TweedDataDecoration>();
        private final Deque<TweedDataDecoration> postDecorationQueue = new ArrayDeque<TweedDataDecoration>();
        private @Nullable String mapEntryKey;

        protected MapEntryKeyDeferringWriter(TweedDataVisitor delegate) {
            super(delegate);
            this.mapContext.push(false);
        }

        public void visitMapStart() {
            this.beforeValueWrite();
            this.mapContext.push(true);
            this.delegate.visitMapStart();
        }

        public void visitMapEntryKey(String key) {
            if (this.mapEntryKey != null) {
                throw new IllegalStateException("The map entry key has already been visited");
            }
            this.mapEntryKey = key;
        }

        public void visitMapEnd() {
            TweedDataDecoration decoration;
            if (this.mapEntryKey != null) {
                throw new IllegalArgumentException("Reached end of map while waiting for value for key " + this.mapEntryKey);
            }
            while ((decoration = this.preDecorationQueue.pollFirst()) != null) {
                super.visitDecoration(decoration);
            }
            super.visitMapEnd();
            this.mapContext.pop();
        }

        public void visitListStart() {
            this.beforeValueWrite();
            this.mapContext.push(false);
            this.delegate.visitListStart();
        }

        public void visitListEnd() {
            super.visitListEnd();
            this.mapContext.pop();
        }

        public void visitValue(@Nullable Object value) throws TweedDataUnsupportedValueException {
            if (value == TWEED_DATA_NOTHING_VALUE) {
                this.preDecorationQueue.clear();
                this.postDecorationQueue.clear();
                this.mapEntryKey = null;
                return;
            }
            super.visitValue(value);
        }

        public void visitDecoration(TweedDataDecoration decoration) {
            if (Boolean.TRUE.equals(this.mapContext.peekFirst())) {
                if (this.mapEntryKey == null) {
                    this.preDecorationQueue.addLast(decoration);
                } else {
                    this.postDecorationQueue.addLast(decoration);
                }
            } else {
                super.visitDecoration(decoration);
            }
        }

        protected void beforeValueWrite() {
            super.beforeValueWrite();
            if (this.mapEntryKey != null) {
                TweedDataDecoration decoration;
                while ((decoration = this.preDecorationQueue.pollFirst()) != null) {
                    super.visitDecoration(decoration);
                }
                super.visitMapEntryKey(this.mapEntryKey);
                this.mapEntryKey = null;
                while ((decoration = this.postDecorationQueue.pollFirst()) != null) {
                    super.visitDecoration(decoration);
                }
            }
        }
    }
}

