/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.attributesextension.impl;

import de.siphalor.tweed5.attributesextension.api.AttributesExtension;
import de.siphalor.tweed5.attributesextension.api.AttributesRelatedExtension;
import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.core.api.entry.ConfigEntryVisitor;
import de.siphalor.tweed5.core.api.extension.TweedExtension;
import de.siphalor.tweed5.core.api.extension.TweedExtensionSetupContext;
import de.siphalor.tweed5.patchwork.api.PatchworkPartAccess;
import de.siphalor.tweed5.utils.api.collection.ImmutableArrayBackedMap;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class AttributesExtensionImpl
implements AttributesExtension {
    private final ConfigContainer<?> configContainer;
    private final PatchworkPartAccess<CustomEntryData> dataAccess;
    private boolean initialized;

    public AttributesExtensionImpl(ConfigContainer<?> configContainer, TweedExtensionSetupContext setupContext) {
        this.configContainer = configContainer;
        this.dataAccess = setupContext.registerEntryExtensionData(CustomEntryData.class);
    }

    @Override
    public void setAttribute(ConfigEntry<?> entry, String key, List<String> values) {
        this.requireEditable();
        Map<String, List<String>> attributes = this.getOrCreateEditableAttributes(entry);
        attributes.compute(key, (k, existingValues) -> {
            if (existingValues == null) {
                return new ArrayList(values);
            }
            existingValues.addAll(values);
            return existingValues;
        });
    }

    @Override
    public void setAttributeDefault(ConfigEntry<?> entry, String key, List<String> values) {
        this.requireEditable();
        Map<String, List<String>> attributeDefaults = this.getOrCreateEditableAttributeDefaults(entry);
        attributeDefaults.compute(key, (k, existingValues) -> {
            if (existingValues == null) {
                return new ArrayList(values);
            }
            existingValues.addAll(values);
            return existingValues;
        });
    }

    private void requireEditable() {
        if (this.initialized) {
            throw new IllegalStateException("Attributes are only editable until the config has been initialized");
        }
    }

    private Map<String, List<String>> getOrCreateEditableAttributes(ConfigEntry<?> entry) {
        CustomEntryData data = this.getOrCreateCustomEntryData(entry);
        Map<String, List<String>> attributes = data.attributes();
        if (attributes == null) {
            attributes = new HashMap<String, List<String>>();
            data.attributes(attributes);
        }
        return attributes;
    }

    private Map<String, List<String>> getOrCreateEditableAttributeDefaults(ConfigEntry<?> entry) {
        CustomEntryData data = this.getOrCreateCustomEntryData(entry);
        Map<String, List<String>> attributeDefaults = data.attributeDefaults();
        if (attributeDefaults == null) {
            attributeDefaults = new HashMap<String, List<String>>();
            data.attributeDefaults(attributeDefaults);
        }
        return attributeDefaults;
    }

    private CustomEntryData getOrCreateCustomEntryData(ConfigEntry<?> entry) {
        CustomEntryData customEntryData = (CustomEntryData)entry.extensionsData().get(this.dataAccess);
        if (customEntryData == null) {
            customEntryData = new CustomEntryData();
            entry.extensionsData().set(this.dataAccess, (Object)customEntryData);
        }
        return customEntryData;
    }

    public void initialize() {
        this.configContainer.rootEntry().visitInOrder(new ConfigEntryVisitor(){
            private final Deque<Map<String, List<String>>> defaults = new ArrayDeque(Collections.singletonList(Collections.emptyMap()));

            public boolean enterStructuredEntry(ConfigEntry<?> entry) {
                this.enterEntry(entry);
                return true;
            }

            private void enterEntry(ConfigEntry<?> entry) {
                CustomEntryData data = (CustomEntryData)entry.extensionsData().get(AttributesExtensionImpl.this.dataAccess);
                Map<String, List<String>> currentDefaults = this.defaults.getFirst();
                if (data == null) {
                    this.defaults.push(currentDefaults);
                    return;
                }
                Map<String, List<String>> entryDefaults = data.attributeDefaults();
                data.attributeDefaults(null);
                if (entryDefaults == null || entryDefaults.isEmpty()) {
                    this.defaults.push(currentDefaults);
                    return;
                }
                this.defaults.push(this.mergeMapsAndSeal(currentDefaults, entryDefaults));
                this.visitEntry(entry);
            }

            public void leaveStructuredEntry(ConfigEntry<?> entry) {
                this.defaults.pop();
            }

            public void visitEntry(ConfigEntry<?> entry) {
                CustomEntryData data = AttributesExtensionImpl.this.getOrCreateCustomEntryData(entry);
                Map<String, List<String>> currentDefaults = this.defaults.getFirst();
                if (data.attributes() == null || data.attributes().isEmpty()) {
                    data.attributes(currentDefaults);
                } else {
                    data.attributes(this.mergeMapsAndSeal(currentDefaults, data.attributes()));
                }
            }

            private Map<String, List<String>> mergeMapsAndSeal(Map<String, List<String>> base, Map<String, List<String>> overrides) {
                if (overrides.isEmpty()) {
                    return ImmutableArrayBackedMap.ofEntries(base.entrySet());
                }
                if (base.isEmpty()) {
                    return ImmutableArrayBackedMap.ofEntries(overrides.entrySet());
                }
                ArrayList entries = new ArrayList(base.size() + overrides.size());
                overrides.forEach((key, value) -> entries.add(new AbstractMap.SimpleEntry((String)key, Collections.unmodifiableList(value))));
                base.forEach((key, value) -> {
                    if (!overrides.containsKey(key)) {
                        entries.add(new AbstractMap.SimpleEntry((String)key, Collections.unmodifiableList(value)));
                    }
                });
                return ImmutableArrayBackedMap.ofEntries(entries);
            }
        });
        this.initialized = true;
        for (TweedExtension extension : this.configContainer.extensions()) {
            if (!(extension instanceof AttributesRelatedExtension)) continue;
            ((AttributesRelatedExtension)extension).afterAttributesInitialized();
        }
    }

    @Override
    public List<String> getAttributeValues(ConfigEntry<?> entry, String key) {
        this.requireInitialized();
        CustomEntryData data = (CustomEntryData)entry.extensionsData().get(this.dataAccess);
        return Optional.ofNullable(data).map(CustomEntryData::attributes).map(attributes -> (List)attributes.get(key)).orElse(Collections.emptyList());
    }

    @Override
    public @Nullable String getAttributeValue(ConfigEntry<?> entry, String key) {
        this.requireInitialized();
        CustomEntryData data = (CustomEntryData)entry.extensionsData().get(this.dataAccess);
        return Optional.ofNullable(data).map(CustomEntryData::attributes).map(attributes -> (List)attributes.get(key)).map(values -> values.isEmpty() ? null : (String)values.get(values.size() - 1)).orElse(null);
    }

    private void requireInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Attributes are only available after the config has been initialized");
        }
    }

    private static class CustomEntryData {
        private @Nullable Map<String, List<String>> attributes;
        private @Nullable Map<String, List<String>> attributeDefaults;

        @Generated
        public CustomEntryData() {
        }

        @Generated
        public @Nullable Map<String, List<String>> attributes() {
            return this.attributes;
        }

        @Generated
        public @Nullable Map<String, List<String>> attributeDefaults() {
            return this.attributeDefaults;
        }

        @Generated
        public CustomEntryData attributes(@Nullable Map<String, List<String>> attributes) {
            this.attributes = attributes;
            return this;
        }

        @Generated
        public CustomEntryData attributeDefaults(@Nullable Map<String, List<String>> attributeDefaults) {
            this.attributeDefaults = attributeDefaults;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomEntryData)) {
                return false;
            }
            CustomEntryData other = (CustomEntryData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, List<String>> this$attributes = this.attributes();
            Map<String, List<String>> other$attributes = other.attributes();
            if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
                return false;
            }
            Map<String, List<String>> this$attributeDefaults = this.attributeDefaults();
            Map<String, List<String>> other$attributeDefaults = other.attributeDefaults();
            return !(this$attributeDefaults == null ? other$attributeDefaults != null : !((Object)this$attributeDefaults).equals(other$attributeDefaults));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomEntryData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, List<String>> $attributes = this.attributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            Map<String, List<String>> $attributeDefaults = this.attributeDefaults();
            result = result * 59 + ($attributeDefaults == null ? 43 : ((Object)$attributeDefaults).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AttributesExtensionImpl.CustomEntryData(attributes=" + this.attributes() + ", attributeDefaults=" + this.attributeDefaults() + ")";
        }
    }
}

