/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.commentloaderextension.impl;

import de.siphalor.tweed5.commentloaderextension.api.CommentLoaderExtension;
import de.siphalor.tweed5.commentloaderextension.api.CommentPathProcessor;
import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.container.ConfigContainerSetupPhase;
import de.siphalor.tweed5.core.api.entry.ConfigEntryVisitor;
import de.siphalor.tweed5.core.api.extension.TweedExtensionSetupContext;
import de.siphalor.tweed5.core.api.middleware.Middleware;
import de.siphalor.tweed5.dataapi.api.IntuitiveVisitingTweedDataReader;
import de.siphalor.tweed5.dataapi.api.TweedDataReadException;
import de.siphalor.tweed5.dataapi.api.TweedDataReader;
import de.siphalor.tweed5.dataapi.api.TweedDataVisitor;
import de.siphalor.tweed5.dataapi.api.decoration.TweedDataDecoration;
import de.siphalor.tweed5.defaultextensions.comment.api.CommentExtension;
import de.siphalor.tweed5.defaultextensions.comment.api.CommentModifyingExtension;
import de.siphalor.tweed5.defaultextensions.comment.api.CommentProducer;
import de.siphalor.tweed5.defaultextensions.pather.api.PathTracking;
import de.siphalor.tweed5.defaultextensions.pather.api.PathTrackingConfigEntryVisitor;
import de.siphalor.tweed5.patchwork.api.PatchworkPartAccess;
import de.siphalor.tweed5.shadowed.org.apache.commons.logging.Log;
import de.siphalor.tweed5.shadowed.org.apache.commons.logging.LogFactory;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class CommentLoaderExtensionImpl
implements CommentLoaderExtension,
CommentModifyingExtension {
    @Generated
    private static final Log log = LogFactory.getLog(CommentLoaderExtensionImpl.class);
    private final ConfigContainer<?> configContainer;
    private final PatchworkPartAccess<String> loadedCommentAccess;
    private @Nullable CommentExtension commentExtension;

    public CommentLoaderExtensionImpl(ConfigContainer<?> configContainer, TweedExtensionSetupContext setupContext) {
        this.configContainer = configContainer;
        setupContext.registerExtension(CommentExtension.class);
        this.loadedCommentAccess = setupContext.registerEntryExtensionData(String.class);
    }

    public void extensionsFinalized() {
        this.commentExtension = (CommentExtension)this.configContainer.extension(CommentExtension.class).orElseThrow(() -> new IllegalStateException("CommentExtension not found"));
    }

    public Middleware<CommentProducer> commentMiddleware() {
        return new Middleware<CommentProducer>(){

            public String id() {
                return "comment-loader";
            }

            public Set<String> mustComeBefore() {
                return Collections.emptySet();
            }

            public Set<String> mustComeAfter() {
                return Collections.singleton("$default.end");
            }

            public CommentProducer process(CommentProducer inner) {
                return entry -> {
                    String loadedComment = (String)entry.extensionsData().get(CommentLoaderExtensionImpl.this.loadedCommentAccess);
                    String innerComment = inner.createComment(entry);
                    if (loadedComment != null) {
                        if (innerComment.isEmpty()) {
                            return loadedComment;
                        }
                        return innerComment + loadedComment;
                    }
                    return innerComment;
                };
            }
        };
    }

    @Override
    public void loadComments(TweedDataReader reader, CommentPathProcessor pathProcessor) {
        if (this.configContainer.setupPhase().compareTo((Enum)ConfigContainerSetupPhase.EXTENSIONS_SETUP) <= 0) {
            throw new IllegalStateException("Comments cannot be loaded before the extensions are finalized");
        }
        CollectingCommentsVisitor collectingCommentsVisitor = new CollectingCommentsVisitor(pathProcessor);
        try {
            new IntuitiveVisitingTweedDataReader((TweedDataVisitor)collectingCommentsVisitor).readMap(reader);
        }
        catch (TweedDataReadException e) {
            log.error((Object)"Failed to load comments", (Throwable)e);
        }
        Map<String, String> commentsByKey = collectingCommentsVisitor.commentsByKey();
        PathTracking pathTracking = PathTracking.create();
        this.configContainer.rootEntry().visitInOrder((ConfigEntryVisitor)new PathTrackingConfigEntryVisitor(entry -> {
            String key = pathTracking.currentPath();
            if (!key.isEmpty() && key.charAt(0) == '.') {
                key = key.substring(1);
            }
            entry.extensionsData().set(this.loadedCommentAccess, (Object)((String)commentsByKey.get(key)));
        }, pathTracking));
        if (this.configContainer.setupPhase().compareTo((Enum)ConfigContainerSetupPhase.INITIALIZED) >= 0) {
            assert (this.commentExtension != null);
            this.commentExtension.recomputeFullComments();
        }
    }

    private static class CollectingCommentsVisitor
    implements TweedDataVisitor {
        private final CommentPathProcessor pathProcessor;
        private final Map<String, String> commentsByKey = new HashMap<String, String>();
        private final Deque<State> stateStack = new ArrayDeque<State>();
        private State currentState = new State(CommentPathProcessor.MatchStatus.MAYBE_DEEPER, "");

        public CollectingCommentsVisitor(CommentPathProcessor pathProcessor) {
            this.pathProcessor = pathProcessor;
            this.stateStack.push(this.currentState);
        }

        public void visitNull() {
        }

        public void visitBoolean(boolean value) {
        }

        public void visitByte(byte value) {
        }

        public void visitShort(short value) {
        }

        public void visitInt(int value) {
        }

        public void visitLong(long value) {
        }

        public void visitFloat(float value) {
        }

        public void visitDouble(double value) {
        }

        public void visitString(String value) {
            if (this.currentState.matchStatus() == CommentPathProcessor.MatchStatus.YES) {
                this.commentsByKey.put(this.pathProcessor.process(this.currentState.key()), value);
            }
        }

        public void visitListStart() {
            this.stateStack.push(State.IGNORED);
        }

        public void visitListEnd() {
            this.stateStack.pop();
        }

        public void visitMapStart() {
            this.stateStack.push(this.currentState);
            this.currentState = State.IGNORED;
        }

        public void visitMapEntryKey(String key) {
            State state = this.stateStack.peek();
            assert (state != null);
            if (state.matchStatus() == CommentPathProcessor.MatchStatus.NO) {
                return;
            }
            String fullPath = state.key().isEmpty() ? key : state.key() + "." + key;
            CommentPathProcessor.MatchStatus matchStatus = this.pathProcessor.matches(fullPath);
            this.currentState = matchStatus == CommentPathProcessor.MatchStatus.NO ? State.IGNORED : new State(matchStatus, fullPath);
        }

        public void visitMapEnd() {
            this.currentState = this.stateStack.pop();
        }

        public void visitDecoration(TweedDataDecoration decoration) {
        }

        @Generated
        public Map<String, String> commentsByKey() {
            return this.commentsByKey;
        }

        private static final class State {
            private static final State IGNORED = new State(CommentPathProcessor.MatchStatus.NO, "");
            private final CommentPathProcessor.MatchStatus matchStatus;
            private final String key;

            @Generated
            public State(CommentPathProcessor.MatchStatus matchStatus, String key) {
                this.matchStatus = matchStatus;
                this.key = key;
            }

            @Generated
            public CommentPathProcessor.MatchStatus matchStatus() {
                return this.matchStatus;
            }

            @Generated
            public String key() {
                return this.key;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof State)) {
                    return false;
                }
                State other = (State)o;
                CommentPathProcessor.MatchStatus this$matchStatus = this.matchStatus();
                CommentPathProcessor.MatchStatus other$matchStatus = other.matchStatus();
                if (this$matchStatus == null ? other$matchStatus != null : !((Object)((Object)this$matchStatus)).equals((Object)other$matchStatus)) {
                    return false;
                }
                String this$key = this.key();
                String other$key = other.key();
                return !(this$key == null ? other$key != null : !this$key.equals(other$key));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                CommentPathProcessor.MatchStatus $matchStatus = this.matchStatus();
                result = result * 59 + ($matchStatus == null ? 43 : ((Object)((Object)$matchStatus)).hashCode());
                String $key = this.key();
                result = result * 59 + ($key == null ? 43 : $key.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "CommentLoaderExtensionImpl.CollectingCommentsVisitor.State(matchStatus=" + (Object)((Object)this.matchStatus()) + ", key=" + this.key() + ")";
            }
        }
    }
}

