package de.siphalor.tweed5.construct.impl;

final class Entry<K, V> {
	private final K key;
	private final V value;

	public Entry(final K key, final V value) {
		this.key = key;
		this.value = value;
	}

	public K key() {
		return this.key;
	}

	public V value() {
		return this.value;
	}

	@Override
	public boolean equals(final Object o) {
		if (o == this) return true;
		if (!(o instanceof Entry)) return false;
		final Entry<?, ?> other = (Entry<?, ?>) o;
		final Object this$key = this.key();
		final Object other$key = other.key();
		if (this$key == null ? other$key != null : !this$key.equals(other$key)) return false;
		final Object this$value = this.value();
		final Object other$value = other.value();
		if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
		return true;
	}

	@Override
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		final Object $key = this.key();
		result = result * PRIME + ($key == null ? 43 : $key.hashCode());
		final Object $value = this.value();
		result = result * PRIME + ($value == null ? 43 : $value.hashCode());
		return result;
	}

	@Override
	public String toString() {
		return "Entry(key=" + this.key() + ", value=" + this.value() + ")";
	}
}
