/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.construct.impl;

import de.siphalor.tweed5.construct.api.ConstructParameter;
import de.siphalor.tweed5.construct.api.TweedConstruct;
import de.siphalor.tweed5.construct.api.TweedConstructFactory;
import de.siphalor.tweed5.construct.impl.Entry;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class TweedConstructFactoryImpl<T>
implements TweedConstructFactory<T> {
    private static final int CONSTRUCTOR_MODIFIERS = 1;
    private static final int STATIC_METHOD_MODIFIERS = 9;
    private final Class<T> constructBaseClass;
    private final Set<Class<?>> typedArgs;
    private final Map<String, Class<?>> namedArgs;
    private final MethodHandles.Lookup lookup = MethodHandles.publicLookup();
    private final Map<Class<?>, Optional<ConstructTarget<?>>> cachedConstructTargets = new HashMap();
    private final ReadWriteLock cachedConstructTargetsLock = new ReentrantReadWriteLock();

    public static <T> FactoryBuilder<T> builder(Class<T> baseClass) {
        return new FactoryBuilder(baseClass);
    }

    @Override
    public <C extends T> TweedConstructFactory.Construct<C> construct(Class<C> subClass) {
        return new Construct<C>(this.getConstructTarget(subClass));
    }

    private <C extends T> ConstructTarget<C> getConstructTarget(Class<C> type) {
        ConstructTarget<C> cachedConstructTarget = this.readConstructTargetFromCache(type);
        if (cachedConstructTarget != null) {
            return cachedConstructTarget;
        }
        ConstructTarget<C> constructTarget = this.locateConstructTarget(type);
        this.cacheConstructTarget(type, constructTarget);
        return constructTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C extends T> @Nullable ConstructTarget<C> readConstructTargetFromCache(Class<C> type) {
        this.cachedConstructTargetsLock.readLock().lock();
        try {
            Optional<ConstructTarget<?>> cachedConstructTarget = this.cachedConstructTargets.get(type);
            if (cachedConstructTarget != null) {
                if (!cachedConstructTarget.isPresent()) {
                    throw new IllegalStateException("Could not locate construct for " + type.getName());
                }
                ConstructTarget<?> constructTarget = cachedConstructTarget.get();
                return constructTarget;
            }
            ConstructTarget<C> constructTarget = null;
            return constructTarget;
        }
        finally {
            this.cachedConstructTargetsLock.readLock().unlock();
        }
    }

    private <C extends T> void cacheConstructTarget(Class<C> type, ConstructTarget<C> constructTarget) {
        this.cachedConstructTargetsLock.writeLock().lock();
        try {
            this.cachedConstructTargets.put(type, Optional.of(constructTarget));
        }
        finally {
            this.cachedConstructTargetsLock.writeLock().unlock();
        }
    }

    private <C extends T> ConstructTarget<C> locateConstructTarget(Class<C> type) {
        if (!this.constructBaseClass.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Type " + type.getName() + " is not a subclass of " + this.constructBaseClass.getName());
        }
        Collection<Constructor<C>> constructorCandidates = this.findConstructorCandidates(type);
        Collection<Method> staticConstructorCandidates = this.findStaticConstructorCandidates(type);
        List annotated = Stream.concat(constructorCandidates.stream(), staticConstructorCandidates.stream()).filter(candidate -> {
            TweedConstruct annotation = candidate.getAnnotation(TweedConstruct.class);
            return annotation != null && annotation.value().equals(this.constructBaseClass);
        }).collect(Collectors.toList());
        if (annotated.size() > 1) {
            throw new IllegalStateException("Found multiple matching constructors for " + type.getName() + " annotated with a matching TweedConstruct for " + this.constructBaseClass.getName() + ": " + annotated);
        }
        if (annotated.size() == 1) {
            return this.resolveConstructTarget(type, (Executable)annotated.get(0));
        }
        if (constructorCandidates.size() == 1) {
            return this.resolveConstructTarget(type, constructorCandidates.iterator().next());
        }
        throw new IllegalStateException("Failed to determine actual constructor on " + type.getName() + " for " + this.constructBaseClass.getName() + ". Constructor candidates: " + constructorCandidates + "; Static method candidates: " + staticConstructorCandidates + ". The desired constructor should be marked with @" + TweedConstruct.class.getName());
    }

    private Collection<Constructor<?>> findConstructorCandidates(Class<?> type) {
        return Arrays.stream(type.getConstructors()).filter(constructor -> (constructor.getModifiers() & 1) == 1).collect(Collectors.toList());
    }

    private Collection<Method> findStaticConstructorCandidates(Class<?> type) {
        return Arrays.stream(type.getDeclaredMethods()).filter(method -> (method.getModifiers() & 9) == 9).filter(method -> type.isAssignableFrom(method.getReturnType())).collect(Collectors.toList());
    }

    private <C extends T> ConstructTarget<C> resolveConstructTarget(Class<C> type, Executable executable) {
        Object[] argOrder = new Object[executable.getParameterCount()];
        HashMap typedParameters = new HashMap();
        HashMap<String, List<Parameter>> namedParameters = new HashMap<String, List<Parameter>>();
        Parameter[] parameters = executable.getParameters();
        boolean issue = false;
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            ConstructParameter annotation = parameter.getAnnotation(ConstructParameter.class);
            if (annotation != null) {
                String name = annotation.name();
                List named = namedParameters.computeIfAbsent(name, n -> new ArrayList());
                named.add(parameter);
                Class<?> argType = this.namedArgs.get(name);
                argOrder[i] = name;
                if (issue || named.size() <= 1 && argType != null && TweedConstructFactoryImpl.boxClass(parameter.getType()).isAssignableFrom(argType)) continue;
                issue = true;
                continue;
            }
            Class<?> paramType = TweedConstructFactoryImpl.boxClass(parameter.getType());
            List typed = typedParameters.computeIfAbsent(paramType, n -> new ArrayList());
            typed.add(parameter);
            argOrder[i] = paramType;
            if (issue || typed.size() <= 1 && this.typedArgs.contains(paramType)) continue;
            issue = true;
        }
        if (issue) {
            throw new IllegalStateException(this.createConstructorTargetArgCheckFailMessage(executable, typedParameters, namedParameters));
        }
        return new ConstructTarget<C>(type, argOrder, this.createInvokerFromCandidate(type, executable));
    }

    private <C> Function<@Nullable Object[], C> createInvokerFromCandidate(Class<C> type, Executable executable) {
        MethodHandle handle;
        block4: {
            try {
                if (executable instanceof Method) {
                    handle = this.lookup.unreflect((Method)executable);
                    break block4;
                }
                if (executable instanceof Constructor) {
                    handle = this.lookup.unreflectConstructor((Constructor)executable);
                    break block4;
                }
                throw new IllegalStateException("Unsupported executable type: " + executable);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Constructor for type " + type.getName() + " is not accessible", e);
            }
        }
        return args -> {
            try {
                return handle.invokeWithArguments(args);
            }
            catch (ClassCastException | WrongMethodTypeException e) {
                throw new IllegalStateException("Failed to construct type " + type.getName() + " as " + this.constructBaseClass.getName(), e);
            }
            catch (Throwable e) {
                throw new RuntimeException("Uncaught exception during construct of type " + type.getName() + " as " + this.constructBaseClass.getName(), e);
            }
        };
    }

    private String createConstructorTargetArgCheckFailMessage(Executable executable, Map<Class<?>, List<Parameter>> typedParameters, Map<String, List<Parameter>> namedParameters) {
        StringBuilder sb = new StringBuilder();
        sb.append("Failed to resolve parameters for ");
        sb.append(executable);
        sb.append(" (for ");
        sb.append(this.constructBaseClass.getName());
        sb.append("). The following issues have been detected:");
        HashSet unexpectedTypes = new HashSet(typedParameters.keySet());
        unexpectedTypes.removeAll(this.typedArgs);
        if (!unexpectedTypes.isEmpty()) {
            for (Class clazz : unexpectedTypes) {
                sb.append("\n - Typed parameter of type ");
                sb.append(clazz.getName());
                sb.append(" is not known: ");
                sb.append(typedParameters.get(clazz));
            }
        }
        HashSet<String> unexpectedNames = new HashSet<String>(namedParameters.keySet());
        unexpectedNames.removeAll(this.namedArgs.keySet());
        if (!unexpectedNames.isEmpty()) {
            for (String unexpectedName : unexpectedNames) {
                sb.append("\n - Named parameter ");
                sb.append(unexpectedName);
                sb.append(" is not known: ");
                sb.append(namedParameters.get(unexpectedName));
            }
        }
        typedParameters.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).forEach(entry -> sb.append("\n - Duplicate typed parameter ").append(entry.getKey()).append(": ").append(entry.getValue()));
        namedParameters.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).forEach(entry -> sb.append("\n - Duplicate named parameter ").append((String)entry.getKey()).append(": ").append(entry.getValue()));
        namedParameters.entrySet().stream().filter(entry -> !unexpectedNames.contains(entry.getKey())).flatMap(entry -> ((List)entry.getValue()).stream().map(parameter -> new Entry<String, Parameter>((String)entry.getKey(), (Parameter)parameter))).forEach(entry -> {
            Class<?> argType = this.namedArgs.get(entry.key());
            if (!TweedConstructFactoryImpl.boxClass(((Parameter)entry.value()).getType()).isAssignableFrom(argType)) {
                sb.append("\n - Named parameter ").append((String)entry.key());
                sb.append(" expects values of type ").append(argType.getName());
                sb.append(": ").append(entry.value());
            }
        });
        return sb.toString();
    }

    static <V> Class<V> boxClass(Class<V> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Void.TYPE) {
            return Void.class;
        }
        throw new IllegalArgumentException("Unsupported primitive type " + type);
    }

    @Generated
    public TweedConstructFactoryImpl(Class<T> constructBaseClass, Set<Class<?>> typedArgs, Map<String, Class<?>> namedArgs) {
        this.constructBaseClass = constructBaseClass;
        this.typedArgs = typedArgs;
        this.namedArgs = namedArgs;
    }

    @Generated
    Class<T> constructBaseClass() {
        return this.constructBaseClass;
    }

    @Generated
    Set<Class<?>> typedArgs() {
        return this.typedArgs;
    }

    @Generated
    Map<String, Class<?>> namedArgs() {
        return this.namedArgs;
    }

    @Generated
    MethodHandles.Lookup lookup() {
        return this.lookup;
    }

    @Generated
    Map<Class<?>, Optional<ConstructTarget<?>>> cachedConstructTargets() {
        return this.cachedConstructTargets;
    }

    @Generated
    ReadWriteLock cachedConstructTargetsLock() {
        return this.cachedConstructTargetsLock;
    }

    public static class FactoryBuilder<T>
    implements TweedConstructFactory.FactoryBuilder<T> {
        private final Class<T> constructBaseClass;
        private final Set<Class<?>> typedArgs = new HashSet();
        private final Map<String, Class<?>> namedArgs = new HashMap();

        @Override
        public <A> TweedConstructFactory.FactoryBuilder<T> typedArg(Class<A> argType) {
            if (this.typedArgs.contains(argType = TweedConstructFactoryImpl.boxClass(argType))) {
                throw new IllegalArgumentException("Argument for type " + argType + " has already been registered");
            }
            this.typedArgs.add(argType);
            return this;
        }

        @Override
        public <A> TweedConstructFactory.FactoryBuilder<T> namedArg(String name, Class<A> argType) {
            Class<?> existingArgType = this.namedArgs.get(name);
            if (existingArgType != null) {
                throw new IllegalArgumentException("Argument for name " + name + " has already been registered; existing type " + existingArgType.getName() + "; new type " + argType.getName());
            }
            this.namedArgs.put(name, TweedConstructFactoryImpl.boxClass(argType));
            return this;
        }

        @Override
        public TweedConstructFactory<T> build() {
            return new TweedConstructFactoryImpl<T>(this.constructBaseClass, this.typedArgs, this.namedArgs);
        }

        @Generated
        private FactoryBuilder(Class<T> constructBaseClass) {
            this.constructBaseClass = constructBaseClass;
        }
    }

    private class Construct<C>
    implements TweedConstructFactory.Construct<C> {
        private final ConstructTarget<C> target;
        private final Map<Class<?>, @Nullable Object> typedArgValues = new HashMap();
        private final Map<String, @Nullable Object> namedArgValues = new HashMap<String, Object>();

        @Override
        public <A> TweedConstructFactory.Construct<C> typedArg(A value) {
            this.requireTypedArgExists(value.getClass(), value);
            this.typedArgValues.put(value.getClass(), value);
            return this;
        }

        @Override
        public <A> TweedConstructFactory.Construct<C> typedArg(Class<? super A> argType, @Nullable A value) {
            argType = TweedConstructFactoryImpl.boxClass(argType);
            if (value != null && !argType.isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException("Typed argument for type " + argType.getName() + " is of incorrect type " + value.getClass().getName() + ", value: " + value);
            }
            this.requireTypedArgExists(argType, value);
            this.typedArgValues.put(argType, value);
            return this;
        }

        private <A> void requireTypedArgExists(Class<?> type, @Nullable A value) {
            if (!TweedConstructFactoryImpl.this.typedArgs.contains(type)) {
                throw new IllegalArgumentException("Typed argument for type " + type.getName() + " does not exist, value: " + value);
            }
        }

        @Override
        public <A> TweedConstructFactory.Construct<C> namedArg(String name, @Nullable A value) {
            Class argType = (Class)TweedConstructFactoryImpl.this.namedArgs.get(name);
            if (argType == null) {
                throw new IllegalArgumentException("Named argument for name " + name + " does not exist, value: " + value);
            }
            if (value != null && !argType.isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException("Named argument for name " + name + " is defined with type " + argType.getName() + " but got type " + value.getClass().getName() + " with value " + value);
            }
            this.namedArgValues.put(name, value);
            return this;
        }

        @Override
        public C finish() {
            this.checkAllArgsFilled();
            @Nullable Object[] argValues = new Object[((ConstructTarget)this.target).argOrder.length];
            for (int i = 0; i < ((ConstructTarget)this.target).argOrder.length; ++i) {
                Object arg = ((ConstructTarget)this.target).argOrder[i];
                if (arg instanceof Class) {
                    argValues[i] = this.typedArgValues.get((Class)arg);
                    continue;
                }
                if (arg instanceof String) {
                    argValues[i] = this.namedArgValues.get((String)arg);
                    continue;
                }
                throw new IllegalStateException("Encountered illegal argument indicator " + arg + " at " + i);
            }
            return (C)((ConstructTarget)this.target).invoker.apply(argValues);
        }

        private void checkAllArgsFilled() {
            Set<Class<Class<?>>> missingTypedArgs = Collections.emptySet();
            if (this.typedArgValues.size() != TweedConstructFactoryImpl.this.typedArgs.size()) {
                missingTypedArgs = new HashSet(TweedConstructFactoryImpl.this.typedArgs);
                missingTypedArgs.removeAll(this.typedArgValues.keySet());
            }
            Set<String> missingNamedArgs = Collections.emptySet();
            if (this.namedArgValues.size() != TweedConstructFactoryImpl.this.namedArgs.size()) {
                missingNamedArgs = new HashSet(TweedConstructFactoryImpl.this.namedArgs.keySet());
                missingNamedArgs.removeAll(this.namedArgValues.keySet());
            }
            if (!missingTypedArgs.isEmpty() || !missingNamedArgs.isEmpty()) {
                throw new IllegalArgumentException(this.createMissingArgsMessage(missingTypedArgs, missingNamedArgs));
            }
        }

        private String createMissingArgsMessage(Set<Class<?>> missingTypedArgs, Set<String> missingNamedArgs) {
            boolean requiresDelimiter;
            StringBuilder message = new StringBuilder().append("Missing arguments for construction of ").append(this.target.type().getName()).append(" as ").append(TweedConstructFactoryImpl.this.constructBaseClass.getName()).append(", missing: ");
            if (!missingTypedArgs.isEmpty()) {
                message.append("typed args (");
                requiresDelimiter = false;
                for (Class clazz : missingTypedArgs) {
                    if (requiresDelimiter) {
                        message.append(", ");
                    }
                    message.append(clazz.getName());
                    requiresDelimiter = true;
                }
                message.append(") ");
            }
            if (!missingNamedArgs.isEmpty()) {
                message.append("named args (");
                requiresDelimiter = false;
                for (String string : missingNamedArgs) {
                    if (requiresDelimiter) {
                        message.append(", ");
                    }
                    message.append(string);
                    requiresDelimiter = true;
                }
                message.append(") ");
            }
            return message.toString();
        }

        @Generated
        public Construct(ConstructTarget<C> target) {
            this.target = target;
        }
    }

    private static final class ConstructTarget<C> {
        private final Class<?> type;
        private final Object[] argOrder;
        private final Function<@Nullable Object[], C> invoker;

        @Generated
        public ConstructTarget(Class<?> type, Object[] argOrder, Function<@Nullable Object[], C> invoker) {
            this.type = type;
            this.argOrder = argOrder;
            this.invoker = invoker;
        }

        @Generated
        public Class<?> type() {
            return this.type;
        }

        @Generated
        public Object[] argOrder() {
            return this.argOrder;
        }

        @Generated
        public Function<@Nullable Object[], C> invoker() {
            return this.invoker;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConstructTarget)) {
                return false;
            }
            ConstructTarget other = (ConstructTarget)o;
            Class<?> this$type = this.type();
            Class<?> other$type = other.type();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            if (!Arrays.deepEquals(this.argOrder(), other.argOrder())) {
                return false;
            }
            Function<Object[], C> this$invoker = this.invoker();
            Function<Object[], C> other$invoker = other.invoker();
            return !(this$invoker == null ? other$invoker != null : !this$invoker.equals(other$invoker));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $type = this.type();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.argOrder());
            Function<Object[], C> $invoker = this.invoker();
            result = result * 59 + ($invoker == null ? 43 : $invoker.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TweedConstructFactoryImpl.ConstructTarget(type=" + this.type() + ", argOrder=" + Arrays.deepToString(this.argOrder()) + ", invoker=" + this.invoker() + ")";
        }
    }
}

