/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.core.api.entry;

import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.core.api.entry.ConfigEntryValueVisitor;
import de.siphalor.tweed5.core.api.entry.StructuredConfigEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;

public interface CollectionConfigEntry<E, T extends Collection<E>>
extends StructuredConfigEntry<T> {
    default public CollectionConfigEntry<E, T> apply(Consumer<ConfigEntry<T>> function) {
        StructuredConfigEntry.super.apply((Consumer)function);
        return this;
    }

    @Override
    default public void visitInOrder(ConfigEntryValueVisitor visitor, @Nullable T value) {
        if (value == null) {
            return;
        }
        if (visitor.enterStructuredEntry(this, value)) {
            int index = 0;
            for (Object item : value) {
                String indexString = Integer.toString(index);
                if (visitor.enterStructuredSubEntry("element", indexString)) {
                    this.elementEntry().visitInOrder(visitor, item);
                    visitor.leaveStructuredSubEntry("element", indexString);
                }
                ++index;
            }
            visitor.leaveStructuredEntry(this, value);
        }
    }

    @Override
    default public Map<String, ConfigEntry<?>> subEntries() {
        return Collections.singletonMap("element", this.elementEntry());
    }

    public ConfigEntry<E> elementEntry();

    public T instantiateCollection(int var1);
}

