package de.siphalor.tweed5.defaultextensions.validation.api.result;

public final class ValidationIssue {
	private final String message;
	private final ValidationIssueLevel level;

	public ValidationIssue(final String message, final ValidationIssueLevel level) {
		this.message = message;
		this.level = level;
	}

	public String message() {
		return this.message;
	}

	public ValidationIssueLevel level() {
		return this.level;
	}

	@Override
	public boolean equals(final Object o) {
		if (o == this) return true;
		if (!(o instanceof ValidationIssue)) return false;
		final ValidationIssue other = (ValidationIssue) o;
		final Object this$message = this.message();
		final Object other$message = other.message();
		if (this$message == null ? other$message != null : !this$message.equals(other$message)) return false;
		final Object this$level = this.level();
		final Object other$level = other.level();
		if (this$level == null ? other$level != null : !this$level.equals(other$level)) return false;
		return true;
	}

	@Override
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		final Object $message = this.message();
		result = result * PRIME + ($message == null ? 43 : $message.hashCode());
		final Object $level = this.level();
		result = result * PRIME + ($level == null ? 43 : $level.hashCode());
		return result;
	}

	@Override
	public String toString() {
		return "ValidationIssue(message=" + this.message() + ", level=" + this.level() + ")";
	}
}
