package de.siphalor.tweed5.defaultextensions.validation.api.result;

import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import java.util.Collection;
import java.util.Map;

/**
 * Extension data for {@link de.siphalor.tweed5.data.extension.api.extension.ReadWriteContextExtensionsData}
 * that collects all validation issues.
 */
public interface ValidationIssues {
	Map<String, EntryIssues> issuesByPath();


	final class EntryIssues {
		private final ConfigEntry<?> entry;
		private final Collection<ValidationIssue> issues;

		public EntryIssues(final ConfigEntry<?> entry, final Collection<ValidationIssue> issues) {
			this.entry = entry;
			this.issues = issues;
		}

		public ConfigEntry<?> entry() {
			return this.entry;
		}

		public Collection<ValidationIssue> issues() {
			return this.issues;
		}

		@Override
		public boolean equals(final Object o) {
			if (o == this) return true;
			if (!(o instanceof ValidationIssues.EntryIssues)) return false;
			final ValidationIssues.EntryIssues other = (ValidationIssues.EntryIssues) o;
			final Object this$entry = this.entry();
			final Object other$entry = other.entry();
			if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) return false;
			final Object this$issues = this.issues();
			final Object other$issues = other.issues();
			if (this$issues == null ? other$issues != null : !this$issues.equals(other$issues)) return false;
			return true;
		}

		@Override
		public int hashCode() {
			final int PRIME = 59;
			int result = 1;
			final Object $entry = this.entry();
			result = result * PRIME + ($entry == null ? 43 : $entry.hashCode());
			final Object $issues = this.issues();
			result = result * PRIME + ($issues == null ? 43 : $issues.hashCode());
			return result;
		}

		@Override
		public String toString() {
			return "ValidationIssues.EntryIssues(entry=" + this.entry() + ", issues=" + this.issues() + ")";
		}
	}
}
