/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.defaultextensions.validation.api;

import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.core.api.extension.TweedExtension;
import de.siphalor.tweed5.core.api.middleware.Middleware;
import de.siphalor.tweed5.defaultextensions.validation.api.ConfigEntryValidator;
import de.siphalor.tweed5.defaultextensions.validation.api.result.ValidationIssues;
import de.siphalor.tweed5.defaultextensions.validation.api.validators.SimpleValidatorMiddleware;
import de.siphalor.tweed5.defaultextensions.validation.impl.ValidationExtensionImpl;
import de.siphalor.tweed5.patchwork.api.Patchwork;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;

public interface ValidationExtension
extends TweedExtension {
    public static final Class<? extends ValidationExtension> DEFAULT = ValidationExtensionImpl.class;
    public static final String EXTENSION_ID = "validation";

    default public String getId() {
        return EXTENSION_ID;
    }

    public static <C extends ConfigEntry<T>, T> Consumer<C> validators(ConfigEntryValidator ... validators) {
        return entry -> {
            ValidationExtension extension = (ValidationExtension)entry.container().extension(ValidationExtension.class).orElseThrow(() -> new IllegalStateException("No validation extension registered"));
            extension.addValidators((ConfigEntry)entry, validators);
        };
    }

    public static <C extends ConfigEntry<T>, T> Function<C, ValidationIssues> validate(T value) {
        return entry -> {
            ValidationExtension extension = (ValidationExtension)entry.container().extension(ValidationExtension.class).orElseThrow(() -> new IllegalStateException("No validation extension registered"));
            return extension.validate((ConfigEntry)entry, value);
        };
    }

    default public <T> void addValidators(ConfigEntry<T> entry, ConfigEntryValidator ... validators) {
        String lastId = null;
        for (ConfigEntryValidator validator : validators) {
            String id = UUID.randomUUID().toString();
            final Set<Object> mustComeAfter = lastId == null ? Collections.emptySet() : Collections.singleton(lastId);
            this.addValidatorMiddleware(entry, new SimpleValidatorMiddleware(this, id, validator){
                final /* synthetic */ ValidationExtension this$0;
                {
                    this.this$0 = this$0;
                    super(id, validator);
                }

                public Set<String> mustComeAfter() {
                    return mustComeAfter;
                }
            });
            lastId = id;
        }
    }

    public <T> void addValidatorMiddleware(ConfigEntry<T> var1, Middleware<ConfigEntryValidator> var2);

    public ValidationIssues captureValidationIssues(Patchwork var1);

    public <T> ValidationIssues validate(ConfigEntry<T> var1, T var2);
}

