/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.defaultextensions.validationfallback.impl;

import com.google.auto.service.AutoService;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.core.api.extension.TweedExtensionSetupContext;
import de.siphalor.tweed5.core.api.middleware.Middleware;
import de.siphalor.tweed5.defaultextensions.validation.api.ConfigEntryValidator;
import de.siphalor.tweed5.defaultextensions.validation.api.ValidationProvidingExtension;
import de.siphalor.tweed5.defaultextensions.validation.api.result.ValidationIssue;
import de.siphalor.tweed5.defaultextensions.validation.api.result.ValidationIssueLevel;
import de.siphalor.tweed5.defaultextensions.validation.api.result.ValidationResult;
import de.siphalor.tweed5.defaultextensions.validationfallback.api.ValidationFallbackExtension;
import de.siphalor.tweed5.patchwork.api.PatchworkPartAccess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

@AutoService(value={ValidationFallbackExtension.class})
public class ValidationFallbackExtensionImpl
implements ValidationFallbackExtension,
ValidationProvidingExtension {
    private final PatchworkPartAccess<CustomEntryData> customEntryDataAccess;

    public ValidationFallbackExtensionImpl(TweedExtensionSetupContext context) {
        this.customEntryDataAccess = context.registerEntryExtensionData(CustomEntryData.class);
    }

    @Override
    public <T> void setFallbackValue(ConfigEntry<T> entry, T value) {
        this.getOrCreateCustomEntryData(entry).fallbackValue(value);
    }

    private CustomEntryData getOrCreateCustomEntryData(ConfigEntry<?> entry) {
        CustomEntryData customEntryData = (CustomEntryData)entry.extensionsData().get(this.customEntryDataAccess);
        if (customEntryData == null) {
            customEntryData = new CustomEntryData();
            entry.extensionsData().set(this.customEntryDataAccess, (Object)customEntryData);
        }
        return customEntryData;
    }

    @Override
    public Middleware<ConfigEntryValidator> validationMiddleware() {
        return new ValidationFallbackMiddleware();
    }

    private static class CustomEntryData {
        @Nullable Object fallbackValue;

        @Generated
        public CustomEntryData() {
        }

        @Generated
        public @Nullable Object fallbackValue() {
            return this.fallbackValue;
        }

        @Generated
        public CustomEntryData fallbackValue(@Nullable Object fallbackValue) {
            this.fallbackValue = fallbackValue;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomEntryData)) {
                return false;
            }
            CustomEntryData other = (CustomEntryData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$fallbackValue = this.fallbackValue();
            Object other$fallbackValue = other.fallbackValue();
            return !(this$fallbackValue == null ? other$fallbackValue != null : !this$fallbackValue.equals(other$fallbackValue));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomEntryData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $fallbackValue = this.fallbackValue();
            result = result * 59 + ($fallbackValue == null ? 43 : $fallbackValue.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ValidationFallbackExtensionImpl.CustomEntryData(fallbackValue=" + this.fallbackValue() + ")";
        }
    }

    private class ValidationFallbackMiddleware
    implements Middleware<ConfigEntryValidator> {
        private ValidationFallbackMiddleware() {
        }

        public String id() {
            return "validation-fallback";
        }

        public Set<String> mustComeBefore() {
            return Collections.emptySet();
        }

        public Set<String> mustComeAfter() {
            return Collections.singleton("$default.end");
        }

        public ConfigEntryValidator process(final ConfigEntryValidator inner) {
            return new ConfigEntryValidator(){
                final /* synthetic */ ValidationFallbackMiddleware this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public <T> ValidationResult<T> validate(ConfigEntry<T> configEntry, T value) {
                    ValidationResult<T> result = inner.validate(configEntry, value);
                    if (!result.hasError()) {
                        return result;
                    }
                    CustomEntryData entryData = (CustomEntryData)configEntry.extensionsData().get(this.this$1.ValidationFallbackExtensionImpl.this.customEntryDataAccess);
                    if (entryData == null) {
                        return result;
                    }
                    Object fallbackValue = entryData.fallbackValue();
                    if (fallbackValue != null) {
                        if (configEntry.valueClass().isInstance(fallbackValue)) {
                            fallbackValue = configEntry.deepCopy(fallbackValue);
                        } else {
                            ArrayList<ValidationIssue> issues = new ArrayList<ValidationIssue>(result.issues());
                            issues.add(new ValidationIssue("Fallback value is not of correct class, expected " + configEntry.valueClass().getName() + ", but got " + fallbackValue.getClass().getName(), ValidationIssueLevel.ERROR));
                            return ValidationResult.withIssues(value, issues);
                        }
                    }
                    return ValidationResult.withIssues(fallbackValue, result.issues().stream().map(issue -> new ValidationIssue(issue.message(), ValidationIssueLevel.WARN)).collect(Collectors.toList()));
                }

                @Override
                public <T> String description(ConfigEntry<T> configEntry) {
                    CustomEntryData entryData = (CustomEntryData)configEntry.extensionsData().get(this.this$1.ValidationFallbackExtensionImpl.this.customEntryDataAccess);
                    if (entryData == null) {
                        return inner.description(configEntry);
                    }
                    return inner.description(configEntry) + "\n\nDefault/Fallback value: " + entryData.fallbackValue();
                }
            };
        }
    }
}

