/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.defaultextensions.pather.api;

import de.siphalor.tweed5.dataapi.api.TweedDataUnsupportedValueException;
import de.siphalor.tweed5.dataapi.api.TweedDataVisitor;
import de.siphalor.tweed5.dataapi.api.decoration.TweedDataDecoration;
import de.siphalor.tweed5.defaultextensions.pather.api.PathTracking;
import java.util.ArrayDeque;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class PathTrackingDataVisitor
implements TweedDataVisitor {
    private final TweedDataVisitor delegate;
    private final PathTracking pathTracking;
    private final ArrayDeque<Context> contextStack = new ArrayDeque(50);
    private final ArrayDeque<Integer> listIndexStack = new ArrayDeque(50);

    public void visitNull() {
        this.delegate.visitNull();
        this.valueVisited();
    }

    public void visitBoolean(boolean value) {
        this.delegate.visitBoolean(value);
        this.valueVisited();
    }

    public void visitByte(byte value) {
        this.delegate.visitByte(value);
        this.valueVisited();
    }

    public void visitShort(short value) {
        this.delegate.visitShort(value);
        this.valueVisited();
    }

    public void visitInt(int value) {
        this.delegate.visitInt(value);
        this.valueVisited();
    }

    public void visitLong(long value) {
        this.delegate.visitLong(value);
        this.valueVisited();
    }

    public void visitFloat(float value) {
        this.delegate.visitFloat(value);
        this.valueVisited();
    }

    public void visitDouble(double value) {
        this.delegate.visitDouble(value);
        this.valueVisited();
    }

    public void visitString(String value) {
        this.delegate.visitString(value);
        this.valueVisited();
    }

    public void visitValue(@Nullable Object value) throws TweedDataUnsupportedValueException {
        super.visitValue(value);
        this.valueVisited();
    }

    private void valueVisited() {
        Context context = this.contextStack.peek();
        if (context == Context.MAP_ENTRY) {
            this.contextStack.pop();
            this.pathTracking.popPathPart();
        } else if (context == Context.LIST) {
            this.pathTracking.popPathPart();
            int index = this.listIndexStack.pop();
            this.listIndexStack.push(index + 1);
            this.pathTracking.pushPathPart(Integer.toString(index));
        }
    }

    public void visitListStart() {
        this.delegate.visitListStart();
        this.contextStack.push(Context.LIST);
        this.listIndexStack.push(0);
        this.pathTracking.pushPathPart("0");
    }

    public void visitListEnd() {
        this.delegate.visitListEnd();
        this.contextStack.pop();
        this.listIndexStack.pop();
        this.pathTracking.popPathPart();
        this.valueVisited();
    }

    public void visitMapStart() {
        this.delegate.visitMapStart();
    }

    public void visitMapEntryKey(String key) {
        this.delegate.visitMapEntryKey(key);
        this.pathTracking.pushPathPart(key);
        this.contextStack.push(Context.MAP_ENTRY);
    }

    public void visitMapEnd() {
        this.delegate.visitMapEnd();
        this.valueVisited();
    }

    public void visitDecoration(TweedDataDecoration decoration) {
        this.delegate.visitDecoration(decoration);
    }

    @Generated
    public PathTrackingDataVisitor(TweedDataVisitor delegate, PathTracking pathTracking) {
        this.delegate = delegate;
        this.pathTracking = pathTracking;
    }

    private static enum Context {
        LIST,
        MAP_ENTRY;

    }
}

