/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.defaultextensions.validation.api.result;

import de.siphalor.tweed5.defaultextensions.validation.api.result.ValidationIssue;
import de.siphalor.tweed5.defaultextensions.validation.api.result.ValidationIssueLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import lombok.Generated;

public class ValidationResult<T> {
    private final T value;
    private final Collection<ValidationIssue> issues;
    private final boolean hasError;

    public static <T> ValidationResult<T> ok(T value) {
        return new ValidationResult<T>(value, Collections.emptyList(), false);
    }

    public static <T> ValidationResult<T> withIssues(T value, Collection<ValidationIssue> issues) {
        return new ValidationResult<T>(value, issues, ValidationResult.issuesContainError(issues));
    }

    private static boolean issuesContainError(Collection<ValidationIssue> issues) {
        if (issues.isEmpty()) {
            return false;
        }
        for (ValidationIssue issue : issues) {
            if (issue.level() != ValidationIssueLevel.ERROR) continue;
            return true;
        }
        return false;
    }

    public ValidationResult<T> andThen(Function<T, ValidationResult<T>> function) {
        if (this.hasError) {
            return this;
        }
        ValidationResult<T> functionResult = function.apply(this.value);
        if (functionResult.issues.isEmpty()) {
            if (functionResult.value == this.value) {
                return this;
            }
            if (this.issues.isEmpty()) {
                return new ValidationResult<T>(functionResult.value, Collections.emptyList(), false);
            }
        }
        ArrayList<ValidationIssue> combinedIssues = new ArrayList<ValidationIssue>(this.issues.size() + functionResult.issues.size());
        combinedIssues.addAll(this.issues);
        combinedIssues.addAll(functionResult.issues);
        return new ValidationResult<T>(functionResult.value, combinedIssues, functionResult.hasError);
    }

    @Generated
    public T value() {
        return this.value;
    }

    @Generated
    public Collection<ValidationIssue> issues() {
        return this.issues;
    }

    @Generated
    public boolean hasError() {
        return this.hasError;
    }

    @Generated
    private ValidationResult(T value, Collection<ValidationIssue> issues, boolean hasError) {
        this.value = value;
        this.issues = issues;
        this.hasError = hasError;
    }
}

