/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.defaultextensions.readfallback.impl;

import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.middleware.Middleware;
import de.siphalor.tweed5.data.extension.api.TweedEntryReadException;
import de.siphalor.tweed5.data.extension.api.TweedEntryReader;
import de.siphalor.tweed5.data.extension.api.extension.ReadWriteExtensionSetupContext;
import de.siphalor.tweed5.data.extension.api.extension.ReadWriteRelatedExtension;
import de.siphalor.tweed5.defaultextensions.presets.api.PresetsExtension;
import de.siphalor.tweed5.defaultextensions.readfallback.api.ReadFallbackExtension;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;

public class ReadFallbackExtensionImpl
implements ReadFallbackExtension,
ReadWriteRelatedExtension {
    @Generated
    private static final Log log = LogFactory.getLog(ReadFallbackExtensionImpl.class);
    private final ConfigContainer<?> configContainer;
    private @Nullable PresetsExtension presetsExtension;

    public ReadFallbackExtensionImpl(ConfigContainer<?> configContainer) {
        this.configContainer = configContainer;
    }

    public void extensionsFinalized() {
        this.presetsExtension = (PresetsExtension)this.configContainer.extension(PresetsExtension.class).orElseThrow(() -> new IllegalStateException(this.getClass().getSimpleName() + " requires " + ReadFallbackExtension.class.getSimpleName()));
    }

    public void setupReadWriteExtension(ReadWriteExtensionSetupContext context) {
        assert (this.presetsExtension != null);
        context.registerReaderMiddleware(new Middleware<TweedEntryReader<?, ?>>(){

            public String id() {
                return "read-fallback";
            }

            public Set<String> mustComeBefore() {
                return Collections.singleton("$default.start");
            }

            public Set<String> mustComeAfter() {
                return Collections.emptySet();
            }

            public TweedEntryReader<?, ?> process(TweedEntryReader<?, ?> inner) {
                TweedEntryReader<?, ?> castedInner = inner;
                return (reader, entry, context1) -> {
                    try {
                        return castedInner.read(reader, entry, context1);
                    }
                    catch (TweedEntryReadException e) {
                        log.error((Object)("Failed to read entry: " + e.getMessage()), (Throwable)e);
                        return ReadFallbackExtensionImpl.this.presetsExtension.presetValue(entry, "default");
                    }
                };
            }
        });
    }
}

