/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.namingformat.impl;

import de.siphalor.tweed5.namingformat.api.NamingFormat;
import de.siphalor.tweed5.namingformat.impl.CodePointReader;
import java.util.ArrayList;
import java.util.PrimitiveIterator;

public class NamingFormatImpls {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final NamingFormat CAMEL_CASE = new NamingFormat(){

        @Override
        public String name() {
            return "camelCase";
        }

        @Override
        public String[] splitIntoWords(String name) {
            return NamingFormatImpls.splitAtUpperCase(name);
        }

        @Override
        public String joinToName(String[] words) {
            if (words.length == 0) {
                return "";
            }
            int totalLength = NamingFormatImpls.countTotalWordsLength(words);
            StringBuilder stringBuilder = new StringBuilder(totalLength);
            NamingFormatImpls.appendAllLower(stringBuilder, words[0]);
            for (int i = 1; i < words.length; ++i) {
                NamingFormatImpls.appendCapitalized(stringBuilder, words[i]);
            }
            return stringBuilder.toString();
        }

        public String toString() {
            return this.name();
        }
    };
    public static final NamingFormat PASCAL_CASE = new NamingFormat(){

        @Override
        public String name() {
            return "PascalCase";
        }

        @Override
        public String[] splitIntoWords(String name) {
            return NamingFormatImpls.splitAtUpperCase(name);
        }

        @Override
        public String joinToName(String[] words) {
            if (words.length == 0) {
                return "";
            }
            int totalLength = NamingFormatImpls.countTotalWordsLength(words);
            StringBuilder stringBuilder = new StringBuilder(totalLength);
            for (String word : words) {
                NamingFormatImpls.appendCapitalized(stringBuilder, word);
            }
            return stringBuilder.toString();
        }

        public String toString() {
            return this.name();
        }
    };
    public static final NamingFormat KEBAB_CASE = NamingFormatImpls.createLowerDelimitedFormat("kebab-case", '-');
    public static final NamingFormat UPPER_KEBAB_CASE = NamingFormatImpls.createUpperDelimitedFormat("UPPER-KEBAB-CASE", '-');
    public static final NamingFormat SNAKE_CASE = NamingFormatImpls.createLowerDelimitedFormat("snake_case", '_');
    public static final NamingFormat UPPER_SNAKE_CASE = NamingFormatImpls.createUpperDelimitedFormat("UPPER_SNAKE_CASE", '_');
    public static final NamingFormat SPACE_CASE = NamingFormatImpls.createLowerDelimitedFormat("space case", ' ');
    public static final NamingFormat UPPER_SPACE_CASE = NamingFormatImpls.createUpperDelimitedFormat("UPPER SPACE CASE", ' ');
    public static final NamingFormat TITLE_CASE = NamingFormatImpls.createCapitalizedDelimitedFormat("Title Case", ' ');

    private static NamingFormat createLowerDelimitedFormat(final String formatName, final char delimiter) {
        return new NamingFormat(){

            @Override
            public String name() {
                return formatName;
            }

            @Override
            public String[] splitIntoWords(String name) {
                return NamingFormatImpls.splitAtCharacter(name, delimiter);
            }

            @Override
            public String joinToName(String[] words) {
                return NamingFormatImpls.joinAllLower(delimiter, words);
            }

            public String toString() {
                return this.name();
            }
        };
    }

    private static NamingFormat createUpperDelimitedFormat(final String formatName, final char delimiter) {
        return new NamingFormat(){

            @Override
            public String name() {
                return formatName;
            }

            @Override
            public String[] splitIntoWords(String name) {
                return NamingFormatImpls.splitAtCharacter(name, delimiter);
            }

            @Override
            public String joinToName(String[] words) {
                return NamingFormatImpls.joinAllUpper(delimiter, words);
            }

            public String toString() {
                return this.name();
            }
        };
    }

    private static NamingFormat createCapitalizedDelimitedFormat(final String formatName, final char delimiter) {
        return new NamingFormat(){

            @Override
            public String name() {
                return formatName;
            }

            @Override
            public String[] splitIntoWords(String name) {
                return NamingFormatImpls.splitAtCharacter(name, delimiter);
            }

            @Override
            public String joinToName(String[] words) {
                return NamingFormatImpls.joinCapitalized(delimiter, words);
            }

            public String toString() {
                return this.name();
            }
        };
    }

    private static String[] splitAtUpperCase(String name) {
        ArrayList<String> words = new ArrayList<String>();
        StringBuilder wordBuilder = new StringBuilder();
        CodePointReader codePointReader = CodePointReader.ofString(name);
        while (codePointReader.hasNext()) {
            if (wordBuilder.length() == 0) {
                wordBuilder.appendCodePoint(codePointReader.next());
                continue;
            }
            if (Character.isUpperCase(codePointReader.peek())) {
                words.add(wordBuilder.toString());
                wordBuilder.setLength(0);
                continue;
            }
            wordBuilder.appendCodePoint(codePointReader.next());
        }
        if (wordBuilder.length() > 0) {
            words.add(wordBuilder.toString());
        }
        return words.toArray(EMPTY_STRING_ARRAY);
    }

    private static String[] splitAtCharacter(String text, char delimiter) {
        ArrayList<String> words = new ArrayList<String>();
        int index = 0;
        while (index < text.length()) {
            int delimiterIndex = text.indexOf(delimiter, index);
            if (delimiterIndex == -1) {
                words.add(text.substring(index));
                break;
            }
            words.add(text.substring(index, delimiterIndex));
            index = delimiterIndex + 1;
        }
        return words.toArray(EMPTY_STRING_ARRAY);
    }

    private static String joinAllLower(char joiner, String[] words) {
        if (words.length == 0) {
            return "";
        }
        int totalLength = NamingFormatImpls.countTotalWordsLength(words) + words.length - 1;
        StringBuilder stringBuilder = new StringBuilder(totalLength);
        for (String word : words) {
            NamingFormatImpls.appendAllLower(stringBuilder, word);
            if (stringBuilder.length() >= totalLength) continue;
            stringBuilder.append(joiner);
        }
        return stringBuilder.toString();
    }

    private static String joinAllUpper(char joiner, String[] words) {
        if (words.length == 0) {
            return "";
        }
        int totalLength = NamingFormatImpls.countTotalWordsLength(words) + words.length - 1;
        StringBuilder stringBuilder = new StringBuilder(totalLength);
        for (String word : words) {
            NamingFormatImpls.appendAllUpper(stringBuilder, word);
            if (stringBuilder.length() >= totalLength) continue;
            stringBuilder.append(joiner);
        }
        return stringBuilder.toString();
    }

    private static String joinCapitalized(char joiner, String[] words) {
        if (words.length == 0) {
            return "";
        }
        int totalLength = NamingFormatImpls.countTotalWordsLength(words) + words.length - 1;
        StringBuilder stringBuilder = new StringBuilder(totalLength);
        for (String word : words) {
            NamingFormatImpls.appendCapitalized(stringBuilder, word);
            if (stringBuilder.length() >= totalLength) continue;
            stringBuilder.append(joiner);
        }
        return stringBuilder.toString();
    }

    private static int countTotalWordsLength(String[] words) {
        if (words.length == 0) {
            return 0;
        }
        int totalLength = 0;
        for (String word : words) {
            totalLength += word.length();
        }
        return totalLength;
    }

    private static void appendAllLower(StringBuilder target, CharSequence input) {
        if (input.length() == 0) {
            return;
        }
        PrimitiveIterator.OfInt codePointIterator = input.codePoints().iterator();
        while (codePointIterator.hasNext()) {
            target.appendCodePoint(Character.toLowerCase(codePointIterator.nextInt()));
        }
    }

    private static void appendAllUpper(StringBuilder target, CharSequence input) {
        if (input.length() == 0) {
            return;
        }
        PrimitiveIterator.OfInt codePointIterator = input.codePoints().iterator();
        while (codePointIterator.hasNext()) {
            target.appendCodePoint(Character.toUpperCase(codePointIterator.nextInt()));
        }
    }

    private static void appendCapitalized(StringBuilder target, CharSequence input) {
        if (input.length() == 0) {
            return;
        }
        PrimitiveIterator.OfInt codePointIterator = input.codePoints().iterator();
        target.appendCodePoint(Character.toUpperCase(codePointIterator.nextInt()));
        while (codePointIterator.hasNext()) {
            target.appendCodePoint(Character.toLowerCase(codePointIterator.nextInt()));
        }
    }
}

