package de.siphalor.tweed5.dataapi.api;

import org.jspecify.annotations.Nullable;

public class TweedDataReadException extends Exception {
	@Nullable
	private final TweedDataReaderRecoverMode recoverMode;

	protected TweedDataReadException(String message, Throwable cause, @Nullable TweedDataReaderRecoverMode recoverMode) {
		super(message, cause);
		this.recoverMode = recoverMode;
	}

	public boolean canRecover() {
		return recoverMode != null;
	}

	public static Builder builder() {
		return new Builder();
	}


	public static class Builder {
		private String message;
		private Throwable cause;
		@Nullable
		private TweedDataReaderRecoverMode recoverMode;

		public TweedDataReadException build() {
			return new TweedDataReadException(message, cause, recoverMode);
		}

		public Builder recoverable(TweedDataReaderRecoverMode recoverMode) {
			this.recoverMode = recoverMode;
			return this;
		}

		/**
		 * @return {@code this}.
		 */
		public TweedDataReadException.Builder message(final String message) {
			this.message = message;
			return this;
		}

		/**
		 * @return {@code this}.
		 */
		public TweedDataReadException.Builder cause(final Throwable cause) {
			this.cause = cause;
			return this;
		}
	}

	@Nullable
	public TweedDataReaderRecoverMode recoverMode() {
		return this.recoverMode;
	}
}
