/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.dataapi.api;

import de.siphalor.tweed5.dataapi.api.TweedDataUnsupportedValueException;
import de.siphalor.tweed5.dataapi.api.decoration.TweedDataDecoration;
import org.jspecify.annotations.Nullable;

public interface TweedDataVisitor {
    public void visitNull();

    public void visitBoolean(boolean var1);

    public void visitByte(byte var1);

    public void visitShort(short var1);

    public void visitInt(int var1);

    public void visitLong(long var1);

    public void visitFloat(float var1);

    public void visitDouble(double var1);

    public void visitString(String var1);

    default public void visitValue(@Nullable Object value) throws TweedDataUnsupportedValueException {
        if (value == null) {
            this.visitNull();
        } else if (value instanceof Boolean) {
            this.visitBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.visitByte((Byte)value);
        } else if (value instanceof Short) {
            this.visitShort((Short)value);
        } else if (value instanceof Integer) {
            this.visitInt((Integer)value);
        } else if (value instanceof Long) {
            this.visitLong((Long)value);
        } else if (value instanceof Float) {
            this.visitFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.visitDouble((Double)value);
        } else if (value instanceof String) {
            this.visitString((String)value);
        } else {
            throw new TweedDataUnsupportedValueException(value);
        }
    }

    default public void visitEmptyList() {
        this.visitListStart();
        this.visitListEnd();
    }

    public void visitListStart();

    public void visitListEnd();

    default public void visitEmptyMap() {
        this.visitMapStart();
        this.visitMapEnd();
    }

    public void visitMapStart();

    public void visitMapEntryKey(String var1);

    public void visitMapEnd();

    public void visitDecoration(TweedDataDecoration var1);
}

