package de.siphalor.tweed5.data.extension.impl;

import de.siphalor.tweed5.data.extension.api.ReadWriteExtension;
import de.siphalor.tweed5.data.extension.api.TweedReadContext;
import de.siphalor.tweed5.data.extension.api.TweedWriteContext;
import de.siphalor.tweed5.patchwork.api.Patchwork;

public final class TweedReadWriteContextImpl implements TweedReadContext, TweedWriteContext {
	private final ReadWriteExtension readWriteExtension;
	private final Patchwork extensionsData;

	public TweedReadWriteContextImpl(final ReadWriteExtension readWriteExtension, final Patchwork extensionsData) {
		this.readWriteExtension = readWriteExtension;
		this.extensionsData = extensionsData;
	}

	public ReadWriteExtension readWriteExtension() {
		return this.readWriteExtension;
	}

	public Patchwork extensionsData() {
		return this.extensionsData;
	}

	@Override
	public boolean equals(final Object o) {
		if (o == this) return true;
		if (!(o instanceof TweedReadWriteContextImpl)) return false;
		final TweedReadWriteContextImpl other = (TweedReadWriteContextImpl) o;
		final Object this$readWriteExtension = this.readWriteExtension();
		final Object other$readWriteExtension = other.readWriteExtension();
		if (this$readWriteExtension == null ? other$readWriteExtension != null : !this$readWriteExtension.equals(other$readWriteExtension)) return false;
		final Object this$extensionsData = this.extensionsData();
		final Object other$extensionsData = other.extensionsData();
		if (this$extensionsData == null ? other$extensionsData != null : !this$extensionsData.equals(other$extensionsData)) return false;
		return true;
	}

	@Override
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		final Object $readWriteExtension = this.readWriteExtension();
		result = result * PRIME + ($readWriteExtension == null ? 43 : $readWriteExtension.hashCode());
		final Object $extensionsData = this.extensionsData();
		result = result * PRIME + ($extensionsData == null ? 43 : $extensionsData.hashCode());
		return result;
	}

	@Override
	public String toString() {
		return "TweedReadWriteContextImpl(readWriteExtension=" + this.readWriteExtension() + ", extensionsData=" + this.extensionsData() + ")";
	}
}
