/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.data.gson;

import com.google.gson.stream.JsonWriter;
import de.siphalor.tweed5.dataapi.api.TweedDataWriteException;
import de.siphalor.tweed5.dataapi.api.TweedDataWriter;
import de.siphalor.tweed5.dataapi.api.decoration.TweedDataCommentDecoration;
import de.siphalor.tweed5.dataapi.api.decoration.TweedDataDecoration;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class GsonWriter
implements TweedDataWriter {
    private final JsonWriter writer;
    private final Deque<Context> contextStack = new ArrayDeque<Context>();
    private final List<String> deferredFieldComments = new ArrayList<String>();

    public GsonWriter(JsonWriter writer) {
        this.writer = writer;
        this.contextStack.push(Context.VALUE);
    }

    public void visitNull() {
        try {
            this.writer.nullValue();
            this.afterValueWritten();
        }
        catch (IOException e) {
            throw this.createWriteExceptionFromIoException(e);
        }
    }

    public void visitBoolean(boolean value) {
        try {
            this.writer.value(value);
            this.afterValueWritten();
        }
        catch (IOException e) {
            throw this.createWriteExceptionFromIoException(e);
        }
    }

    public void visitByte(byte value) {
        try {
            this.writer.value((long)value);
            this.afterValueWritten();
        }
        catch (IOException e) {
            throw this.createWriteExceptionFromIoException(e);
        }
    }

    public void visitShort(short value) {
        try {
            this.writer.value((long)value);
            this.afterValueWritten();
        }
        catch (IOException e) {
            throw this.createWriteExceptionFromIoException(e);
        }
    }

    public void visitInt(int value) {
        try {
            this.writer.value((long)value);
            this.afterValueWritten();
        }
        catch (IOException e) {
            throw this.createWriteExceptionFromIoException(e);
        }
    }

    public void visitLong(long value) {
        try {
            this.writer.value(value);
            this.afterValueWritten();
        }
        catch (IOException e) {
            throw this.createWriteExceptionFromIoException(e);
        }
    }

    public void visitFloat(float value) {
        try {
            this.writer.value(value);
            this.afterValueWritten();
        }
        catch (IOException e) {
            throw this.createWriteExceptionFromIoException(e);
        }
    }

    public void visitDouble(double value) {
        try {
            this.writer.value(value);
            this.afterValueWritten();
        }
        catch (IOException e) {
            throw this.createWriteExceptionFromIoException(e);
        }
    }

    public void visitString(String value) {
        try {
            this.writer.value(value);
            this.afterValueWritten();
        }
        catch (IOException e) {
            throw this.createWriteExceptionFromIoException(e);
        }
    }

    public void visitListStart() {
        try {
            this.writer.beginArray();
            this.contextStack.push(Context.LIST);
        }
        catch (IOException e) {
            throw this.createWriteExceptionFromIoException(e);
        }
    }

    public void visitListEnd() {
        try {
            this.writer.endArray();
            this.popContext(Context.LIST);
            this.afterValueWritten();
        }
        catch (IOException e) {
            throw this.createWriteExceptionFromIoException(e);
        }
    }

    public void visitMapStart() {
        try {
            this.writer.beginObject();
            this.contextStack.push(Context.MAP);
        }
        catch (IOException e) {
            throw this.createWriteExceptionFromIoException(e);
        }
    }

    public void visitMapEntryKey(String key) {
        try {
            if (!this.deferredFieldComments.isEmpty()) {
                this.writer.name(key + "__comment");
                if (this.deferredFieldComments.size() == 1) {
                    this.writer.value(this.deferredFieldComments.get(0));
                } else {
                    this.writer.beginArray();
                    for (String comment : this.deferredFieldComments) {
                        this.writer.value(comment);
                    }
                    this.writer.endArray();
                }
                this.deferredFieldComments.clear();
            }
            this.writer.name(key);
            this.contextStack.push(Context.VALUE);
        }
        catch (IOException e) {
            throw this.createWriteExceptionFromIoException(e);
        }
    }

    public void visitMapEnd() {
        try {
            this.writer.endObject();
            this.popContext(Context.MAP);
            this.afterValueWritten();
        }
        catch (IOException e) {
            throw this.createWriteExceptionFromIoException(e);
        }
    }

    public void visitDecoration(TweedDataDecoration decoration) {
        if (decoration instanceof TweedDataCommentDecoration && this.peekContext() == Context.MAP) {
            this.appendDeferredComment(((TweedDataCommentDecoration)decoration).comment());
        }
    }

    private void appendDeferredComment(String comment) {
        int index = 0;
        while (true) {
            int next;
            if ((next = comment.indexOf(10, index)) == -1) break;
            this.deferredFieldComments.add(comment.substring(index, next));
            index = next + 1;
        }
        this.deferredFieldComments.add(comment.substring(index));
    }

    public void close() throws Exception {
        this.writer.close();
    }

    private void afterValueWritten() {
        if (this.peekContext() == Context.VALUE) {
            this.contextStack.pop();
        }
    }

    private void popContext(Context expectedContext) {
        Context context = this.contextStack.pop();
        if (context != expectedContext) {
            throw new TweedDataWriteException("Unexpected context " + (Object)((Object)context) + " when popping " + (Object)((Object)expectedContext));
        }
    }

    private Context peekContext() {
        Context context = this.contextStack.peek();
        if (context == null) {
            throw new TweedDataWriteException("Tried to read context but currently not in any context");
        }
        return context;
    }

    private TweedDataWriteException createWriteExceptionFromIoException(IOException e) {
        return new TweedDataWriteException("Error writing data using Gson", (Throwable)e);
    }

    private static enum Context {
        VALUE,
        LIST,
        MAP;

    }
}

