/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.data.hjson;

import de.siphalor.tweed5.data.hjson.HjsonLexer;
import de.siphalor.tweed5.data.hjson.HjsonLexerToken;
import de.siphalor.tweed5.dataapi.api.TweedDataReadException;
import de.siphalor.tweed5.dataapi.api.TweedDataReader;
import de.siphalor.tweed5.dataapi.api.TweedDataReaderRecoverMode;
import de.siphalor.tweed5.dataapi.api.TweedDataToken;
import de.siphalor.tweed5.dataapi.api.TweedDataTokens;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;

public class HjsonReader
implements TweedDataReader {
    private final HjsonLexer lexer;
    private final Deque<Context> contexts;
    private State state = State.BEFORE_VALUE;
    private @Nullable HjsonLexerToken peekedLexerToken;
    private @Nullable TweedDataToken peekedToken;

    public HjsonReader(HjsonLexer lexer) {
        this.lexer = lexer;
        this.contexts = new LinkedList<Context>();
        this.contexts.push(Context.VALUE);
    }

    public TweedDataToken peekToken() throws TweedDataReadException {
        if (this.peekedToken == null) {
            this.peekedToken = this.nextToken();
        }
        return this.peekedToken;
    }

    public TweedDataToken readToken() throws TweedDataReadException {
        if (this.peekedToken != null) {
            TweedDataToken token = this.peekedToken;
            this.peekedToken = null;
            return token;
        }
        return this.nextToken();
    }

    private TweedDataToken nextToken() throws TweedDataReadException {
        Context currentContext = this.currentContext();
        switch (currentContext.ordinal()) {
            case 2: {
                return this.nextObjectToken();
            }
            case 1: {
                return this.nextListToken();
            }
            case 0: {
                return this.nextValueToken();
            }
        }
        throw new IllegalStateException("Illegal context " + (Object)((Object)currentContext));
    }

    private TweedDataToken nextObjectToken() throws TweedDataReadException {
        HjsonLexerToken lexerToken;
        if (this.state == State.AFTER_OBJECT_KEY) {
            this.chompLineFeedTokensInGeneral();
            lexerToken = this.eatGeneralLexerToken();
            if (lexerToken.type() == HjsonLexerToken.Type.COLON) {
                this.state = State.BEFORE_VALUE;
            } else {
                throw this.createIllegalTokenException(lexerToken, HjsonLexerToken.Type.COLON);
            }
        }
        if (this.state == State.BEFORE_VALUE) {
            return TweedDataTokens.asMapEntryValue((TweedDataToken)this.nextValueToken());
        }
        if (this.state == State.AFTER_VALUE) {
            lexerToken = this.eatGeneralLexerToken();
            if (lexerToken.type() == HjsonLexerToken.Type.BRACE_CLOSE) {
                this.contexts.pop();
                this.state = State.AFTER_VALUE;
                return this.wrapValueLikeTokenContextAppropriate(TweedDataTokens.getMapEnd());
            }
            if (lexerToken.type() == HjsonLexerToken.Type.LINE_FEED || lexerToken.type() == HjsonLexerToken.Type.COMMA) {
                this.state = State.BEFORE_OBJECT_KEY;
            } else {
                throw this.createIllegalTokenException(lexerToken, HjsonLexerToken.Type.BRACE_CLOSE, HjsonLexerToken.Type.LINE_FEED, HjsonLexerToken.Type.COMMA);
            }
        }
        if (this.state == State.BEFORE_OBJECT_KEY) {
            this.chompLineFeedTokensInObject();
            lexerToken = this.eatObjectLexerToken();
            if (lexerToken.type() == HjsonLexerToken.Type.BRACE_CLOSE) {
                this.contexts.pop();
                this.state = State.AFTER_VALUE;
                return this.wrapValueLikeTokenContextAppropriate(TweedDataTokens.getMapEnd());
            }
            if (lexerToken.type() == HjsonLexerToken.Type.QUOTELESS_STRING || lexerToken.type() == HjsonLexerToken.Type.JSON_STRING) {
                this.state = State.AFTER_OBJECT_KEY;
                return TweedDataTokens.asMapEntryKey((TweedDataToken)this.createStringToken(lexerToken));
            }
            throw this.createIllegalTokenException(lexerToken, HjsonLexerToken.Type.BRACE_CLOSE, HjsonLexerToken.Type.QUOTELESS_STRING, HjsonLexerToken.Type.JSON_STRING);
        }
        throw this.createIllegalStateException();
    }

    private TweedDataToken nextListToken() throws TweedDataReadException {
        HjsonLexerToken lexerToken;
        if (this.state == State.AFTER_VALUE) {
            lexerToken = this.eatGeneralLexerToken();
            if (lexerToken.type() == HjsonLexerToken.Type.BRACKET_CLOSE) {
                this.contexts.pop();
                this.state = State.AFTER_VALUE;
                return this.wrapValueLikeTokenContextAppropriate(TweedDataTokens.getListEnd());
            }
            if (lexerToken.type() == HjsonLexerToken.Type.COMMA || lexerToken.type() == HjsonLexerToken.Type.LINE_FEED) {
                this.state = State.BEFORE_VALUE;
            } else {
                throw this.createIllegalTokenException(lexerToken, HjsonLexerToken.Type.BRACKET_CLOSE, HjsonLexerToken.Type.COMMA, HjsonLexerToken.Type.LINE_FEED);
            }
        }
        if (this.state == State.BEFORE_VALUE) {
            this.chompLineFeedTokensInGeneral();
            lexerToken = this.peekGeneralLexerToken();
            if (lexerToken.type() == HjsonLexerToken.Type.BRACKET_CLOSE) {
                this.eatGeneralLexerToken();
                this.contexts.pop();
                this.state = State.AFTER_VALUE;
                return this.wrapValueLikeTokenContextAppropriate(TweedDataTokens.getListEnd());
            }
            return TweedDataTokens.asListValue((TweedDataToken)this.nextValueToken());
        }
        throw this.createIllegalStateException();
    }

    private TweedDataToken nextValueToken() throws TweedDataReadException {
        this.chompLineFeedTokensInGeneral();
        HjsonLexerToken lexerToken = this.eatGeneralLexerToken();
        switch (lexerToken.type()) {
            case NULL: {
                this.state = State.AFTER_VALUE;
                return this.wrapValueLikeTokenContextAppropriate(TweedDataTokens.getNull());
            }
            case TRUE: 
            case FALSE: {
                this.state = State.AFTER_VALUE;
                return this.wrapValueLikeTokenContextAppropriate(this.createBooleanToken(lexerToken));
            }
            case NUMBER: {
                this.state = State.AFTER_VALUE;
                return this.wrapValueLikeTokenContextAppropriate(this.createNumberToken(lexerToken));
            }
            case QUOTELESS_STRING: 
            case JSON_STRING: 
            case MULTILINE_STRING: {
                this.state = State.AFTER_VALUE;
                return this.wrapValueLikeTokenContextAppropriate(this.createStringToken(lexerToken));
            }
            case BRACKET_OPEN: {
                this.state = State.BEFORE_VALUE;
                TweedDataToken token = this.wrapValueLikeTokenContextAppropriate(TweedDataTokens.getListStart());
                this.contexts.push(Context.LIST);
                return token;
            }
            case BRACE_OPEN: {
                this.state = State.BEFORE_OBJECT_KEY;
                TweedDataToken token = this.wrapValueLikeTokenContextAppropriate(TweedDataTokens.getMapStart());
                this.contexts.push(Context.OBJECT);
                return token;
            }
        }
        throw this.createIllegalTokenException(lexerToken, HjsonLexerToken.Type.NULL, HjsonLexerToken.Type.TRUE, HjsonLexerToken.Type.FALSE, HjsonLexerToken.Type.NUMBER, HjsonLexerToken.Type.QUOTELESS_STRING, HjsonLexerToken.Type.JSON_STRING, HjsonLexerToken.Type.MULTILINE_STRING, HjsonLexerToken.Type.BRACKET_OPEN, HjsonLexerToken.Type.BRACE_OPEN);
    }

    private void chompLineFeedTokensInGeneral() throws TweedDataReadException {
        while (this.peekGeneralLexerToken().type() == HjsonLexerToken.Type.LINE_FEED) {
            this.eatGeneralLexerToken();
        }
    }

    private void chompLineFeedTokensInObject() throws TweedDataReadException {
        while (this.peekObjectLexerToken().type() == HjsonLexerToken.Type.LINE_FEED) {
            this.eatObjectLexerToken();
        }
    }

    private TweedDataToken createBooleanToken(final HjsonLexerToken lexerToken) {
        return new TweedDataToken(){
            final /* synthetic */ HjsonReader this$0;
            {
                this.this$0 = this$0;
            }

            public boolean canReadAsBoolean() {
                return true;
            }

            public boolean readAsBoolean() {
                return lexerToken.type() == HjsonLexerToken.Type.TRUE;
            }

            public String toString() {
                return "HJSON boolean token [" + lexerToken + "]";
            }
        };
    }

    @NullUnmarked
    private TweedDataToken createNumberToken(final HjsonLexerToken lexerToken) {
        assert (lexerToken.content() != null);
        return new TweedDataToken(){
            private Long tryLong;
            private Double tryDouble;
            private boolean fraction;
            private boolean mantissaTooLarge;
            private boolean exponentTooLarge;
            final /* synthetic */ HjsonReader this$0;
            {
                this.this$0 = this$0;
            }

            public boolean canReadAsByte() {
                this.tryReadLong();
                return this.isValidIntegerValue(-128L, 127L);
            }

            public byte readAsByte() throws TweedDataReadException {
                this.tryReadLong();
                this.requireValidIntegerValue(-128L, 127L);
                return this.tryLong.byteValue();
            }

            public boolean canReadAsShort() {
                this.tryReadLong();
                return this.isValidIntegerValue(-32768L, 32767L);
            }

            public short readAsShort() throws TweedDataReadException {
                this.tryReadLong();
                this.requireValidIntegerValue(-32768L, 32767L);
                return this.tryLong.shortValue();
            }

            public boolean canReadAsInt() {
                this.tryReadLong();
                return this.isValidIntegerValue(Integer.MIN_VALUE, Integer.MAX_VALUE);
            }

            public int readAsInt() throws TweedDataReadException {
                this.tryReadLong();
                this.requireValidIntegerValue(Integer.MIN_VALUE, Integer.MAX_VALUE);
                return this.tryLong.intValue();
            }

            public boolean canReadAsLong() {
                this.tryReadLong();
                return !this.mantissaTooLarge && !this.exponentTooLarge && !this.fraction;
            }

            public long readAsLong() throws TweedDataReadException {
                this.tryReadLong();
                this.requireValidIntegerValue(Long.MIN_VALUE, Long.MAX_VALUE);
                return this.tryLong;
            }

            private boolean isValidIntegerValue(long min, long max) {
                return !this.mantissaTooLarge && !this.exponentTooLarge && !this.fraction && this.tryLong != null && this.tryLong >= min && this.tryLong <= max;
            }

            private void requireValidIntegerValue(long min, long max) throws TweedDataReadException {
                if (this.mantissaTooLarge) {
                    throw TweedDataReadException.builder().message("Mantissa of number is too large! (" + lexerToken + ")").recoverable(TweedDataReaderRecoverMode.SKIP).build();
                }
                if (this.exponentTooLarge) {
                    throw TweedDataReadException.builder().message("Exponent of number is too large! (" + lexerToken + ")").recoverable(TweedDataReaderRecoverMode.SKIP).build();
                }
                if (this.fraction) {
                    throw TweedDataReadException.builder().message("Fractional number cannot be read as non-fractional! (" + lexerToken + ")").recoverable(TweedDataReaderRecoverMode.SKIP).build();
                }
                if (this.tryLong < min) {
                    throw TweedDataReadException.builder().message("Number is too low for data type, minimum is " + min + " at " + lexerToken).recoverable(TweedDataReaderRecoverMode.SKIP).build();
                }
                if (this.tryLong > max) {
                    throw TweedDataReadException.builder().message("Number is too large for data type, maximum is " + max + " at " + lexerToken).recoverable(TweedDataReaderRecoverMode.SKIP).build();
                }
            }

            private void tryReadLong() {
                if (this.tryLong != null) {
                    return;
                }
                PrimitiveIterator.OfInt iterator = lexerToken.content().codePoints().iterator();
                long sign = 1L;
                int codePoint = iterator.nextInt();
                if (codePoint == 45) {
                    sign = -1L;
                    codePoint = iterator.nextInt();
                }
                int fractionDigits = 0;
                try {
                    this.tryLong = 0L;
                    boolean inFraction = false;
                    do {
                        this.tryLong = Math.addExact(Math.multiplyExact((long)this.tryLong, 10L), (long)(codePoint - 48));
                        if (inFraction) {
                            ++fractionDigits;
                        }
                        if (!iterator.hasNext()) {
                            this.tryLong = this.tryLong * sign;
                            if (fractionDigits > 0) {
                                this.fraction = true;
                            }
                            return;
                        }
                        codePoint = iterator.nextInt();
                        if (inFraction || codePoint != 46) continue;
                        inFraction = true;
                        codePoint = iterator.nextInt();
                    } while (this.isDigit(codePoint));
                    this.tryLong = this.tryLong * sign;
                }
                catch (ArithmeticException ignored) {
                    this.mantissaTooLarge = true;
                    return;
                }
                int exponent = 0;
                if (codePoint == 101 || codePoint == 69) {
                    codePoint = iterator.nextInt();
                    boolean negativeExponent = false;
                    if (codePoint == 43) {
                        codePoint = iterator.nextInt();
                    } else if (codePoint == 45) {
                        codePoint = iterator.nextInt();
                        negativeExponent = true;
                    }
                    try {
                        while (true) {
                            exponent = Math.addExact(Math.multiplyExact(exponent, 10), codePoint - 48);
                            if (!iterator.hasNext()) break;
                            codePoint = iterator.nextInt();
                        }
                        if (negativeExponent) {
                            exponent = -exponent;
                        }
                    }
                    catch (ArithmeticException ignored) {
                        this.exponentTooLarge = true;
                    }
                }
                this.applyLongExponent(exponent -= fractionDigits);
            }

            private void applyLongExponent(int exponent) {
                if (exponent < 0) {
                    long factor = 1L;
                    while (exponent < 0) {
                        factor *= 10L;
                        ++exponent;
                    }
                    if (this.tryLong != this.tryLong / factor * factor) {
                        this.fraction = true;
                        return;
                    }
                    this.tryLong = this.tryLong / factor;
                } else {
                    try {
                        while (exponent > 0) {
                            this.tryLong = Math.multiplyExact((long)this.tryLong, 10L);
                            --exponent;
                        }
                    }
                    catch (ArithmeticException ignored) {
                        this.exponentTooLarge = true;
                    }
                }
            }

            public boolean canReadAsFloat() {
                this.tryReadDouble();
                return Float.isFinite(this.tryDouble.floatValue());
            }

            public float readAsFloat() throws TweedDataReadException {
                this.tryReadDouble();
                float value = this.tryDouble.floatValue();
                if (Float.isInfinite(value)) {
                    throw TweedDataReadException.builder().message("Number is out of range from -3.4028235E38 to 3.4028235E38 at " + lexerToken).recoverable(TweedDataReaderRecoverMode.SKIP).build();
                }
                return value;
            }

            public boolean canReadAsDouble() {
                this.tryReadDouble();
                return Double.isFinite(this.tryDouble);
            }

            public double readAsDouble() throws TweedDataReadException {
                this.tryReadDouble();
                if (Double.isInfinite(this.tryDouble)) {
                    throw TweedDataReadException.builder().message("Number is out of range form -1.7976931348623157E308 to 1.7976931348623157E308 at " + lexerToken).recoverable(TweedDataReaderRecoverMode.SKIP).build();
                }
                return this.tryDouble;
            }

            private void tryReadDouble() {
                double factor;
                if (this.tryDouble != null) {
                    return;
                }
                boolean negative = false;
                PrimitiveIterator.OfInt iterator = lexerToken.content().codePoints().iterator();
                int codePoint = iterator.nextInt();
                if (codePoint == 45) {
                    negative = true;
                    codePoint = iterator.nextInt();
                }
                double value = 0.0;
                while (this.isDigit(codePoint)) {
                    value = value * 10.0 + (double)(codePoint - 48);
                    if (!iterator.hasNext()) {
                        this.tryDouble = negative ? -1.0 * value : value;
                        return;
                    }
                    codePoint = iterator.nextInt();
                }
                if (codePoint == 46) {
                    factor = 0.1;
                    while (this.isDigit(codePoint = iterator.nextInt())) {
                        value += factor * (double)(codePoint - 48);
                        factor /= 10.0;
                        if (iterator.hasNext()) continue;
                    }
                }
                if (codePoint == 101 || codePoint == 69) {
                    codePoint = iterator.nextInt();
                    factor = 10.0;
                    if (codePoint == 45) {
                        factor = 0.1;
                        codePoint = iterator.nextInt();
                    } else if (codePoint == 43) {
                        codePoint = iterator.nextInt();
                    }
                    double exponent = 0.0;
                    while (this.isDigit(codePoint)) {
                        exponent = exponent * 10.0 + (double)(codePoint - 48);
                        if (!iterator.hasNext()) break;
                        codePoint = iterator.nextInt();
                    }
                    factor = Math.pow(factor, exponent);
                    value *= factor;
                }
                this.tryDouble = value;
            }

            private boolean isDigit(int codePoint) {
                return codePoint >= 48 && codePoint <= 57;
            }

            public String toString() {
                return "HJSON numeric token [" + lexerToken + "]";
            }
        };
    }

    private TweedDataToken createStringToken(final HjsonLexerToken lexerToken) {
        assert (lexerToken.content() != null);
        return new TweedDataToken(){
            final /* synthetic */ HjsonReader this$0;
            {
                this.this$0 = this$0;
            }

            public boolean canReadAsString() {
                return true;
            }

            public String readAsString() throws TweedDataReadException {
                if (lexerToken.type() == HjsonLexerToken.Type.QUOTELESS_STRING || lexerToken.type() == HjsonLexerToken.Type.MULTILINE_STRING) {
                    return Objects.requireNonNull(lexerToken.contentString());
                }
                if (lexerToken.type() == HjsonLexerToken.Type.JSON_STRING) {
                    return this.readJsonString(lexerToken.content());
                }
                throw TweedDataReadException.builder().message("Unrecognized string token").recoverable(TweedDataReaderRecoverMode.SKIP).build();
            }

            private String readJsonString(CharSequence input) throws TweedDataReadException {
                PrimitiveIterator.OfInt iterator = input.codePoints().iterator();
                int quoteCodePoint = iterator.nextInt();
                boolean escaped = false;
                StringBuilder stringBuilder = new StringBuilder();
                while (true) {
                    int codePoint = iterator.nextInt();
                    if (escaped) {
                        escaped = false;
                        codePoint = this.getUnescapedCodePoint(codePoint);
                    } else {
                        if (codePoint == quoteCodePoint) break;
                        if (codePoint == 92) {
                            escaped = true;
                        }
                    }
                    stringBuilder.appendCodePoint(codePoint);
                }
                return stringBuilder.toString();
            }

            private int getUnescapedCodePoint(int codePoint) throws TweedDataReadException {
                switch (codePoint) {
                    case 110: {
                        return 10;
                    }
                    case 114: {
                        return 13;
                    }
                    case 116: {
                        return 9;
                    }
                    case 102: {
                        return 12;
                    }
                    case 98: {
                        return 8;
                    }
                    case 34: 
                    case 39: 
                    case 47: 
                    case 92: {
                        return codePoint;
                    }
                }
                throw TweedDataReadException.builder().message("Illegal escape sequence \"\\" + String.copyValueOf(Character.toChars(codePoint)) + "\" in string " + lexerToken).recoverable(TweedDataReaderRecoverMode.SKIP).build();
            }

            public String toString() {
                return "HJSON string token [" + lexerToken + "]";
            }
        };
    }

    private TweedDataReadException createIllegalTokenException(HjsonLexerToken actualToken, HjsonLexerToken.Type ... expected) {
        return TweedDataReadException.builder().message("Illegal token " + actualToken + ", expected any of " + Arrays.stream(expected).map(Objects::toString).collect(Collectors.joining(", "))).build();
    }

    private TweedDataReadException createIllegalStateException() {
        return TweedDataReadException.builder().message("Internal Error: Parser is in illegal state " + (Object)((Object)this.state) + " in context " + (Object)((Object)this.currentContext())).build();
    }

    private HjsonLexerToken peekGeneralLexerToken() throws TweedDataReadException {
        if (this.peekedLexerToken == null) {
            this.peekedLexerToken = this.lexer.nextGeneralToken();
        }
        return this.peekedLexerToken;
    }

    private HjsonLexerToken peekObjectLexerToken() throws TweedDataReadException {
        if (this.peekedLexerToken == null) {
            this.peekedLexerToken = this.lexer.nextInnerObjectToken();
        }
        return this.peekedLexerToken;
    }

    private HjsonLexerToken eatGeneralLexerToken() throws TweedDataReadException {
        if (this.peekedLexerToken != null) {
            HjsonLexerToken token = this.peekedLexerToken;
            this.peekedLexerToken = null;
            return token;
        }
        return this.lexer.nextGeneralToken();
    }

    private HjsonLexerToken eatObjectLexerToken() throws TweedDataReadException {
        if (this.peekedLexerToken != null) {
            HjsonLexerToken token = this.peekedLexerToken;
            this.peekedLexerToken = null;
            return token;
        }
        return this.lexer.nextInnerObjectToken();
    }

    private TweedDataToken wrapValueLikeTokenContextAppropriate(TweedDataToken token) {
        if (this.currentContext() == Context.LIST) {
            return TweedDataTokens.asListValue((TweedDataToken)token);
        }
        if (this.currentContext() == Context.OBJECT) {
            return TweedDataTokens.asMapEntryValue((TweedDataToken)token);
        }
        return token;
    }

    private Context currentContext() {
        assert (this.contexts.peek() != null);
        return this.contexts.peek();
    }

    public void close() throws Exception {
        this.lexer.close();
    }

    private static enum State {
        BEFORE_VALUE,
        AFTER_VALUE,
        BEFORE_OBJECT_KEY,
        AFTER_OBJECT_KEY;

    }

    private static enum Context {
        VALUE,
        LIST,
        OBJECT;

    }
}

