package de.siphalor.tweed5.data.hjson;

import lombok.EqualsAndHashCode;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

@ApiStatus.Internal
public final class HjsonLexerToken {
	private final Type type;
	private final HjsonReadPosition begin;
	private final HjsonReadPosition end;
	@Nullable
	private final CharSequence content;

	@Nullable
	public String contentString() {
		return content == null ? null : content.toString();
	}

	public String toString() {
		StringBuilder stringBuilder = new StringBuilder();
		stringBuilder.append(type.toString());
		if (content != null) {
			stringBuilder.append(" (\"");
			stringBuilder.append(content);
			stringBuilder.append("\")");
		}
		stringBuilder.append(" at ");
		stringBuilder.append(begin);
		if (!begin.equals(end)) {
			stringBuilder.append(" to ");
			stringBuilder.append(end);
		}
		return stringBuilder.toString();
	}


	enum Type {
		EOF, BRACKET_OPEN, BRACKET_CLOSE, BRACE_OPEN, BRACE_CLOSE, COMMA, COLON, LINE_FEED, NULL, TRUE, FALSE, NUMBER, QUOTELESS_STRING, JSON_STRING, MULTILINE_STRING;
	}

	public HjsonLexerToken(final Type type, final HjsonReadPosition begin, final HjsonReadPosition end, @Nullable final CharSequence content) {
		this.type = type;
		this.begin = begin;
		this.end = end;
		this.content = content;
	}

	public Type type() {
		return this.type;
	}

	public HjsonReadPosition begin() {
		return this.begin;
	}

	public HjsonReadPosition end() {
		return this.end;
	}

	@Nullable
	public CharSequence content() {
		return this.content;
	}

	@Override
	public boolean equals(final Object o) {
		if (o == this) return true;
		if (!(o instanceof HjsonLexerToken)) return false;
		final HjsonLexerToken other = (HjsonLexerToken) o;
		final Object this$type = this.type();
		final Object other$type = other.type();
		if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
		final Object this$begin = this.begin();
		final Object other$begin = other.begin();
		if (this$begin == null ? other$begin != null : !this$begin.equals(other$begin)) return false;
		final Object this$end = this.end();
		final Object other$end = other.end();
		if (this$end == null ? other$end != null : !this$end.equals(other$end)) return false;
		final Object this$$contentString = this.contentString();
		final Object other$$contentString = other.contentString();
		if (this$$contentString == null ? other$$contentString != null : !this$$contentString.equals(other$$contentString)) return false;
		return true;
	}

	@Override
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		final Object $type = this.type();
		result = result * PRIME + ($type == null ? 43 : $type.hashCode());
		final Object $begin = this.begin();
		result = result * PRIME + ($begin == null ? 43 : $begin.hashCode());
		final Object $end = this.end();
		result = result * PRIME + ($end == null ? 43 : $end.hashCode());
		final Object $$contentString = this.contentString();
		result = result * PRIME + ($$contentString == null ? 43 : $$contentString.hashCode());
		return result;
	}
}
