/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.data.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import de.siphalor.tweed5.dataapi.api.TweedDataReadException;
import de.siphalor.tweed5.dataapi.api.TweedDataReader;
import de.siphalor.tweed5.dataapi.api.TweedDataToken;
import de.siphalor.tweed5.dataapi.api.TweedDataTokens;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jspecify.annotations.Nullable;

public class JacksonReader
implements TweedDataReader {
    private final JsonParser parser;
    private final Deque<Context> contextStack = new ArrayDeque<Context>();
    private @Nullable TweedDataToken peekedToken;

    public JacksonReader(JsonParser parser) {
        this.parser = parser;
        this.contextStack.push(Context.VALUE);
    }

    public TweedDataToken peekToken() throws TweedDataReadException {
        if (this.peekedToken == null) {
            this.peekedToken = this.nextToken();
        }
        return this.peekedToken;
    }

    public TweedDataToken readToken() throws TweedDataReadException {
        if (this.peekedToken != null) {
            TweedDataToken token = this.peekedToken;
            this.peekedToken = null;
            return token;
        }
        return this.nextToken();
    }

    private TweedDataToken nextToken() throws TweedDataReadException {
        try {
            JsonToken jsonToken = this.parser.nextToken();
            switch (jsonToken) {
                case START_ARRAY: {
                    TweedDataToken token = this.wrapToken(TweedDataTokens.getListStart());
                    this.contextStack.push(Context.LIST);
                    return token;
                }
                case END_ARRAY: {
                    this.popContext(Context.LIST);
                    TweedDataToken token = this.wrapToken(TweedDataTokens.getListEnd());
                    this.afterValueRead();
                    return token;
                }
                case START_OBJECT: {
                    TweedDataToken token = this.wrapToken(TweedDataTokens.getMapStart());
                    this.contextStack.push(Context.MAP);
                    return token;
                }
                case END_OBJECT: {
                    this.popContext(Context.MAP);
                    TweedDataToken token = this.wrapToken(TweedDataTokens.getMapEnd());
                    this.afterValueRead();
                    return token;
                }
                case FIELD_NAME: {
                    this.contextStack.push(Context.MAP_ENTRY_VALUE);
                    return TweedDataTokens.asMapEntryKey((TweedDataToken)this.createStringToken(this.parser.getText()));
                }
                case VALUE_NULL: {
                    TweedDataToken token = this.wrapToken(TweedDataTokens.getNull());
                    this.afterValueRead();
                    return token;
                }
                case VALUE_TRUE: {
                    TweedDataToken token = this.wrapToken(this.createBooleanToken(true));
                    this.afterValueRead();
                    return token;
                }
                case VALUE_FALSE: {
                    TweedDataToken token = this.wrapToken(this.createBooleanToken(false));
                    this.afterValueRead();
                    return token;
                }
                case VALUE_NUMBER_INT: {
                    final long longValue = this.parser.getLongValue();
                    TweedDataToken token = this.wrapToken(new TweedDataToken(){
                        final /* synthetic */ JacksonReader this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public boolean canReadAsByte() {
                            return longValue >= -128L && longValue <= 127L;
                        }

                        public byte readAsByte() {
                            return (byte)longValue;
                        }

                        public boolean canReadAsShort() {
                            return longValue >= -32768L && longValue <= 32767L;
                        }

                        public short readAsShort() {
                            return (short)longValue;
                        }

                        public boolean canReadAsInt() {
                            return longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE;
                        }

                        public int readAsInt() {
                            return (int)longValue;
                        }

                        public boolean canReadAsLong() {
                            return true;
                        }

                        public long readAsLong() {
                            return longValue;
                        }

                        public boolean canReadAsFloat() {
                            return true;
                        }

                        public float readAsFloat() {
                            return longValue;
                        }

                        public boolean canReadAsDouble() {
                            return true;
                        }

                        public double readAsDouble() {
                            return longValue;
                        }
                    });
                    this.afterValueRead();
                    return token;
                }
                case VALUE_NUMBER_FLOAT: {
                    final float floatValue = this.parser.getFloatValue();
                    final double doubleValue = this.parser.getDoubleValue();
                    TweedDataToken token = this.wrapToken(new TweedDataToken(){
                        final /* synthetic */ JacksonReader this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public boolean canReadAsFloat() {
                            return true;
                        }

                        public float readAsFloat() {
                            return floatValue;
                        }

                        public boolean canReadAsDouble() {
                            return true;
                        }

                        public double readAsDouble() {
                            return doubleValue;
                        }
                    });
                    this.afterValueRead();
                    return token;
                }
                case VALUE_STRING: {
                    TweedDataToken token = this.wrapToken(this.createStringToken(this.parser.getText()));
                    this.afterValueRead();
                    return token;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    throw TweedDataReadException.builder().message("Encountered unsupported embedded object at " + this.parser.currentLocation()).build();
                }
                case NOT_AVAILABLE: {
                    throw TweedDataReadException.builder().message("Encountered unexpected NOT_AVAILABLE token at " + this.parser.currentLocation()).build();
                }
            }
            throw TweedDataReadException.builder().message("Encountered unexpected token " + jsonToken + " at " + this.parser.currentLocation()).build();
        }
        catch (IOException e) {
            throw TweedDataReadException.builder().message("Error reading data using jackson at " + this.parser.currentLocation()).cause((Throwable)e).build();
        }
    }

    private TweedDataToken wrapToken(TweedDataToken token) throws TweedDataReadException {
        Context context = this.peekContext();
        switch (context.ordinal()) {
            case 1: {
                return TweedDataTokens.asListValue((TweedDataToken)token);
            }
            case 3: {
                return TweedDataTokens.asMapEntryValue((TweedDataToken)token);
            }
            case 0: {
                return token;
            }
        }
        throw TweedDataReadException.builder().message("Encountered token " + token + " in unexpected context: " + (Object)((Object)context)).build();
    }

    private void afterValueRead() throws TweedDataReadException {
        Context context = this.peekContext();
        switch (context.ordinal()) {
            case 0: 
            case 3: {
                this.contextStack.pop();
            }
        }
    }

    private Context peekContext() throws TweedDataReadException {
        Context context = this.contextStack.peek();
        if (context == null) {
            throw TweedDataReadException.builder().message("Tried to read context but currently not in any context").build();
        }
        return context;
    }

    private void popContext(Context expectedContext) throws TweedDataReadException {
        Context context = this.contextStack.pop();
        if (context != expectedContext) {
            throw TweedDataReadException.builder().message("Unexpected context " + (Object)((Object)context) + " when popping " + (Object)((Object)expectedContext)).build();
        }
    }

    private TweedDataToken createStringToken(final String value) {
        return new TweedDataToken(){
            final /* synthetic */ JacksonReader this$0;
            {
                this.this$0 = this$0;
            }

            public boolean canReadAsString() {
                return true;
            }

            public String readAsString() {
                return value;
            }
        };
    }

    private TweedDataToken createBooleanToken(final boolean value) {
        return new TweedDataToken(){
            final /* synthetic */ JacksonReader this$0;
            {
                this.this$0 = this$0;
            }

            public boolean canReadAsBoolean() {
                return true;
            }

            public boolean readAsBoolean() {
                return value;
            }
        };
    }

    public void close() throws Exception {
        this.parser.close();
    }

    private static enum Context {
        VALUE,
        LIST,
        MAP,
        MAP_ENTRY_VALUE;

    }
}

