/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.data.jackson;

import de.siphalor.tweed5.data.jackson.shadowed.jackson.core.JsonGenerator;
import de.siphalor.tweed5.dataapi.api.TweedDataWriteException;
import de.siphalor.tweed5.dataapi.api.TweedDataWriter;
import de.siphalor.tweed5.dataapi.api.decoration.TweedDataCommentDecoration;
import de.siphalor.tweed5.dataapi.api.decoration.TweedDataDecoration;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class JacksonWriter
implements TweedDataWriter {
    private final JsonGenerator generator;
    private final CommentWriteMode commentWriteMode;
    private final Deque<Context> contextStack = new ArrayDeque<Context>();
    private final List<String> deferredFieldComments = new ArrayList<String>();

    public JacksonWriter(JsonGenerator generator, CommentWriteMode commentWriteMode) {
        this.generator = generator;
        this.commentWriteMode = commentWriteMode;
        this.contextStack.push(Context.VALUE);
    }

    public void visitNull() {
        try {
            this.generator.writeNull();
            this.afterValueVisited();
        }
        catch (IOException e) {
            throw this.createWriteExceptionForIOException(e);
        }
    }

    public void visitBoolean(boolean value) {
        try {
            this.generator.writeBoolean(value);
            this.afterValueVisited();
        }
        catch (IOException e) {
            throw this.createWriteExceptionForIOException(e);
        }
    }

    public void visitByte(byte value) {
        try {
            this.generator.writeNumber(value);
            this.afterValueVisited();
        }
        catch (IOException e) {
            throw this.createWriteExceptionForIOException(e);
        }
    }

    public void visitShort(short value) {
        try {
            this.generator.writeNumber(value);
            this.afterValueVisited();
        }
        catch (IOException e) {
            throw this.createWriteExceptionForIOException(e);
        }
    }

    public void visitInt(int value) {
        try {
            this.generator.writeNumber(value);
            this.afterValueVisited();
        }
        catch (IOException e) {
            throw this.createWriteExceptionForIOException(e);
        }
    }

    public void visitLong(long value) {
        try {
            this.generator.writeNumber(value);
            this.afterValueVisited();
        }
        catch (IOException e) {
            throw this.createWriteExceptionForIOException(e);
        }
    }

    public void visitFloat(float value) {
        try {
            this.generator.writeNumber(value);
            this.afterValueVisited();
        }
        catch (IOException e) {
            throw this.createWriteExceptionForIOException(e);
        }
    }

    public void visitDouble(double value) {
        try {
            this.generator.writeNumber(value);
            this.afterValueVisited();
        }
        catch (IOException e) {
            throw this.createWriteExceptionForIOException(e);
        }
    }

    public void visitString(String value) {
        try {
            this.generator.writeString(value);
            this.afterValueVisited();
        }
        catch (IOException e) {
            throw this.createWriteExceptionForIOException(e);
        }
    }

    public void visitListStart() {
        try {
            this.generator.writeStartArray();
            this.contextStack.push(Context.LIST);
        }
        catch (IOException e) {
            throw this.createWriteExceptionForIOException(e);
        }
    }

    public void visitListEnd() {
        try {
            this.generator.writeEndArray();
            this.popContext(Context.LIST);
            this.afterValueVisited();
        }
        catch (IOException e) {
            throw this.createWriteExceptionForIOException(e);
        }
    }

    public void visitMapStart() {
        try {
            this.generator.writeStartObject();
            this.contextStack.push(Context.MAP);
        }
        catch (IOException e) {
            throw this.createWriteExceptionForIOException(e);
        }
    }

    public void visitMapEntryKey(String key) {
        try {
            if (!this.deferredFieldComments.isEmpty()) {
                this.generator.writeFieldName(key + "__comment");
                if (this.deferredFieldComments.size() == 1) {
                    this.generator.writeString(this.deferredFieldComments.get(0));
                } else {
                    this.generator.writeStartArray();
                    for (String deferredFieldComment : this.deferredFieldComments) {
                        this.generator.writeString(deferredFieldComment);
                    }
                    this.generator.writeEndArray();
                }
                this.deferredFieldComments.clear();
            }
            this.generator.writeFieldName(key);
            this.contextStack.push(Context.VALUE);
        }
        catch (IOException e) {
            throw this.createWriteExceptionForIOException(e);
        }
    }

    public void visitMapEnd() {
        try {
            this.generator.writeEndObject();
            this.popContext(Context.MAP);
            this.afterValueVisited();
        }
        catch (IOException e) {
            throw this.createWriteExceptionForIOException(e);
        }
    }

    public void visitDecoration(TweedDataDecoration decoration) {
        if (decoration instanceof TweedDataCommentDecoration) {
            switch (this.commentWriteMode.ordinal()) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.contextStack.peek() != Context.MAP) break;
                    this.appendDeferredComment(((TweedDataCommentDecoration)decoration).comment());
                    break;
                }
                case 2: {
                    try {
                        this.generator.writeRaw("// ");
                        this.generator.writeRaw(((TweedDataCommentDecoration)decoration).comment());
                        this.generator.writeRaw("\n");
                        break;
                    }
                    catch (IOException e) {
                        throw this.createWriteExceptionForIOException(e);
                    }
                }
            }
        }
    }

    private void appendDeferredComment(String comment) {
        int index = 0;
        while (true) {
            int next;
            if ((next = comment.indexOf(10, index)) == -1) break;
            this.deferredFieldComments.add(comment.substring(index, next));
            index = next + 1;
        }
        this.deferredFieldComments.add(comment.substring(index));
    }

    public void close() throws Exception {
        this.generator.close();
    }

    private void afterValueVisited() {
        if (this.contextStack.peek() == Context.VALUE) {
            this.contextStack.pop();
        }
    }

    private void popContext(Context expectedContext) {
        Context context = this.contextStack.pop();
        if (context != expectedContext) {
            throw new IllegalStateException("Unexpected context " + (Object)((Object)context) + " when popping " + (Object)((Object)expectedContext));
        }
    }

    private TweedDataWriteException createWriteExceptionForIOException(IOException e) {
        throw new TweedDataWriteException("Error writing data using jackson at " + this.generator.getOutputContext(), (Throwable)e);
    }

    public static enum CommentWriteMode {
        NONE,
        MAP_ENTRIES,
        DOUBLE_SLASHES;

    }

    private static enum Context {
        VALUE,
        LIST,
        MAP;

    }
}

