package de.siphalor.tweed5.utils.api.collection;

import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import java.util.*;

@SuppressWarnings("unchecked")
public class ClassToInstanceMap<T extends @NonNull Object> implements Iterable<T> {
	private final Map<Class<? extends T>, T> delegate;

	public static <T extends @NonNull Object> ClassToInstanceMap<T> backedBy(Map<Class<? extends T>, T> delegate) {
		return new ClassToInstanceMap<>(delegate);
	}

	public ClassToInstanceMap() {
		this(new HashMap<>());
	}

	public int size() {
		return delegate.size();
	}

	public boolean isEmpty() {
		return delegate.isEmpty();
	}

	public boolean containsClass(Class<? extends T> key) {
		return delegate.containsKey(key);
	}

	public boolean containsValue(T value) {
		return delegate.containsValue(value);
	}

	@Nullable
	public <V extends T> V get(Class<V> key) {
		return (V) delegate.get(key);
	}

	@Nullable
	public <V extends T> V put(V value) {
		return put((Class<V>) value.getClass(), value);
	}

	@Nullable
	public <V extends T, U extends V> V put(Class<V> key, U value) {
		return (V) delegate.put(key, value);
	}

	@Nullable
	public <V extends T> V remove(Class<V> key) {
		return (V) delegate.remove(key);
	}

	public void clear() {
		delegate.clear();
	}

	public Set<Class<? extends T>> classes() {
		return delegate.keySet();
	}

	public Set<T> values() {
		return new AbstractSet<T>() {
			@Override
			public Iterator<T> iterator() {
				Iterator<Map.Entry<Class<? extends T>, T>> entryIterator = delegate.entrySet().iterator();
				return new Iterator<T>() {
					@Override
					public boolean hasNext() {
						return entryIterator.hasNext();
					}
					@Override
					public T next() {
						return entryIterator.next().getValue();
					}
					@Override
					public void remove() {
						entryIterator.remove();
					}
				};
			}
			@Override
			public int size() {
				return delegate.size();
			}
		};
	}

	@Override
	public Iterator<T> iterator() {
		return values().iterator();
	}

	@Override
	public boolean equals(final Object o) {
		if (o == this) return true;
		if (!(o instanceof ClassToInstanceMap)) return false;
		final ClassToInstanceMap<?> other = (ClassToInstanceMap<?>) o;
		if (!other.canEqual((Object) this)) return false;
		final Object this$delegate = this.delegate;
		final Object other$delegate = other.delegate;
		if (this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate)) return false;
		return true;
	}

	protected boolean canEqual(final Object other) {
		return other instanceof ClassToInstanceMap;
	}

	@Override
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		final Object $delegate = this.delegate;
		result = result * PRIME + ($delegate == null ? 43 : $delegate.hashCode());
		return result;
	}

	protected ClassToInstanceMap(final Map<Class<? extends T>, T> delegate) {
		this.delegate = delegate;
	}
}
