/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.weaver.pojoext.attributes.api;

import de.siphalor.tweed5.attributesextension.api.AttributesExtension;
import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.typeutils.api.type.ActualType;
import de.siphalor.tweed5.weaver.pojo.api.weaving.TweedPojoWeavingExtension;
import de.siphalor.tweed5.weaver.pojo.api.weaving.WeavingContext;
import de.siphalor.tweed5.weaver.pojoext.attributes.api.Attribute;
import de.siphalor.tweed5.weaver.pojoext.attributes.api.AttributeDefault;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;

public class AttributesPojoWeavingProcessor
implements TweedPojoWeavingExtension {
    AttributesExtension attributesExtension;

    @ApiStatus.Internal
    public AttributesPojoWeavingProcessor(ConfigContainer<?> configContainer) {
        this.attributesExtension = (AttributesExtension)configContainer.extension(AttributesExtension.class).orElseThrow(() -> new IllegalStateException("You must register a " + AttributesExtension.class.getSimpleName() + " to use the " + this.getClass().getSimpleName()));
    }

    public void setup(TweedPojoWeavingExtension.SetupContext context) {
    }

    public <T> void afterWeaveEntry(ActualType<T> valueType, ConfigEntry<T> configEntry, WeavingContext context) {
        Attribute[] attributeAnnotations = (Attribute[])context.annotations().getAnnotationsByType(Attribute.class);
        Map<String, List<String>> attributes = this.collectAttributesFromAnnotations(attributeAnnotations, Attribute::key, Attribute::value);
        attributes.forEach((key, values) -> this.attributesExtension.setAttribute(configEntry, key, values));
        AttributeDefault[] attributeDefaultAnnotations = (AttributeDefault[])context.annotations().getAnnotationsByType(AttributeDefault.class);
        Map<String, List<String>> attributeDefaults = this.collectAttributesFromAnnotations(attributeDefaultAnnotations, AttributeDefault::key, AttributeDefault::defaultValue);
        attributeDefaults.forEach((key, values) -> this.attributesExtension.setAttributeDefault(configEntry, key, values));
    }

    private <T> Map<String, List<String>> collectAttributesFromAnnotations(T[] annotations, Function<T, String> keyGetter, Function<T, String[]> valueGetter) {
        if (annotations.length == 0) {
            return Collections.emptyMap();
        }
        if (annotations.length == 1) {
            return Collections.singletonMap(keyGetter.apply(annotations[0]), Arrays.asList(valueGetter.apply(annotations[0])));
        }
        AbstractMap attributes = annotations.length <= 12 ? new TreeMap() : new HashMap();
        for (T annotation : annotations) {
            attributes.computeIfAbsent((String)keyGetter.apply(annotation), k -> new ArrayList()).addAll(Arrays.asList(valueGetter.apply(annotation)));
        }
        return attributes;
    }
}

