/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.weaver.pojoext.presets.api;

import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.defaultextensions.presets.api.PresetsExtension;
import de.siphalor.tweed5.typeutils.api.type.ActualType;
import de.siphalor.tweed5.weaver.pojo.api.weaving.TweedPojoWeavingExtension;
import de.siphalor.tweed5.weaver.pojo.api.weaving.WeavingContext;
import de.siphalor.tweed5.weaver.pojoext.presets.api.Preset;
import java.lang.reflect.Field;
import java.util.HashMap;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PresetsWeavingProcessor
implements TweedPojoWeavingExtension {
    @Generated
    private static final Log log = LogFactory.getLog(PresetsWeavingProcessor.class);
    private static final int REQUIRED_FIELD_MODIFIERS = 24;

    public void setup(TweedPojoWeavingExtension.SetupContext context) {
    }

    public <T> void afterWeaveEntry(ActualType<T> valueType, ConfigEntry<T> configEntry, WeavingContext context) {
        HashMap<String, Object> presets = new HashMap<String, Object>();
        for (Field field : valueType.declaredType().getFields()) {
            Preset presetAnnotation = field.getAnnotation(Preset.class);
            if (presetAnnotation == null) continue;
            if ((field.getModifiers() & 0x18) != 24) {
                log.warn((Object)("@Preset field " + field.getName() + " in class " + field.getDeclaringClass().getName() + " is not static and final, skipping preset"));
                continue;
            }
            if (presets.containsKey(presetAnnotation.value())) {
                log.warn((Object)("Duplicate preset name " + presetAnnotation.value() + " in class " + field.getDeclaringClass().getName() + ", skipping preset"));
                presets.remove(presetAnnotation.value());
                continue;
            }
            if (!configEntry.valueClass().isAssignableFrom(field.getType())) {
                log.warn((Object)("@Preset field " + field.getName() + " in class " + field.getDeclaringClass().getName() + " has incompatible type, skipping preset"));
                continue;
            }
            try {
                presets.put(presetAnnotation.value(), field.get(null));
            }
            catch (IllegalAccessException e) {
                log.warn((Object)("Failed to access preset field " + field.getName() + " in class " + field.getDeclaringClass().getName()), (Throwable)e);
            }
        }
        if (!presets.isEmpty()) {
            PresetsExtension presetsExtension = (PresetsExtension)configEntry.container().extension(PresetsExtension.class).orElseThrow(() -> new IllegalStateException("PresetsExtension not declared in config container"));
            presets.forEach((name, value) -> presetsExtension.presetValue(configEntry, name, value));
        }
    }
}

