/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.weaver.pojoext.serde.api.auto;

import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.data.extension.api.ReadWriteExtension;
import de.siphalor.tweed5.data.extension.api.TweedEntryReader;
import de.siphalor.tweed5.data.extension.api.TweedEntryWriter;
import de.siphalor.tweed5.data.extension.api.TweedReaderWriterProvider;
import de.siphalor.tweed5.data.extension.impl.TweedEntryReaderWriterImpls;
import de.siphalor.tweed5.patchwork.api.Patchwork;
import de.siphalor.tweed5.patchwork.api.PatchworkPartAccess;
import de.siphalor.tweed5.typeutils.api.type.ActualType;
import de.siphalor.tweed5.weaver.pojo.api.weaving.ProtoWeavingContext;
import de.siphalor.tweed5.weaver.pojo.api.weaving.TweedPojoWeavingExtension;
import de.siphalor.tweed5.weaver.pojo.api.weaving.WeavingContext;
import de.siphalor.tweed5.weaver.pojoext.serde.api.auto.AutoReadWriteMapping;
import de.siphalor.tweed5.weaver.pojoext.serde.impl.ReaderWriterLoader;
import de.siphalor.tweed5.weaver.pojoext.serde.impl.SerdePojoReaderWriterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

public class AutoReadWritePojoWeavingProcessor
implements TweedPojoWeavingExtension {
    private final ReadWriteExtension readWriteExtension;
    private final ReaderWriterLoader readerWriterLoader = new ReaderWriterLoader();
    private @Nullable PatchworkPartAccess<CustomData> customDataAccess;

    @ApiStatus.Internal
    public AutoReadWritePojoWeavingProcessor(ConfigContainer<?> configContainer) {
        this.readWriteExtension = (ReadWriteExtension)configContainer.extension(ReadWriteExtension.class).orElseThrow(() -> new IllegalStateException("You must register a " + ReadWriteExtension.class.getSimpleName() + " to use the " + this.getClass().getSimpleName()));
    }

    public void setup(TweedPojoWeavingExtension.SetupContext context) {
        this.customDataAccess = context.registerWeavingContextExtensionData(CustomData.class);
        this.loadProviders();
    }

    private void loadProviders() {
        ServiceLoader<TweedReaderWriterProvider> serviceLoader = ServiceLoader.load(TweedReaderWriterProvider.class);
        serviceLoader.forEach(this.readerWriterLoader::load);
    }

    public <T> void beforeWeaveEntry(ActualType<T> valueType, Patchwork extensionsData, ProtoWeavingContext context) {
        assert (this.customDataAccess != null);
        CustomData existingCustomData = (CustomData)extensionsData.get(this.customDataAccess);
        List<Object> existingMappings = existingCustomData == null ? Collections.emptyList() : existingCustomData.mappings();
        AutoReadWriteMapping[] mappingAnnotations = (AutoReadWriteMapping[])context.annotations().getAnnotationsByType(AutoReadWriteMapping.class);
        if (existingCustomData == null || mappingAnnotations.length > 0) {
            List<Mapping> mappings;
            if (existingMappings.isEmpty() && mappingAnnotations.length == 0) {
                mappings = Collections.emptyList();
            } else {
                mappings = new ArrayList(existingMappings.size() + mappingAnnotations.length + 5);
                mappings.addAll(existingMappings);
                for (AutoReadWriteMapping mappingAnnotation : mappingAnnotations) {
                    mappings.add(this.annotationToMapping(mappingAnnotation));
                }
            }
            extensionsData.set(this.customDataAccess, (Object)new CustomData(mappings));
        }
    }

    private Mapping annotationToMapping(AutoReadWriteMapping annotation) {
        return new Mapping(annotation.entryClasses(), annotation.valueClasses(), this.resolveReader(annotation.reader().isEmpty() ? annotation.spec() : annotation.reader()), this.resolveWriter(annotation.writer().isEmpty() ? annotation.spec() : annotation.writer()));
    }

    private TweedEntryReader<?, ?> resolveReader(String specText) {
        if (specText.isEmpty()) {
            return TweedEntryReaderWriterImpls.NOOP_READER_WRITER;
        }
        try {
            SerdePojoReaderWriterSpec spec = SerdePojoReaderWriterSpec.parse(specText);
            return this.readerWriterLoader.resolveReaderFromSpec(spec);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse definition for reader: \"" + specText + "\"", e);
        }
    }

    private TweedEntryWriter<?, ?> resolveWriter(String specText) {
        if (specText.isEmpty()) {
            return TweedEntryReaderWriterImpls.NOOP_READER_WRITER;
        }
        try {
            SerdePojoReaderWriterSpec spec = SerdePojoReaderWriterSpec.parse(specText);
            return this.readerWriterLoader.resolveWriterFromSpec(spec);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse definition for writer: \"" + specText + "\"", e);
        }
    }

    public <T> void afterWeaveEntry(ActualType<T> valueType, ConfigEntry<T> configEntry, WeavingContext context) {
        assert (this.customDataAccess != null);
        CustomData customData = (CustomData)context.extensionsData().get(this.customDataAccess);
        if (customData == null || customData.mappings().isEmpty()) {
            return;
        }
        Mapping mapping = this.determineMapping(customData, configEntry, valueType);
        if (mapping == null) {
            return;
        }
        this.readWriteExtension.setEntryReaderWriter(configEntry, mapping.reader(), mapping.writer());
    }

    private @Nullable Mapping determineMapping(CustomData customData, ConfigEntry<?> configEntry, ActualType<?> valueType) {
        Mapping strictMapping = customData.strictMappings().get(new MappingStrictKey(configEntry.getClass(), valueType.declaredType()));
        if (strictMapping != null) {
            return strictMapping;
        }
        for (int i = customData.mappings().size() - 1; i >= 0; --i) {
            Mapping mapping = customData.mappings().get(i);
            if (!this.mappingMatches(mapping, configEntry, valueType)) continue;
            customData.strictMappings.put(new MappingStrictKey(configEntry.getClass(), valueType.declaredType()), mapping);
            return mapping;
        }
        return null;
    }

    private boolean mappingMatches(Mapping mapping, ConfigEntry<?> configEntry, ActualType<?> valueType) {
        return this.anyClassMatches(mapping.entryClasses, configEntry.getClass()) && this.anyClassMatches(mapping.valueClasses, valueType.declaredType());
    }

    private boolean anyClassMatches(Class<?>[] haystack, Class<?> needle) {
        for (Class<?> hay : haystack) {
            if (!hay.isAssignableFrom(needle)) continue;
            return true;
        }
        return false;
    }

    private static final class CustomData {
        private final List<Mapping> mappings;
        private final Map<MappingStrictKey, Mapping> strictMappings = new HashMap<MappingStrictKey, Mapping>();

        @Generated
        public CustomData(List<Mapping> mappings) {
            this.mappings = mappings;
        }

        @Generated
        public List<Mapping> mappings() {
            return this.mappings;
        }

        @Generated
        public Map<MappingStrictKey, Mapping> strictMappings() {
            return this.strictMappings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomData)) {
                return false;
            }
            CustomData other = (CustomData)o;
            List<Mapping> this$mappings = this.mappings();
            List<Mapping> other$mappings = other.mappings();
            if (this$mappings == null ? other$mappings != null : !((Object)this$mappings).equals(other$mappings)) {
                return false;
            }
            Map<MappingStrictKey, Mapping> this$strictMappings = this.strictMappings();
            Map<MappingStrictKey, Mapping> other$strictMappings = other.strictMappings();
            return !(this$strictMappings == null ? other$strictMappings != null : !((Object)this$strictMappings).equals(other$strictMappings));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Mapping> $mappings = this.mappings();
            result = result * 59 + ($mappings == null ? 43 : ((Object)$mappings).hashCode());
            Map<MappingStrictKey, Mapping> $strictMappings = this.strictMappings();
            result = result * 59 + ($strictMappings == null ? 43 : ((Object)$strictMappings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AutoReadWritePojoWeavingProcessor.CustomData(mappings=" + this.mappings() + ", strictMappings=" + this.strictMappings() + ")";
        }
    }

    private static final class Mapping {
        private final Class<?>[] entryClasses;
        private final Class<?>[] valueClasses;
        private final TweedEntryReader<?, ?> reader;
        private final TweedEntryWriter<?, ?> writer;

        @Generated
        public Mapping(Class<?>[] entryClasses, Class<?>[] valueClasses, TweedEntryReader<?, ?> reader, TweedEntryWriter<?, ?> writer) {
            this.entryClasses = entryClasses;
            this.valueClasses = valueClasses;
            this.reader = reader;
            this.writer = writer;
        }

        @Generated
        public Class<?>[] entryClasses() {
            return this.entryClasses;
        }

        @Generated
        public Class<?>[] valueClasses() {
            return this.valueClasses;
        }

        @Generated
        public TweedEntryReader<?, ?> reader() {
            return this.reader;
        }

        @Generated
        public TweedEntryWriter<?, ?> writer() {
            return this.writer;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Mapping)) {
                return false;
            }
            Mapping other = (Mapping)o;
            if (!Arrays.deepEquals(this.entryClasses(), other.entryClasses())) {
                return false;
            }
            if (!Arrays.deepEquals(this.valueClasses(), other.valueClasses())) {
                return false;
            }
            TweedEntryReader<?, ?> this$reader = this.reader();
            TweedEntryReader<?, ?> other$reader = other.reader();
            if (this$reader == null ? other$reader != null : !this$reader.equals(other$reader)) {
                return false;
            }
            TweedEntryWriter<?, ?> this$writer = this.writer();
            TweedEntryWriter<?, ?> other$writer = other.writer();
            return !(this$writer == null ? other$writer != null : !this$writer.equals(other$writer));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.entryClasses());
            result = result * 59 + Arrays.deepHashCode(this.valueClasses());
            TweedEntryReader<?, ?> $reader = this.reader();
            result = result * 59 + ($reader == null ? 43 : $reader.hashCode());
            TweedEntryWriter<?, ?> $writer = this.writer();
            result = result * 59 + ($writer == null ? 43 : $writer.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AutoReadWritePojoWeavingProcessor.Mapping(entryClasses=" + Arrays.deepToString(this.entryClasses()) + ", valueClasses=" + Arrays.deepToString(this.valueClasses()) + ", reader=" + this.reader() + ", writer=" + this.writer() + ")";
        }
    }

    private static final class MappingStrictKey {
        private final Class<?> entryClass;
        private final Class<?> valueClass;

        @Generated
        public MappingStrictKey(Class<?> entryClass, Class<?> valueClass) {
            this.entryClass = entryClass;
            this.valueClass = valueClass;
        }

        @Generated
        public Class<?> entryClass() {
            return this.entryClass;
        }

        @Generated
        public Class<?> valueClass() {
            return this.valueClass;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MappingStrictKey)) {
                return false;
            }
            MappingStrictKey other = (MappingStrictKey)o;
            Class<?> this$entryClass = this.entryClass();
            Class<?> other$entryClass = other.entryClass();
            if (this$entryClass == null ? other$entryClass != null : !this$entryClass.equals(other$entryClass)) {
                return false;
            }
            Class<?> this$valueClass = this.valueClass();
            Class<?> other$valueClass = other.valueClass();
            return !(this$valueClass == null ? other$valueClass != null : !this$valueClass.equals(other$valueClass));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $entryClass = this.entryClass();
            result = result * 59 + ($entryClass == null ? 43 : $entryClass.hashCode());
            Class<?> $valueClass = this.valueClass();
            result = result * 59 + ($valueClass == null ? 43 : $valueClass.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AutoReadWritePojoWeavingProcessor.MappingStrictKey(entryClass=" + this.entryClass() + ", valueClass=" + this.valueClass() + ")";
        }
    }
}

