/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.weaver.pojoext.serde.impl;

import de.siphalor.tweed5.data.extension.api.TweedEntryReader;
import de.siphalor.tweed5.data.extension.api.TweedEntryWriter;
import de.siphalor.tweed5.data.extension.api.TweedReaderWriterProvider;
import de.siphalor.tweed5.data.extension.impl.TweedEntryReaderWriterImpls;
import de.siphalor.tweed5.shadowed.org.apache.commons.logging.Log;
import de.siphalor.tweed5.shadowed.org.apache.commons.logging.LogFactory;
import de.siphalor.tweed5.weaver.pojoext.serde.impl.SerdePojoReaderWriterSpec;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class ReaderWriterLoader {
    @Generated
    private static final Log log = LogFactory.getLog(ReaderWriterLoader.class);
    private final Map<String, TweedReaderWriterProvider.ReaderWriterFactory<TweedEntryReader<?, ?>>> readerFactories = new HashMap();
    private final Map<String, TweedReaderWriterProvider.ReaderWriterFactory<TweedEntryWriter<?, ?>>> writerFactories = new HashMap();
    private final TweedReaderWriterProvider.ProviderContext providerContext = new ProviderContext();

    public void load(TweedReaderWriterProvider provider) {
        try {
            provider.provideReaderWriters(this.providerContext);
        }
        catch (Exception e) {
            log.warn((Object)("Unexpected exception while providing reader and writer factories using " + provider.getClass().getName()), (Throwable)e);
        }
    }

    public TweedEntryReader<?, ?> resolveReaderFromSpec(SerdePojoReaderWriterSpec spec) {
        TweedEntryReader reader = this.resolveReaderWriterFromSpec(TweedEntryReader.class, this.readerFactories(), spec);
        if (reader != null) {
            return reader;
        }
        return TweedEntryReaderWriterImpls.NOOP_READER_WRITER;
    }

    public TweedEntryWriter<?, ?> resolveWriterFromSpec(SerdePojoReaderWriterSpec spec) {
        TweedEntryWriter writer = this.resolveReaderWriterFromSpec(TweedEntryWriter.class, this.writerFactories(), spec);
        if (writer != null) {
            return writer;
        }
        return TweedEntryReaderWriterImpls.NOOP_READER_WRITER;
    }

    private <T> @Nullable T resolveReaderWriterFromSpec(Class<T> baseClass, Map<String, TweedReaderWriterProvider.ReaderWriterFactory<T>> factories, SerdePojoReaderWriterSpec spec) {
        Object instance;
        Object[] arguments = spec.arguments().stream().map(argSpec -> this.resolveReaderWriterFromSpec(baseClass, factories, (SerdePojoReaderWriterSpec)argSpec)).toArray(length -> (Object[])Array.newInstance(baseClass, length));
        TweedReaderWriterProvider.ReaderWriterFactory<T> factory = factories.get(spec.identifier());
        try {
            instance = factory != null ? factory.create(arguments) : this.loadClassIfExists(baseClass, spec.identifier(), arguments);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to resolve reader or writer factory from \"" + spec.identifier() + "\"", e);
        }
        return (T)instance;
    }

    private <T> @Nullable T loadClassIfExists(Class<T> baseClass, String className, T[] arguments) {
        try {
            Class<?> clazz = Class.forName(className);
            Object[] argClasses = new Class[arguments.length];
            Arrays.fill(argClasses, baseClass);
            Constructor<?> constructor = clazz.getConstructor((Class<?>[])argClasses);
            return (T)constructor.newInstance(arguments);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.warn((Object)("Failed to instantiate class " + className), (Throwable)e);
            return null;
        }
    }

    @Generated
    public Map<String, TweedReaderWriterProvider.ReaderWriterFactory<TweedEntryReader<?, ?>>> readerFactories() {
        return this.readerFactories;
    }

    @Generated
    public Map<String, TweedReaderWriterProvider.ReaderWriterFactory<TweedEntryWriter<?, ?>>> writerFactories() {
        return this.writerFactories;
    }

    private class ProviderContext
    implements TweedReaderWriterProvider.ProviderContext {
        private ProviderContext() {
        }

        public void registerReaderFactory(String id, TweedReaderWriterProvider.ReaderWriterFactory<TweedEntryReader<?, ?>> readerFactory) {
            if (ReaderWriterLoader.this.readerFactories.putIfAbsent(id, readerFactory) != null) {
                throw new IllegalArgumentException("Found duplicate Tweed entry reader id \"" + id + "\"");
            }
        }

        public void registerWriterFactory(String id, TweedReaderWriterProvider.ReaderWriterFactory<TweedEntryWriter<?, ?>> writerFactory) {
            if (ReaderWriterLoader.this.writerFactories.putIfAbsent(id, writerFactory) != null) {
                throw new IllegalArgumentException("Found duplicate Tweed entry reader id \"" + id + "\"");
            }
        }
    }
}

