package de.siphalor.tweed5.weaver.pojo.impl.entry;

import de.siphalor.tweed5.construct.api.ConstructParameter;
import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.entry.BaseConfigEntry;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.weaver.pojo.api.entry.WeavableCollectionConfigEntry;
import org.jetbrains.annotations.NotNull;
import java.util.Collection;
import java.util.function.IntFunction;

public class CollectionConfigEntryImpl<E, T extends Collection<E>> extends BaseConfigEntry<T> implements WeavableCollectionConfigEntry<E, T> {
	private final IntFunction<T> constructor;
	private final ConfigEntry<E> elementEntry;

	public CollectionConfigEntryImpl(ConfigContainer<?> configContainer, Class<T> valueClass, IntFunction<T> constructor, @ConstructParameter(name = "elementEntry") ConfigEntry<E> elementEntry) {
		super(configContainer, valueClass);
		this.constructor = constructor;
		this.elementEntry = elementEntry;
	}

	@Override
	public T instantiateCollection(int size) {
		try {
			return constructor.apply(size);
		} catch (Throwable e) {
			throw new IllegalStateException("Failed to instantiate collection class", e);
		}
	}

	@Override
	@NotNull
	public T deepCopy(T value) {
		T copy = instantiateCollection(value.size());
		for (E element : value) {
			copy.add(elementEntry.deepCopy(element));
		}
		return copy;
	}

	public IntFunction<T> constructor() {
		return this.constructor;
	}

	public ConfigEntry<E> elementEntry() {
		return this.elementEntry;
	}

	@Override
	public boolean equals(final Object o) {
		if (o == this) return true;
		if (!(o instanceof CollectionConfigEntryImpl)) return false;
		final CollectionConfigEntryImpl<?, ?> other = (CollectionConfigEntryImpl<?, ?>) o;
		if (!other.canEqual((Object) this)) return false;
		if (!super.equals(o)) return false;
		final Object this$constructor = this.constructor();
		final Object other$constructor = other.constructor();
		if (this$constructor == null ? other$constructor != null : !this$constructor.equals(other$constructor)) return false;
		final Object this$elementEntry = this.elementEntry();
		final Object other$elementEntry = other.elementEntry();
		if (this$elementEntry == null ? other$elementEntry != null : !this$elementEntry.equals(other$elementEntry)) return false;
		return true;
	}

	protected boolean canEqual(final Object other) {
		return other instanceof CollectionConfigEntryImpl;
	}

	@Override
	public int hashCode() {
		final int PRIME = 59;
		int result = super.hashCode();
		final Object $constructor = this.constructor();
		result = result * PRIME + ($constructor == null ? 43 : $constructor.hashCode());
		final Object $elementEntry = this.elementEntry();
		result = result * PRIME + ($elementEntry == null ? 43 : $elementEntry.hashCode());
		return result;
	}

	@Override
	public String toString() {
		return "CollectionConfigEntryImpl(super=" + super.toString() + ", constructor=" + this.constructor() + ", elementEntry=" + this.elementEntry() + ")";
	}
}
