package de.siphalor.tweed5.weaver.pojo.impl.weaving.collection;

import de.siphalor.tweed5.weaver.pojo.api.entry.WeavableCollectionConfigEntry;
import org.jspecify.annotations.Nullable;

public final class CollectionWeavingConfigImpl implements CollectionWeavingConfig {
	@SuppressWarnings("rawtypes")
	@Nullable
	private final Class<? extends WeavableCollectionConfigEntry> collectionEntryClass;

	public static CollectionWeavingConfigImpl withOverrides(CollectionWeavingConfig self, CollectionWeavingConfig overrides) {
		return CollectionWeavingConfigImpl.builder().collectionEntryClass(overrides.collectionEntryClass() != null ? overrides.collectionEntryClass() : self.collectionEntryClass()).build();
	}

	CollectionWeavingConfigImpl(@Nullable final Class<? extends WeavableCollectionConfigEntry> collectionEntryClass) {
		this.collectionEntryClass = collectionEntryClass;
	}


	public static class CollectionWeavingConfigImplBuilder {
		private Class<? extends WeavableCollectionConfigEntry> collectionEntryClass;

		CollectionWeavingConfigImplBuilder() {
		}

		/**
		 * @return {@code this}.
		 */
		public CollectionWeavingConfigImpl.CollectionWeavingConfigImplBuilder collectionEntryClass(@Nullable final Class<? extends WeavableCollectionConfigEntry> collectionEntryClass) {
			this.collectionEntryClass = collectionEntryClass;
			return this;
		}

		public CollectionWeavingConfigImpl build() {
			return new CollectionWeavingConfigImpl(this.collectionEntryClass);
		}

		@Override
		public String toString() {
			return "CollectionWeavingConfigImpl.CollectionWeavingConfigImplBuilder(collectionEntryClass=" + this.collectionEntryClass + ")";
		}
	}

	public static CollectionWeavingConfigImpl.CollectionWeavingConfigImplBuilder builder() {
		return new CollectionWeavingConfigImpl.CollectionWeavingConfigImplBuilder();
	}

	@Nullable
	public Class<? extends WeavableCollectionConfigEntry> collectionEntryClass() {
		return this.collectionEntryClass;
	}

	@Override
	public boolean equals(final Object o) {
		if (o == this) return true;
		if (!(o instanceof CollectionWeavingConfigImpl)) return false;
		final CollectionWeavingConfigImpl other = (CollectionWeavingConfigImpl) o;
		final Object this$collectionEntryClass = this.collectionEntryClass();
		final Object other$collectionEntryClass = other.collectionEntryClass();
		if (this$collectionEntryClass == null ? other$collectionEntryClass != null : !this$collectionEntryClass.equals(other$collectionEntryClass)) return false;
		return true;
	}

	@Override
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		final Object $collectionEntryClass = this.collectionEntryClass();
		result = result * PRIME + ($collectionEntryClass == null ? 43 : $collectionEntryClass.hashCode());
		return result;
	}

	@Override
	public String toString() {
		return "CollectionWeavingConfigImpl(collectionEntryClass=" + this.collectionEntryClass() + ")";
	}
}
