/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.weaver.pojo.impl.weaving;

import de.siphalor.tweed5.annotationinheritance.api.AnnotationInheritanceAwareAnnotatedElement;
import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.patchwork.api.Patchwork;
import de.siphalor.tweed5.patchwork.api.PatchworkFactory;
import de.siphalor.tweed5.shadowed.org.apache.commons.logging.Log;
import de.siphalor.tweed5.shadowed.org.apache.commons.logging.LogFactory;
import de.siphalor.tweed5.typeutils.api.type.ActualType;
import de.siphalor.tweed5.weaver.pojo.api.annotation.PojoWeaving;
import de.siphalor.tweed5.weaver.pojo.api.annotation.PojoWeavingExtension;
import de.siphalor.tweed5.weaver.pojo.api.annotation.TweedExtension;
import de.siphalor.tweed5.weaver.pojo.api.weaving.ProtoWeavingContext;
import de.siphalor.tweed5.weaver.pojo.api.weaving.TweedPojoWeavingExtension;
import de.siphalor.tweed5.weaver.pojo.api.weaving.WeavingContext;
import de.siphalor.tweed5.weaver.pojo.impl.weaving.PojoWeavingException;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class TweedPojoWeaverBootstrapper<T> {
    @Generated
    private static final Log log = LogFactory.getLog(TweedPojoWeaverBootstrapper.class);
    private final Class<T> pojoClass;
    private final AnnotatedElement pojoAnnotations;
    private final ConfigContainer<T> configContainer;
    private final Collection<TweedPojoWeavingExtension> weavingExtensions;
    private final WeavingContext.WeavingFn weavingContextFn = new WeavingContext.WeavingFn(){

        public <U> ConfigEntry<U> weaveEntry(ActualType<U> valueType, Patchwork extensionsData, ProtoWeavingContext context) {
            return TweedPojoWeaverBootstrapper.this.weaveEntry(valueType, extensionsData, context);
        }

        public <U> ConfigEntry<U> weavePseudoEntry(WeavingContext parentContext, String pseudoEntryName, Patchwork extensionsData) {
            return TweedPojoWeaverBootstrapper.this.weavePseudoEntry(parentContext, pseudoEntryName, extensionsData);
        }
    };
    private @Nullable PatchworkFactory weavingExtensionsPatchworkFactory;

    public static <T> TweedPojoWeaverBootstrapper<T> create(Class<T> pojoClass) {
        AnnotationInheritanceAwareAnnotatedElement pojoAnnotations = new AnnotationInheritanceAwareAnnotatedElement(pojoClass);
        PojoWeaving rootWeavingConfig = TweedPojoWeaverBootstrapper.expectAnnotation((AnnotatedElement)pojoAnnotations, PojoWeaving.class);
        PojoWeavingExtension[] extensionAnnotations = (PojoWeavingExtension[])pojoAnnotations.getAnnotationsByType(PojoWeavingExtension.class);
        ConfigContainer<?> configContainer = TweedPojoWeaverBootstrapper.createConfigContainer(rootWeavingConfig.container());
        TweedExtension[] tweedExtensions = (TweedExtension[])pojoAnnotations.getAnnotationsByType(TweedExtension.class);
        configContainer.registerExtensions((Class[])Arrays.stream(tweedExtensions).map(TweedExtension::value).toArray(Class[]::new));
        configContainer.finishExtensionSetup();
        Collection<TweedPojoWeavingExtension> extensions = TweedPojoWeaverBootstrapper.loadWeavingExtensions(Arrays.stream(extensionAnnotations).map(PojoWeavingExtension::value).collect(Collectors.toList()), configContainer);
        return new TweedPojoWeaverBootstrapper<T>(pojoClass, (AnnotatedElement)pojoAnnotations, configContainer, extensions);
    }

    private static Collection<TweedPojoWeavingExtension> loadWeavingExtensions(Collection<Class<? extends TweedPojoWeavingExtension>> weaverClasses, ConfigContainer<?> configContainer) {
        return weaverClasses.stream().map(weaverClass -> (TweedPojoWeavingExtension)TweedPojoWeavingExtension.FACTORY.construct(weaverClass).typedArg(ConfigContainer.class, (Object)configContainer).finish()).collect(Collectors.toList());
    }

    private static ConfigContainer<?> createConfigContainer(Class<? extends ConfigContainer<?>> containerClass) {
        try {
            return (ConfigContainer)ConfigContainer.FACTORY.construct(containerClass).finish();
        }
        catch (Exception e) {
            throw new PojoWeavingException("Failed to instantiate config container");
        }
    }

    private static <A extends Annotation> A expectAnnotation(AnnotatedElement element, Class<A> annotationClass) {
        A annotation = element.getAnnotation(annotationClass);
        if (annotation == null) {
            throw new PojoWeavingException("Annotation " + annotationClass.getName() + " must be defined on class " + element);
        }
        return annotation;
    }

    public ConfigContainer<T> weave() {
        this.setupWeavingExtensions();
        assert (this.weavingExtensionsPatchworkFactory != null);
        ConfigEntry rootEntry = this.weaveEntry(ActualType.ofClass(this.pojoClass), this.weavingExtensionsPatchworkFactory.create(), ProtoWeavingContext.create(this.configContainer, this.pojoAnnotations));
        this.configContainer.attachTree(rootEntry);
        this.runAfterWeaveHooks();
        return this.configContainer;
    }

    private void setupWeavingExtensions() {
        PatchworkFactory.Builder weavingExtensionsPatchworkFactoryBuilder = PatchworkFactory.builder();
        TweedPojoWeavingExtension.SetupContext setupContext = arg_0 -> ((PatchworkFactory.Builder)weavingExtensionsPatchworkFactoryBuilder).registerPart(arg_0);
        for (TweedPojoWeavingExtension weaver : this.weavingExtensions) {
            weaver.setup(setupContext);
        }
        this.weavingExtensionsPatchworkFactory = weavingExtensionsPatchworkFactoryBuilder.build();
    }

    private <U> ConfigEntry<U> weaveEntry(ActualType<U> valueType, Patchwork extensionsData, ProtoWeavingContext protoContext) {
        extensionsData = extensionsData.copy();
        this.runBeforeWeaveEntryHooks(valueType, extensionsData, protoContext);
        WeavingContext context = WeavingContext.builder().parent(protoContext.parent()).weavingFunction(this.weavingContextFn).configContainer(this.configContainer).valueType(valueType).path(protoContext.path()).extensionsData(extensionsData).annotations((AnnotatedElement)new AnnotationInheritanceAwareAnnotatedElement(protoContext.annotations())).build();
        for (TweedPojoWeavingExtension weavingExtension : this.weavingExtensions) {
            try {
                ConfigEntry<U> configEntry = weavingExtension.weaveEntry(valueType, context);
                if (configEntry == null) continue;
                this.runAfterWeaveEntryHooks(valueType, configEntry, context);
                return configEntry;
            }
            catch (Exception e) {
                log.error((Object)("Failed to run Tweed POJO weaver (" + weavingExtension.getClass().getName() + ") for entry at " + Arrays.toString(context.path())), (Throwable)e);
            }
        }
        throw new PojoWeavingException("Failed to weave entry for " + valueType + " at " + Arrays.toString(context.path()) + ": No matching weavers found.\nRegistered weaving extensions: " + this.weavingExtensions.stream().map((Function<TweedPojoWeavingExtension, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Lde/siphalor/tweed5/weaver/pojo/api/weaving/TweedPojoWeavingExtension;)Ljava/lang/Class;)()).map(Class::getName).collect(Collectors.joining(", ")));
    }

    private <U> ConfigEntry<U> weavePseudoEntry(WeavingContext parentContext, String pseudoEntryName, Patchwork extensionsData) {
        extensionsData = extensionsData.copy();
        ActualType<?> valueType = parentContext.valueType();
        String[] path = Arrays.copyOf(parentContext.path(), parentContext.path().length + 1);
        path[path.length - 1] = ":" + pseudoEntryName;
        WeavingContext context = WeavingContext.builder().parent(parentContext).weavingFunction(this.weavingContextFn).configContainer(this.configContainer).path(path).valueType(parentContext.valueType()).isPseudo(true).extensionsData(extensionsData).annotations(parentContext.annotations()).build();
        for (TweedPojoWeavingExtension weavingExtension : this.weavingExtensions) {
            try {
                ConfigEntry<?> configEntry = weavingExtension.weaveEntry(valueType, context);
                if (configEntry == null) continue;
                this.runAfterWeaveEntryHooks(valueType, configEntry, context);
                return configEntry;
            }
            catch (Exception e) {
                log.error((Object)("Failed to run Tweed POJO weaver (" + weavingExtension.getClass().getName() + ") for pseudo entry at " + Arrays.toString(context.path())), (Throwable)e);
            }
        }
        throw new PojoWeavingException("Failed to weave pseudo entry for " + valueType + " at " + Arrays.toString(context.path()) + ": No matching weavers found");
    }

    private <U> void runBeforeWeaveEntryHooks(ActualType<U> dataClass, Patchwork extensionsData, ProtoWeavingContext protoContext) {
        for (TweedPojoWeavingExtension weavingExtension : this.weavingExtensions) {
            try {
                weavingExtension.beforeWeaveEntry(dataClass, extensionsData, protoContext);
            }
            catch (Exception e) {
                log.error((Object)("Failed to apply Tweed POJO weaver before weave hook (" + weavingExtension.getClass().getName() + ")"), (Throwable)e);
            }
        }
    }

    private <U> void runAfterWeaveEntryHooks(ActualType<U> dataClass, ConfigEntry<U> configEntry, WeavingContext context) {
        for (TweedPojoWeavingExtension weavingExtension : this.weavingExtensions) {
            try {
                weavingExtension.afterWeaveEntry(dataClass, configEntry, context);
            }
            catch (Exception e) {
                log.error((Object)("Failed to apply Tweed POJO weaver after weave hook (" + weavingExtension.getClass().getName() + ")"), (Throwable)e);
            }
        }
    }

    private void runAfterWeaveHooks() {
        for (TweedPojoWeavingExtension weavingExtension : this.weavingExtensions) {
            weavingExtension.afterWeave();
        }
    }

    @Generated
    private TweedPojoWeaverBootstrapper(Class<T> pojoClass, AnnotatedElement pojoAnnotations, ConfigContainer<T> configContainer, Collection<TweedPojoWeavingExtension> weavingExtensions) {
        this.pojoClass = pojoClass;
        this.pojoAnnotations = pojoAnnotations;
        this.configContainer = configContainer;
        this.weavingExtensions = weavingExtensions;
    }
}

