package de.siphalor.tweed5.weaver.pojo.api.weaving;

import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.patchwork.api.Patchwork;
import de.siphalor.tweed5.typeutils.api.type.ActualType;
import org.jspecify.annotations.Nullable;
import java.lang.reflect.AnnotatedElement;

public final class WeavingContext {
	@Nullable
	private final WeavingContext parent;
	private final WeavingFn weavingFunction;
	private final ConfigContainer<?> configContainer;
	private final String[] path;
	private final ActualType<?> valueType;
	private final boolean isPseudo;
	private final Patchwork extensionsData;
	private final AnnotatedElement annotations;

	public <T> ConfigEntry<T> weaveEntry(ActualType<T> valueType, Patchwork extensionsData, ProtoWeavingContext context) {
		return weavingFunction.weaveEntry(valueType, extensionsData, context);
	}

	public <T> ConfigEntry<T> weavePseudoEntry(WeavingContext parentContext, String pseudoEntryName, Patchwork extensionsData) {
		return weavingFunction.weavePseudoEntry(parentContext, pseudoEntryName, extensionsData);
	}


	public interface WeavingFn {
		<T> ConfigEntry<T> weaveEntry(ActualType<T> valueType, Patchwork extensionsData, ProtoWeavingContext context);

		<T> ConfigEntry<T> weavePseudoEntry(WeavingContext parentContext, String pseudoEntryName, Patchwork extensionsData);
	}

	WeavingContext(@Nullable final WeavingContext parent, final WeavingFn weavingFunction, final ConfigContainer<?> configContainer, final String[] path, final ActualType<?> valueType, final boolean isPseudo, final Patchwork extensionsData, final AnnotatedElement annotations) {
		this.parent = parent;
		this.weavingFunction = weavingFunction;
		this.configContainer = configContainer;
		this.path = path;
		this.valueType = valueType;
		this.isPseudo = isPseudo;
		this.extensionsData = extensionsData;
		this.annotations = annotations;
	}


	public static class WeavingContextBuilder {
		private WeavingContext parent;
		private WeavingFn weavingFunction;
		private ConfigContainer<?> configContainer;
		private String[] path;
		private ActualType<?> valueType;
		private boolean isPseudo;
		private Patchwork extensionsData;
		private AnnotatedElement annotations;

		WeavingContextBuilder() {
		}

		/**
		 * @return {@code this}.
		 */
		public WeavingContext.WeavingContextBuilder parent(@Nullable final WeavingContext parent) {
			this.parent = parent;
			return this;
		}

		/**
		 * @return {@code this}.
		 */
		public WeavingContext.WeavingContextBuilder weavingFunction(final WeavingFn weavingFunction) {
			this.weavingFunction = weavingFunction;
			return this;
		}

		/**
		 * @return {@code this}.
		 */
		public WeavingContext.WeavingContextBuilder configContainer(final ConfigContainer<?> configContainer) {
			this.configContainer = configContainer;
			return this;
		}

		/**
		 * @return {@code this}.
		 */
		public WeavingContext.WeavingContextBuilder path(final String[] path) {
			this.path = path;
			return this;
		}

		/**
		 * @return {@code this}.
		 */
		public WeavingContext.WeavingContextBuilder valueType(final ActualType<?> valueType) {
			this.valueType = valueType;
			return this;
		}

		/**
		 * @return {@code this}.
		 */
		public WeavingContext.WeavingContextBuilder isPseudo(final boolean isPseudo) {
			this.isPseudo = isPseudo;
			return this;
		}

		/**
		 * @return {@code this}.
		 */
		public WeavingContext.WeavingContextBuilder extensionsData(final Patchwork extensionsData) {
			this.extensionsData = extensionsData;
			return this;
		}

		/**
		 * @return {@code this}.
		 */
		public WeavingContext.WeavingContextBuilder annotations(final AnnotatedElement annotations) {
			this.annotations = annotations;
			return this;
		}

		public WeavingContext build() {
			return new WeavingContext(this.parent, this.weavingFunction, this.configContainer, this.path, this.valueType, this.isPseudo, this.extensionsData, this.annotations);
		}

		@Override
		public String toString() {
			return "WeavingContext.WeavingContextBuilder(parent=" + this.parent + ", weavingFunction=" + this.weavingFunction + ", configContainer=" + this.configContainer + ", path=" + java.util.Arrays.deepToString(this.path) + ", valueType=" + this.valueType + ", isPseudo=" + this.isPseudo + ", extensionsData=" + this.extensionsData + ", annotations=" + this.annotations + ")";
		}
	}

	public static WeavingContext.WeavingContextBuilder builder() {
		return new WeavingContext.WeavingContextBuilder();
	}

	@Nullable
	public WeavingContext parent() {
		return this.parent;
	}

	public ConfigContainer<?> configContainer() {
		return this.configContainer;
	}

	public String[] path() {
		return this.path;
	}

	public ActualType<?> valueType() {
		return this.valueType;
	}

	public boolean isPseudo() {
		return this.isPseudo;
	}

	public Patchwork extensionsData() {
		return this.extensionsData;
	}

	public AnnotatedElement annotations() {
		return this.annotations;
	}

	@Override
	public boolean equals(final Object o) {
		if (o == this) return true;
		if (!(o instanceof WeavingContext)) return false;
		final WeavingContext other = (WeavingContext) o;
		if (this.isPseudo() != other.isPseudo()) return false;
		final Object this$parent = this.parent();
		final Object other$parent = other.parent();
		if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) return false;
		final Object this$weavingFunction = this.weavingFunction;
		final Object other$weavingFunction = other.weavingFunction;
		if (this$weavingFunction == null ? other$weavingFunction != null : !this$weavingFunction.equals(other$weavingFunction)) return false;
		final Object this$configContainer = this.configContainer();
		final Object other$configContainer = other.configContainer();
		if (this$configContainer == null ? other$configContainer != null : !this$configContainer.equals(other$configContainer)) return false;
		if (!java.util.Arrays.deepEquals(this.path(), other.path())) return false;
		final Object this$valueType = this.valueType();
		final Object other$valueType = other.valueType();
		if (this$valueType == null ? other$valueType != null : !this$valueType.equals(other$valueType)) return false;
		final Object this$extensionsData = this.extensionsData();
		final Object other$extensionsData = other.extensionsData();
		if (this$extensionsData == null ? other$extensionsData != null : !this$extensionsData.equals(other$extensionsData)) return false;
		final Object this$annotations = this.annotations();
		final Object other$annotations = other.annotations();
		if (this$annotations == null ? other$annotations != null : !this$annotations.equals(other$annotations)) return false;
		return true;
	}

	@Override
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		result = result * PRIME + (this.isPseudo() ? 79 : 97);
		final Object $parent = this.parent();
		result = result * PRIME + ($parent == null ? 43 : $parent.hashCode());
		final Object $weavingFunction = this.weavingFunction;
		result = result * PRIME + ($weavingFunction == null ? 43 : $weavingFunction.hashCode());
		final Object $configContainer = this.configContainer();
		result = result * PRIME + ($configContainer == null ? 43 : $configContainer.hashCode());
		result = result * PRIME + java.util.Arrays.deepHashCode(this.path());
		final Object $valueType = this.valueType();
		result = result * PRIME + ($valueType == null ? 43 : $valueType.hashCode());
		final Object $extensionsData = this.extensionsData();
		result = result * PRIME + ($extensionsData == null ? 43 : $extensionsData.hashCode());
		final Object $annotations = this.annotations();
		result = result * PRIME + ($annotations == null ? 43 : $annotations.hashCode());
		return result;
	}

	@Override
	public String toString() {
		return "WeavingContext(parent=" + this.parent() + ", weavingFunction=" + this.weavingFunction + ", configContainer=" + this.configContainer() + ", path=" + java.util.Arrays.deepToString(this.path()) + ", valueType=" + this.valueType() + ", isPseudo=" + this.isPseudo() + ", extensionsData=" + this.extensionsData() + ", annotations=" + this.annotations() + ")";
	}
}
