/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.weaver.pojo.impl.entry;

import de.siphalor.tweed5.construct.api.ConstructParameter;
import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.entry.BaseConfigEntry;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.core.api.entry.ConfigEntryValueVisitor;
import de.siphalor.tweed5.weaver.pojo.api.entry.WeavableCompoundConfigEntry;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class StaticPojoCompoundConfigEntry<T>
extends BaseConfigEntry<T>
implements WeavableCompoundConfigEntry<T> {
    private final Supplier<T> noArgsConstructor;
    private final Map<String, WeavableCompoundConfigEntry.SubEntry> subEntries;
    private final Map<String, ConfigEntry<?>> subConfigEntries;

    public StaticPojoCompoundConfigEntry(ConfigContainer<?> configContainer, Class<T> valueClass, Supplier<T> noArgsConstructor, @ConstructParameter(name="subEntries") List<WeavableCompoundConfigEntry.SubEntry> subEntries) {
        super(configContainer, valueClass);
        this.noArgsConstructor = noArgsConstructor;
        this.subEntries = new LinkedHashMap<String, WeavableCompoundConfigEntry.SubEntry>(subEntries.size(), 1.0f);
        this.subConfigEntries = new LinkedHashMap(subEntries.size(), 1.0f);
        for (WeavableCompoundConfigEntry.SubEntry subEntry : subEntries) {
            this.subEntries.put(subEntry.name(), subEntry);
            this.subConfigEntries.put(subEntry.name(), subEntry.configEntry());
        }
    }

    public Map<String, ConfigEntry<?>> subEntries() {
        return Collections.unmodifiableMap(this.subConfigEntries);
    }

    public <V> void set(T compoundValue, String key, V value) {
        WeavableCompoundConfigEntry.SubEntry subEntry = this.subEntries.get(key);
        if (subEntry == null) {
            throw new IllegalArgumentException("Unknown config entry: " + key);
        }
        try {
            subEntry.setter().invoke(compoundValue, value);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to set value for config entry \"" + key + "\"", e);
        }
    }

    public <V> V get(T compoundValue, String key) {
        WeavableCompoundConfigEntry.SubEntry subEntry = this.subEntries.get(key);
        if (subEntry == null) {
            throw new IllegalArgumentException("Unknown config entry: " + key);
        }
        try {
            return (V)subEntry.getter().invoke(compoundValue);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to get value for config entry \"" + key + "\"", e);
        }
    }

    public T instantiateCompoundValue() {
        try {
            return this.noArgsConstructor.get();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to instantiate compound class", e);
        }
    }

    public void visitInOrder(ConfigEntryValueVisitor visitor, T value) {
        if (visitor.enterStructuredEntry((ConfigEntry)this, value)) {
            this.subEntries.forEach((key, entry) -> {
                if (visitor.enterStructuredSubEntry(key, key)) {
                    try {
                        Object subValue = entry.getter().invoke(value);
                        entry.configEntry().visitInOrder(visitor, subValue);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("Failed to get compound sub entry value \"" + key + "\"");
                    }
                }
            });
        }
    }

    public T deepCopy(T value) {
        T copy = this.instantiateCompoundValue();
        for (WeavableCompoundConfigEntry.SubEntry subEntry : this.subEntries.values()) {
            try {
                Object subValue = subEntry.getter().invoke(value);
                subEntry.setter().invoke(copy, subValue);
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to copy value of sub entry \"" + subEntry.name() + "\"", e);
            }
        }
        return copy;
    }
}

