/*
 * Copyright 2021 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.wanderingcollector.mixin;

import de.siphalor.wanderingcollector.util.IServerPlayerEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

@Mixin(class_1542.class)
public abstract class MixinItemEntity extends class_1297 {
	public MixinItemEntity(class_1299<?> type, class_1937 world) {
		super(type, world);
	}

	@Shadow public abstract class_1799 getStack();

	@Shadow private UUID thrower;

	@Inject(
			method = "tick",
			at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/ItemEntity;discard()V", ordinal = 1)
	)
	public void tickInject(CallbackInfo callbackInfo) {
		addStackToThrower();
	}

	@Inject(
			method = "damage",
			at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/ItemEntity;discard()V")
	)
	public void onDeathInject(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
		addStackToThrower();
	}

	@Unique
	private void addStackToThrower() {
		if (thrower != null) {
			class_1657 player = field_6002.method_18470(thrower);
			if (player instanceof IServerPlayerEntity) {
				((IServerPlayerEntity) player).wandering_collector$addLostStack(getStack());
			}
		}
	}
}
