/*
 * Copyright 2021 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.wanderingcollector.mixin;

import de.siphalor.wanderingcollector.util.IMerchantInventory;
import de.siphalor.wanderingcollector.util.IWanderingTraderEntity;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1725;
import net.minecraft.class_1728;
import net.minecraft.class_1915;
import net.minecraft.class_1916;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1728.class)
public abstract class MixinMerchantScreenHandler extends class_1703 {
	@Shadow @Final private class_1725 merchantInventory;

	@Shadow @Final private class_1915 merchant;

	protected MixinMerchantScreenHandler(@Nullable class_3917<?> type, int syncId) {
		super(type, syncId);
	}

	@Inject(method = "<init>(ILnet/minecraft/entity/player/PlayerInventory;Lnet/minecraft/village/Merchant;)V", at = @At("RETURN"))
	public void onInit(int syncId, class_1661 playerInventory, class_1915 merchant, CallbackInfo callbackInfo) {
		((IMerchantInventory) merchantInventory).wandering_collector$setPlayer(playerInventory.field_7546);
	}

	@Inject(method = "getRecipes", at = @At("HEAD"), cancellable = true)
	public void getOffersInject(CallbackInfoReturnable<class_1916> cir) {
		if (merchant instanceof IWanderingTraderEntity) {
			cir.setReturnValue(((IWanderingTraderEntity) merchant).wandering_collector$getOffers(merchant.method_8257()));
		}
	}
}
