/*
 * Copyright 2021 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.wanderingcollector.mixin;

import com.mojang.authlib.GameProfile;
import de.siphalor.wanderingcollector.util.IServerPlayerEntity;
import de.siphalor.wanderingcollector.WCConfig;
import de.siphalor.wanderingcollector.WanderingCollector;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_3222;

@Mixin(class_3222.class)
public abstract class MixinServerPlayerEntity extends class_1657 implements IServerPlayerEntity {
	@Unique
	private ArrayList<class_2487> lostStacks = new ArrayList<>();

	public MixinServerPlayerEntity(class_1937 world, class_2338 pos, float yaw, GameProfile profile) {
		super(world, pos, yaw, profile);
	}

	@Inject(method = "copyFrom", at = @At("RETURN"))
	public void copyFromInject(class_3222 other, boolean alive, CallbackInfo callbackInfo) {
		lostStacks = ((IServerPlayerEntity) other).wandering_collector$getLostStackCompounds();
	}

	@Inject(method = "readCustomDataFromNbt", at = @At("RETURN"))
	public void readCustomDataFromTagInject(class_2487 tag, CallbackInfo callbackInfo) {
		lostStacks.clear();
		if (tag.method_10573(WanderingCollector.LOST_STACKS_KEY, 9)) {
			class_2499 lostStacksTag = tag.method_10554(WanderingCollector.LOST_STACKS_KEY, 10);
			//noinspection unchecked
			lostStacks.addAll((Collection<? extends class_2487>) (Object) lostStacksTag.method_10612());
		}
	}

	@Inject(method = "writeCustomDataToNbt", at = @At("RETURN"))
	public void writeCustomDataToTagInject(class_2487 tag, CallbackInfo callbackInfo) {
		class_2499 lostStacksTag = new class_2499();
		lostStacksTag.addAll(lostStacks);
		tag.method_10566(WanderingCollector.LOST_STACKS_KEY, lostStacksTag);
	}

	@Override
	public ArrayList<class_2487> wandering_collector$getLostStackCompounds() {
		return lostStacks;
	}

	@Override
	public void wandering_collector$addLostStack(class_1799 stack) {
		class_2487 compoundTag = stack.method_7953(new class_2487());
		if (lostStacks.size() < WCConfig.maxLostStackAmount) {
			lostStacks.add(compoundTag);
		} else {
			lostStacks.set(field_5974.nextInt(WCConfig.maxLostStackAmount), compoundTag);
		}
	}
}
