/*
 * Copyright 2021-2023 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.wanderingcollector.mixin;

import de.siphalor.wanderingcollector.WanderingCollector;
import de.siphalor.wanderingcollector.util.IItemEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1937;
import net.minecraft.class_2487;

@Mixin(class_1542.class)
public abstract class MixinItemEntity extends class_1297 implements IItemEntity {
	@Unique
	private static final String formerOwnerKey = WanderingCollector.MOD_ID + ":FormerOwner";

	@Unique
	private UUID formerOwner;

	public MixinItemEntity(class_1299<?> type, class_1937 world) {
		super(type, world);
	}

	@Override
	public UUID wanderingCollector$getFormerOwner() {
		return formerOwner;
	}

	@Override
	public void wanderingCollector$setFormerOwner(UUID playerUuid) {
		this.formerOwner = playerUuid;
	}

	@Inject(method = "readCustomDataFromNbt", at = @At("RETURN"))
	public void readCustomDataFromTag(class_2487 tag, CallbackInfo ci) {
		if (tag.method_25928(formerOwnerKey)) {
			formerOwner = tag.method_25926(formerOwnerKey);
		}
	}

	@Inject(method = "writeCustomDataToNbt", at = @At("RETURN"))
	public void writeCustomDataFromTag(class_2487 tag, CallbackInfo ci) {
		if (formerOwner != null) {
			tag.method_25927(formerOwnerKey, formerOwner);
		}
	}

	@Inject(
			method = "tick",
			at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/ItemEntity;discard()V", ordinal = 1)
	)
	public void tickInject(CallbackInfo callbackInfo) {
		WanderingCollector.addStackToThrower((class_1542)(Object) this);
	}

	@Inject(
			method = "damage",
			at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/ItemEntity;discard()V")
	)
	public void onDeathInject(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
		WanderingCollector.addStackToThrower((class_1542)(Object) this);
	}
}
