/*
 * Copyright 2021-2023 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.wanderingcollector.mixin;

import de.siphalor.wanderingcollector.util.IMerchantInventory;
import de.siphalor.wanderingcollector.util.IWanderingTraderEntity;
import net.minecraft.class_1657;
import net.minecraft.class_1725;
import net.minecraft.class_1915;
import net.minecraft.class_1916;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_1725.class)
public class MixinMerchantInventory implements IMerchantInventory {
	@Unique
	private class_1657 player;

	@Override
	public void wandering_collector$setPlayer(class_1657 player) {
		this.player = player;
	}

	@Redirect(method = "updateOffers", at = @At(value = "INVOKE", target = "Lnet/minecraft/village/Merchant;getOffers()Lnet/minecraft/village/TradeOfferList;"))
	public class_1916 getOffersRedirect(class_1915 merchant) {
		if (merchant instanceof IWanderingTraderEntity) {
			return ((IWanderingTraderEntity) merchant).wandering_collector$getOffers(player);
		}
		return merchant.method_8264();
	}
}
