/*
 * Copyright 2021-2023 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.wanderingcollector.mixin;

import de.siphalor.wanderingcollector.*;
import de.siphalor.wanderingcollector.util.IServerPlayerEntity;
import de.siphalor.wanderingcollector.util.IWanderingTraderEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.*;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1728;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1915;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3988;
import net.minecraft.class_3989;
import net.minecraft.class_747;

@Mixin(class_3989.class)
public abstract class MixinWanderingTraderEntity extends class_3988 implements class_1915, IWanderingTraderEntity {
	@Unique
	private final Map<UUID, Collection<class_1914>> playerSpecificTrades = new HashMap<>();

	public MixinWanderingTraderEntity(class_1299<? extends class_3988> entityType, class_1937 world) {
		super(entityType, world);
	}

	@Override
	public class_1916 wandering_collector$getOffers(class_1657 playerEntity) {
		class_1916 tradeOfferList = new class_1916();
		tradeOfferList.addAll(method_8264());
		Collection<class_1914> offers = playerSpecificTrades.get(playerEntity.method_5667());
		if (offers == null) {
			LostItemStorage storage = ((IServerPlayerEntity) playerEntity).wandering_collector$getLostItemStorage();
			if (storage.isEmpty() || WCConfig.buyBackTrades <= 0) {
				offers = Collections.emptyList();
			} else {
				offers = new ArrayList<>(WCConfig.buyBackTrades);
				for (class_1799 stack : storage.poll(WCConfig.buyBackTrades)) {
					offers.add(new class_1914(WCConfig.defaultPrices.getPriceStack(stack), stack, 1, 1, 1F));
				}
			}
			playerSpecificTrades.put(playerEntity.method_5667(), offers);
		}
		tradeOfferList.addAll(offers);
		return tradeOfferList;
	}

	@Override
	public void method_17449(class_1657 playerEntity, class_2561 text, int i) {
		OptionalInt optionalInt = playerEntity.method_17355(new class_747((ix, playerInventory, playerEntityx) ->
				new class_1728(ix, playerInventory, this), text)
		);
		if (optionalInt.isPresent()) {
			class_1916 tradeOfferList = wandering_collector$getOffers(playerEntity);
			if (!tradeOfferList.isEmpty()) {
				playerEntity.method_17354(optionalInt.getAsInt(), tradeOfferList, i, this.method_19269(), this.method_19270(), this.method_20708());
			}
		}
	}

	@Inject(method = "readCustomDataFromNbt", at = @At("RETURN"))
	public void readCustomDataFromTagInject(class_2487 tag, CallbackInfo callbackInfo) {
		playerSpecificTrades.clear();
		if (tag.method_10573(WanderingCollector.PLAYER_SPECIFIC_TRADES, 10)) {
			class_2487 compound = tag.method_10562(WanderingCollector.PLAYER_SPECIFIC_TRADES);
			for (String key : compound.method_10541()) {
				if (compound.method_10573(key, 9)) {
					class_2499 list = compound.method_10554(key, 10);
					ArrayList<class_1914> offers = new ArrayList<>(list.size());
					for (class_2520 tradeTag : list) {
						offers.add(new class_1914((class_2487) tradeTag));
					}
					playerSpecificTrades.put(UUID.fromString(key), offers);
				}
			}
		}
	}

	@Inject(method = "writeCustomDataToNbt", at = @At("RETURN"))
	public void writeCustomDataToTag(class_2487 tag, CallbackInfo callbackInfo) {
		class_2487 compound = new class_2487();
		for (Map.Entry<UUID, Collection<class_1914>> entry : playerSpecificTrades.entrySet()) {
			if (entry.getValue().isEmpty()) {
				continue;
			}
			class_2499 list = new class_2499();
			for (class_1914 tradeOffer : entry.getValue()) {
				list.add(tradeOffer.method_8251());
			}
			compound.method_10566(entry.getKey().toString(), list);
		}
		tag.method_10566(WanderingCollector.PLAYER_SPECIFIC_TRADES, compound);
	}
}
