/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.wanderingcollector;

import de.siphalor.wanderingcollector.WCConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class LostItemStorage {
    private static final Random RANDOM = new Random();
    private final List<class_1799> stacks = new ArrayList<class_1799>();

    public void read(class_2487 parentNbt) {
        this.stacks.clear();
        if (parentNbt.method_10545("wandering_collector:lost_stacks")) {
            class_2487 ownNbt;
            if (parentNbt.method_10573("wandering_collector:lost_stacks", 9)) {
                this.readStacksFrom(parentNbt, "wandering_collector:lost_stacks");
            } else if (parentNbt.method_10573("wandering_collector:lost_stacks", 10) && (ownNbt = parentNbt.method_10562("wandering_collector:lost_stacks")).method_10573("wandering_collector:lost_stacks", 9)) {
                this.readStacksFrom(ownNbt, "Stacks");
            }
        }
    }

    private void readStacksFrom(class_2487 parentNbt, String key) {
        class_2499 listNbt = parentNbt.method_10554(key, 10);
        for (class_2520 stackNbt : listNbt) {
            if (!(stackNbt instanceof class_2487)) continue;
            this.stacks.add(class_1799.method_7915((class_2487)((class_2487)stackNbt)));
        }
    }

    public void write(class_2487 parentNbt) {
        if (this.stacks.isEmpty()) {
            return;
        }
        class_2487 ownNbt = new class_2487();
        parentNbt.method_10566("wandering_collector:lost_stacks", (class_2520)ownNbt);
        class_2499 listNbt = new class_2499();
        for (class_1799 stack : this.stacks) {
            listNbt.add((Object)stack.method_7953(new class_2487()));
        }
        ownNbt.method_10566("Stacks", (class_2520)listNbt);
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public void add(class_1799 newStack) {
        if (WCConfig.combineLostStacks && this.tryCombine(newStack)) {
            return;
        }
        if (this.stacks.size() >= WCConfig.maxLostStackAmount) {
            this.stacks.remove(0);
        }
        this.stacks.add(newStack);
    }

    private boolean tryCombine(class_1799 newStack) {
        int requiredSpace = newStack.method_7947();
        int space = 0;
        ArrayList<class_1799> equalStacks = new ArrayList<class_1799>();
        for (class_1799 stack : this.stacks) {
            if (!class_1799.method_31577((class_1799)stack, (class_1799)newStack)) continue;
            equalStacks.add(stack);
            if ((space += stack.method_7914() - stack.method_7947()) < requiredSpace) continue;
            break;
        }
        if (space < requiredSpace) {
            return false;
        }
        for (class_1799 equalStack : equalStacks) {
            int move = Math.min(equalStack.method_7914() - equalStack.method_7947(), requiredSpace);
            equalStack.method_7933(move);
            if ((requiredSpace -= move) > 0) continue;
            break;
        }
        return true;
    }

    public Collection<class_1799> poll(int stackCount) {
        stackCount = Math.min(stackCount, this.stacks.size());
        ArrayList<class_1799> result = new ArrayList<class_1799>(stackCount);
        switch (WCConfig.offerCreation) {
            case NEWEST: {
                List<class_1799> range = this.stacks.subList(this.stacks.size() - stackCount, this.stacks.size());
                result.addAll(range);
                range.clear();
                break;
            }
            case OLDEST: {
                List<class_1799> range = this.stacks.subList(0, stackCount);
                result.addAll(range);
                range.clear();
                break;
            }
            case RANDOM: {
                for (int i = 0; i < stackCount; ++i) {
                    int randIndex = RANDOM.nextInt(this.stacks.size());
                    class_1799 stack = this.stacks.get(randIndex);
                    if (stack.method_7947() > stack.method_7914()) {
                        result.add(stack.method_7971(stack.method_7914()));
                        continue;
                    }
                    result.add(stack);
                    this.stacks.remove(randIndex);
                }
                break;
            }
        }
        return result;
    }

    public static enum PollMode {
        NEWEST,
        OLDEST,
        RANDOM;

    }
}

