/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.wanderingcollector.util;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import de.siphalor.tweed4.config.constraints.AnnotationConstraint;
import de.siphalor.tweed4.config.constraints.Constraint;
import de.siphalor.wanderingcollector.WanderingCollector;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_151;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.apache.logging.log4j.Level;

public class ConfigRegistryConstraint<T>
implements AnnotationConstraint<String> {
    private class_2378<T> registry;

    public ConfigRegistryConstraint() {
        this(null);
    }

    public ConfigRegistryConstraint(class_2378<T> registry) {
        this.registry = registry;
    }

    private class_2960 getRegistryId() {
        return class_2378.field_11144.method_10221(this.registry);
    }

    public Constraint.Result<String> apply(String value) {
        try {
            class_2960 id = new class_2960(value);
            if (!this.registry.method_10250(id)) {
                return new Constraint.Result(false, null, (List)ImmutableList.of((Object)Pair.of((Object)Constraint.Severity.WARN, (Object)("No such object in registry " + this.getRegistryId() + ": " + value))));
            }
            return new Constraint.Result(true, (Object)value, Collections.emptyList());
        }
        catch (class_151 e) {
            return new Constraint.Result(false, null, (List)ImmutableList.of((Object)Pair.of((Object)Constraint.Severity.ERROR, (Object)("Failed to parse identifier: " + (Object)((Object)e)))));
        }
    }

    public String getDescription() {
        return "Must be a valid identifier and be present in the following registry: " + this.getRegistryId();
    }

    public void fromAnnotationParam(String param, Class<?> valueType) {
        this.registry = (class_2378)class_2378.field_11144.method_10223(class_2960.method_12829((String)param));
        if (this.registry == null) {
            WanderingCollector.log(Level.WARN, "Unknown config registry in constraint: " + param);
        }
    }
}

