/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.github.vampirestudios.vampirelib;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipesProvider;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.minecraft.class_1299;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1856.class_1857;
import net.minecraft.class_1856.class_1858;
import net.minecraft.class_1856.class_1859;
import net.minecraft.class_1935;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2444;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2474;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_5284;
import net.minecraft.class_5458;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import net.minecraft.class_7134;
import io.github.vampirestudios.vampirelib.api.CustomTagProviders;
import io.github.vampirestudios.vampirelib.api.FabricLanguageProvider;
import io.github.vampirestudios.vampirelib.init.VTags;
import io.github.vampirestudios.vampirelib.mixins.IngredientAccessor;
import io.github.vampirestudios.vampirelib.mixins.ShapedRecipeResultAccessor;
import io.github.vampirestudios.vampirelib.mixins.ShapelessRecipeResultAccessor;
import io.github.vampirestudios.vampirelib.utils.registry.WoodRegistry;

import static io.github.vampirestudios.vampirelib.VampireLib.TEST_CONTENT_ENABLED;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.BARRELS;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.BARRELS_WOODEN;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.CHESTS;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.CHESTS_ENDER;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.CHESTS_TRAPPED;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.CHESTS_WOODEN;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.COBBLESTONE;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.COBBLESTONE_DEEPSLATE;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.COBBLESTONE_INFESTED;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.COBBLESTONE_MOSSY;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.COBBLESTONE_NORMAL;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.DIRT;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.ENDERMAN_PLACE_ON_BLACKLIST;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.END_STONES;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.FENCES_NETHER_BRICK;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.FENCES_WOODEN;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.FENCE_GATES_WOODEN;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.GLASS;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.GLASS_COLORLESS;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.GLASS_PANES;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.GLASS_PANES_COLORLESS;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.GLASS_SILICA;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.GLASS_TINTED;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.GRAVEL;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.NETHERRACK;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.OBSIDIAN;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.ORES;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.ORES_COAL;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.ORES_COPPER;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.ORES_DIAMOND;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.ORES_EMERALD;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.ORES_GOLD;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.ORES_IN_GROUND_DEEPSLATE;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.ORES_IN_GROUND_NETHERRACK;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.ORES_IN_GROUND_STONE;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.ORES_IRON;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.ORES_LAPIS;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.ORES_NETHERITE_SCRAP;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.ORES_QUARTZ;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.ORES_REDSTONE;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.ORE_BEARING_GROUND_DEEPSLATE;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.ORE_BEARING_GROUND_NETHERRACK;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.ORE_BEARING_GROUND_STONE;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.ORE_RATES_DENSE;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.ORE_RATES_SINGULAR;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.ORE_RATES_SPARSE;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.SAND;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.SANDSTONE;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.SAND_COLORLESS;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.SAND_RED;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.STAINED_GLASS;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.STAINED_GLASS_PANES;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.STONE;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.STORAGE_BLOCKS;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.STORAGE_BLOCKS_AMETHYST;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.STORAGE_BLOCKS_COAL;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.STORAGE_BLOCKS_COPPER;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.STORAGE_BLOCKS_DIAMOND;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.STORAGE_BLOCKS_EMERALD;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.STORAGE_BLOCKS_GOLD;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.STORAGE_BLOCKS_IRON;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.STORAGE_BLOCKS_LAPIS;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.STORAGE_BLOCKS_NETHERITE;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.STORAGE_BLOCKS_QUARTZ;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.STORAGE_BLOCKS_RAW_COPPER;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.STORAGE_BLOCKS_RAW_GOLD;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.STORAGE_BLOCKS_RAW_IRON;
import static io.github.vampirestudios.vampirelib.init.VTags.Blocks.STORAGE_BLOCKS_REDSTONE;
import static net.minecraft.class_3481.field_16584;
import static net.minecraft.class_3481.field_25147;

public class VampireLibDataGen implements DataGeneratorEntrypoint {
    @Override
    public void onInitializeDataGenerator(FabricDataGenerator dataGenerator) {
        if (TEST_CONTENT_ENABLED) {
            dataGenerator.addProvider(WoodTypeBlockStateDefinitionProvider::new);
            dataGenerator.addProvider(WoodTypeEnglishLanguageProvider::new);
            dataGenerator.addProvider(WoodTypeFrenchLanguageProvider::new);
            dataGenerator.addProvider(WoodTypeRecipeProvider::new);
        }
        VBlockTagsProvider blockTagsProvider = dataGenerator.addProvider(VBlockTagsProvider::new);
        dataGenerator.addProvider(new VItemTagsProvider(dataGenerator, blockTagsProvider));
        dataGenerator.addProvider(VRecipeReplacementProvider::new);
        dataGenerator.addProvider(VEntityTypeTagsProvider::new);
        dataGenerator.addProvider(VBiomeTagsProvider::new);
        dataGenerator.addProvider(VNoiseSettingsTagsProvider::new);
        dataGenerator.addProvider(VDimensionTypeTagsProvider::new);
    }

    //Wood Type Test Generation
    private static class WoodTypeBlockStateDefinitionProvider extends FabricModelProvider {
        private WoodTypeBlockStateDefinitionProvider(FabricDataGenerator generator) {
            super(generator);
        }

        @Override
        public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
            generateWoodTypeAssets(blockStateModelGenerator, VampireLib.TEST_WOOD);
            generateWoodTypeAssets(blockStateModelGenerator, VampireLib.TEST_WOOD1);
            generateWoodTypeAssets(blockStateModelGenerator, VampireLib.TEST_WOOD2);
            generateWoodTypeAssets(blockStateModelGenerator, VampireLib.TEST_WOOD3);
            generateWoodTypeAssets(blockStateModelGenerator, VampireLib.TEST_WOOD4);
            generateWoodTypeAssets(blockStateModelGenerator, VampireLib.TEST_WOOD5);
            generateWoodTypeAssets(blockStateModelGenerator, VampireLib.TEST_WOOD6);
            generateWoodTypeAssets(blockStateModelGenerator, VampireLib.TEST_WOOD7);

            generateWoodTypeAssets(blockStateModelGenerator, VampireLib.TEST_NETHER_WOOD);
            generateWoodTypeAssets(blockStateModelGenerator, VampireLib.TEST_NETHER_WOOD1);
            generateWoodTypeAssets(blockStateModelGenerator, VampireLib.TEST_NETHER_WOOD2);
            generateWoodTypeAssets(blockStateModelGenerator, VampireLib.TEST_NETHER_WOOD3);
            generateWoodTypeAssets(blockStateModelGenerator, VampireLib.TEST_NETHER_WOOD4);
            generateWoodTypeAssets(blockStateModelGenerator, VampireLib.TEST_NETHER_WOOD5);
            generateWoodTypeAssets(blockStateModelGenerator, VampireLib.TEST_NETHER_WOOD6);
            generateWoodTypeAssets(blockStateModelGenerator, VampireLib.TEST_NETHER_WOOD7);
        }

        @Override
        public void generateItemModels(class_4915 itemModelGenerator) {

        }

        private void generateWoodTypeAssets(class_4910 blockStateModelGenerator, WoodRegistry woodRegistry) {
            woodRegistry.generateModels(blockStateModelGenerator);
        }
    }

    private static class WoodTypeEnglishLanguageProvider extends FabricLanguageProvider {
        private WoodTypeEnglishLanguageProvider(FabricDataGenerator dataGenerator) {
            super(dataGenerator, "en_us");
        }

        @Override
        public void registerTranslations() {
            addWoodTypeLang(VampireLib.TEST_WOOD);
            addWoodTypeLang(VampireLib.TEST_WOOD1);
            addWoodTypeLang(VampireLib.TEST_WOOD2);
            addWoodTypeLang(VampireLib.TEST_WOOD3);
            addWoodTypeLang(VampireLib.TEST_WOOD4);
            addWoodTypeLang(VampireLib.TEST_WOOD5);
            addWoodTypeLang(VampireLib.TEST_WOOD6);
            addWoodTypeLang(VampireLib.TEST_WOOD7);

            addWoodTypeLang(VampireLib.TEST_NETHER_WOOD);
            addWoodTypeLang(VampireLib.TEST_NETHER_WOOD1);
            addWoodTypeLang(VampireLib.TEST_NETHER_WOOD2);
            addWoodTypeLang(VampireLib.TEST_NETHER_WOOD3);
            addWoodTypeLang(VampireLib.TEST_NETHER_WOOD4);
            addWoodTypeLang(VampireLib.TEST_NETHER_WOOD5);
            addWoodTypeLang(VampireLib.TEST_NETHER_WOOD6);
            addWoodTypeLang(VampireLib.TEST_NETHER_WOOD7);
        }

        private void addWoodTypeLang(WoodRegistry woodRegistry) {
            woodRegistry.generateLang(this);
        }
    }

    private static class WoodTypeFrenchLanguageProvider extends FabricLanguageProvider {
        private WoodTypeFrenchLanguageProvider(FabricDataGenerator dataGenerator) {
            super(dataGenerator, "fr_fr");
        }

        @Override
        public void registerTranslations() {
            addWoodTypeLang(VampireLib.TEST_WOOD);
            addWoodTypeLang(VampireLib.TEST_WOOD1);
            addWoodTypeLang(VampireLib.TEST_WOOD2);
            addWoodTypeLang(VampireLib.TEST_WOOD3);
            addWoodTypeLang(VampireLib.TEST_WOOD4);
            addWoodTypeLang(VampireLib.TEST_WOOD5);
            addWoodTypeLang(VampireLib.TEST_WOOD6);
            addWoodTypeLang(VampireLib.TEST_WOOD7);

            addWoodTypeLang(VampireLib.TEST_NETHER_WOOD);
            addWoodTypeLang(VampireLib.TEST_NETHER_WOOD1);
            addWoodTypeLang(VampireLib.TEST_NETHER_WOOD2);
            addWoodTypeLang(VampireLib.TEST_NETHER_WOOD3);
            addWoodTypeLang(VampireLib.TEST_NETHER_WOOD4);
            addWoodTypeLang(VampireLib.TEST_NETHER_WOOD5);
            addWoodTypeLang(VampireLib.TEST_NETHER_WOOD6);
            addWoodTypeLang(VampireLib.TEST_NETHER_WOOD7);
        }

        private void addWoodTypeLang(WoodRegistry woodRegistry) {
            woodRegistry.generateLang(this);
        }
    }

    private static class WoodTypeRecipeProvider extends FabricRecipeProvider {
        private WoodTypeRecipeProvider(FabricDataGenerator dataGenerator) {
            super(dataGenerator);
        }

        @Override
        protected void generateRecipes(Consumer<class_2444> exporter) {
            generateWoodTypeRecipes(exporter, VampireLib.TEST_WOOD);
            generateWoodTypeRecipes(exporter, VampireLib.TEST_WOOD1);
            generateWoodTypeRecipes(exporter, VampireLib.TEST_WOOD2);
            generateWoodTypeRecipes(exporter, VampireLib.TEST_WOOD3);
            generateWoodTypeRecipes(exporter, VampireLib.TEST_WOOD4);
            generateWoodTypeRecipes(exporter, VampireLib.TEST_WOOD5);
            generateWoodTypeRecipes(exporter, VampireLib.TEST_WOOD6);
            generateWoodTypeRecipes(exporter, VampireLib.TEST_WOOD7);

            generateWoodTypeRecipes(exporter, VampireLib.TEST_NETHER_WOOD);
            generateWoodTypeRecipes(exporter, VampireLib.TEST_NETHER_WOOD1);
            generateWoodTypeRecipes(exporter, VampireLib.TEST_NETHER_WOOD2);
            generateWoodTypeRecipes(exporter, VampireLib.TEST_NETHER_WOOD3);
            generateWoodTypeRecipes(exporter, VampireLib.TEST_NETHER_WOOD4);
            generateWoodTypeRecipes(exporter, VampireLib.TEST_NETHER_WOOD5);
            generateWoodTypeRecipes(exporter, VampireLib.TEST_NETHER_WOOD6);
            generateWoodTypeRecipes(exporter, VampireLib.TEST_NETHER_WOOD7);
        }

        private void generateWoodTypeRecipes(Consumer<class_2444> exporter, WoodRegistry woodRegistry) {
            woodRegistry.generateRecipes(exporter);
        }
    }

    //VampireLib generators
    private static class VBlockTagsProvider extends CustomTagProviders.CustomBlockTagProvider {
        private VBlockTagsProvider(FabricDataGenerator dataGenerator) {
            super(dataGenerator);
        }

        @Override
        protected Path method_10510(class_2960 id) {
            return this.field_11483.method_10313().resolve("data/%s/tags/blocks/%s.json".formatted("c", id.method_12832()));
        }

        @Override
        protected void generateTags() {
            tagCustom(BARRELS_WOODEN).method_26793(class_2246.field_16328);
            tagCustom(BARRELS).method_26792(BARRELS_WOODEN);
            tagCustom(CHESTS_ENDER).method_26793(class_2246.field_10443);
            tagCustom(CHESTS_TRAPPED).method_26793(class_2246.field_10380);
            tagCustom(CHESTS_WOODEN).method_26795(class_2246.field_10034, class_2246.field_10380);
            tagCustom(CHESTS).addTags(CHESTS_ENDER, CHESTS_TRAPPED, CHESTS_WOODEN);
            method_10512(COBBLESTONE_NORMAL).method_26793(class_2246.field_10445);
            method_10512(COBBLESTONE_INFESTED).method_26793(class_2246.field_10492);
            method_10512(COBBLESTONE_MOSSY).method_26793(class_2246.field_9989);
            method_10512(COBBLESTONE_DEEPSLATE).method_26793(class_2246.field_29031);
            tagCustom(COBBLESTONE).addTags(COBBLESTONE_NORMAL, COBBLESTONE_INFESTED, COBBLESTONE_MOSSY, COBBLESTONE_DEEPSLATE);
            method_10512(DIRT).method_26795(class_2246.field_10566, class_2246.field_10219, class_2246.field_10253, class_2246.field_10520, class_2246.field_10402, class_2246.field_28685);
            method_10512(END_STONES).method_26793(class_2246.field_10471);
            method_10512(ENDERMAN_PLACE_ON_BLACKLIST);
            method_10512(field_25147).method_26792(FENCE_GATES_WOODEN);
            method_10512(FENCE_GATES_WOODEN).method_26795(class_2246.field_10188, class_2246.field_10291, class_2246.field_10513, class_2246.field_10041, class_2246.field_10457, class_2246.field_10196, class_2246.field_22096, class_2246.field_22097);
            tagCustom(field_16584).addTags(FENCES_NETHER_BRICK, FENCES_WOODEN);
            method_10512(FENCES_NETHER_BRICK).method_26793(class_2246.field_10364);
            method_10512(FENCES_WOODEN).method_26795(class_2246.field_10620, class_2246.field_10020, class_2246.field_10299, class_2246.field_10319, class_2246.field_10144, class_2246.field_10132, class_2246.field_22132, class_2246.field_22133);
            method_10512(GLASS).method_26792(GLASS_COLORLESS).method_26792(STAINED_GLASS).method_26792(GLASS_TINTED);
            method_10512(GLASS_COLORLESS).method_26793(class_2246.field_10033);
            method_10512(GLASS_SILICA).method_26795(class_2246.field_10033, class_2246.field_9997, class_2246.field_10060, class_2246.field_10073, class_2246.field_10248, class_2246.field_10555, class_2246.field_10357, class_2246.field_10271, class_2246.field_9996, class_2246.field_10157, class_2246.field_10574, class_2246.field_10227, class_2246.field_10317, class_2246.field_10399, class_2246.field_10272, class_2246.field_10087, class_2246.field_10049);
            method_10512(GLASS_TINTED).method_26793(class_2246.field_27115);
            addColored(method_10512(STAINED_GLASS)::method_26793, GLASS, "{color}_stained_glass");
            tagCustom(GLASS_PANES).addTags(GLASS_PANES_COLORLESS, STAINED_GLASS_PANES);
            method_10512(GLASS_PANES_COLORLESS).method_26793(class_2246.field_10285);
            addColored(method_10512(STAINED_GLASS_PANES)::method_26793, GLASS_PANES, "{color}_stained_glass_pane");
            method_10512(GRAVEL).method_26793(class_2246.field_10255);
            method_10512(NETHERRACK).method_26793(class_2246.field_10515);
            method_10512(OBSIDIAN).method_26793(class_2246.field_10540);
            method_10512(ORE_BEARING_GROUND_DEEPSLATE).method_26793(class_2246.field_28888);
            method_10512(ORE_BEARING_GROUND_NETHERRACK).method_26793(class_2246.field_10515);
            method_10512(ORE_BEARING_GROUND_STONE).method_26793(class_2246.field_10340);
            method_10512(ORE_RATES_DENSE).method_26795(class_2246.field_27120, class_2246.field_29221, class_2246.field_29028, class_2246.field_29030, class_2246.field_10090, class_2246.field_10080);
            method_10512(ORE_RATES_SINGULAR).method_26795(class_2246.field_22109, class_2246.field_10418, class_2246.field_29219, class_2246.field_29029, class_2246.field_29220, class_2246.field_29026, class_2246.field_29027, class_2246.field_10442, class_2246.field_10013, class_2246.field_10571, class_2246.field_10212, class_2246.field_10213);
            method_10512(ORE_RATES_SPARSE).method_26793(class_2246.field_23077);
            tagCustom(ORES).addTags(ORES_COAL, ORES_COPPER, ORES_DIAMOND, ORES_EMERALD, ORES_GOLD, ORES_IRON, ORES_LAPIS, ORES_REDSTONE, ORES_QUARTZ, ORES_NETHERITE_SCRAP);
            method_10512(ORES_COAL).method_26795(class_2246.field_10418, class_2246.field_29219);
            method_10512(ORES_COPPER).method_26795(class_2246.field_27120, class_2246.field_29221);
            method_10512(ORES_DIAMOND).method_26795(class_2246.field_10442, class_2246.field_29029);
            method_10512(ORES_EMERALD).method_26795(class_2246.field_10013, class_2246.field_29220);
            method_10512(ORES_GOLD).method_26795(class_2246.field_10571, class_2246.field_29026);
            method_10512(ORES_IRON).method_26795(class_2246.field_10212, class_2246.field_29027);
            method_10512(ORES_LAPIS).method_26795(class_2246.field_10090, class_2246.field_29028);
            method_10512(ORES_QUARTZ).method_26793(class_2246.field_10213);
            method_10512(ORES_REDSTONE).method_26795(class_2246.field_10080, class_2246.field_29030);
            method_10512(ORES_NETHERITE_SCRAP).method_26793(class_2246.field_22109);
            method_10512(ORES_IN_GROUND_DEEPSLATE).method_26795(class_2246.field_29219, class_2246.field_29221, class_2246.field_29029, class_2246.field_29220, class_2246.field_29026, class_2246.field_29027, class_2246.field_29028, class_2246.field_29030);
            method_10512(ORES_IN_GROUND_NETHERRACK).method_26795(class_2246.field_23077, class_2246.field_10213);
            method_10512(ORES_IN_GROUND_STONE).method_26795(class_2246.field_10418, class_2246.field_27120, class_2246.field_10442, class_2246.field_10013, class_2246.field_10571, class_2246.field_10212, class_2246.field_10090, class_2246.field_10080);
            tagCustom(SAND).addTags(SAND_COLORLESS, SAND_RED);
            method_10512(SAND_COLORLESS).method_26793(class_2246.field_10102);
            method_10512(SAND_RED).method_26793(class_2246.field_10534);
            method_10512(SANDSTONE).method_26795(class_2246.field_9979, class_2246.field_10361, class_2246.field_10292, class_2246.field_10467, class_2246.field_10344, class_2246.field_10518, class_2246.field_10117, class_2246.field_10483);
            method_10512(STONE).method_26795(class_2246.field_10115, class_2246.field_10508, class_2246.field_10474, class_2246.field_10277, class_2246.field_10340, class_2246.field_10093, class_2246.field_10346, class_2246.field_10289, class_2246.field_28888, class_2246.field_28892, class_2246.field_29224, class_2246.field_27165);
            tagCustom(STORAGE_BLOCKS).addTags(STORAGE_BLOCKS_AMETHYST, STORAGE_BLOCKS_COAL, STORAGE_BLOCKS_COPPER, STORAGE_BLOCKS_DIAMOND, STORAGE_BLOCKS_EMERALD, STORAGE_BLOCKS_GOLD, STORAGE_BLOCKS_IRON, STORAGE_BLOCKS_LAPIS, STORAGE_BLOCKS_QUARTZ, STORAGE_BLOCKS_RAW_COPPER, STORAGE_BLOCKS_RAW_GOLD, STORAGE_BLOCKS_RAW_IRON, STORAGE_BLOCKS_REDSTONE, STORAGE_BLOCKS_NETHERITE);
            method_10512(STORAGE_BLOCKS_AMETHYST).method_26793(class_2246.field_27159);
            method_10512(STORAGE_BLOCKS_COAL).method_26793(class_2246.field_10381);
            method_10512(STORAGE_BLOCKS_COPPER).method_26795(class_2246.field_27119, class_2246.field_27124);
            method_10512(STORAGE_BLOCKS_DIAMOND).method_26793(class_2246.field_10201);
            method_10512(STORAGE_BLOCKS_EMERALD).method_26793(class_2246.field_10234);
            method_10512(STORAGE_BLOCKS_GOLD).method_26793(class_2246.field_10205);
            method_10512(STORAGE_BLOCKS_IRON).method_26793(class_2246.field_10085);
            method_10512(STORAGE_BLOCKS_LAPIS).method_26793(class_2246.field_10441);
            method_10512(STORAGE_BLOCKS_QUARTZ).method_26793(class_2246.field_10153);
            method_10512(STORAGE_BLOCKS_RAW_COPPER).method_26793(class_2246.field_33509);
            method_10512(STORAGE_BLOCKS_RAW_GOLD).method_26793(class_2246.field_33510);
            method_10512(STORAGE_BLOCKS_RAW_IRON).method_26793(class_2246.field_33508);
            method_10512(STORAGE_BLOCKS_REDSTONE).method_26793(class_2246.field_10002);
            method_10512(STORAGE_BLOCKS_NETHERITE).method_26793(class_2246.field_22108);
        }

        private void addColored(Consumer<class_2248> consumer, class_6862<class_2248> group, String pattern) {
            String prefix = group.comp_327().method_12832().toUpperCase(Locale.ENGLISH) + '_';
            for (class_1767 color : class_1767.values()) {
                class_2960 key = new class_2960("minecraft", pattern.replace("{color}", color.method_7792()));
                class_6862<class_2248> tag = getForgeTag(prefix + color.method_7792());
                class_2248 block = class_2378.field_11146.method_10223(key);
                if (block == class_2246.field_10124)
                    throw new IllegalStateException("Unknown vanilla block: " + key);
                method_10512(tag).method_26793(block);
                consumer.accept(block);
            }
        }

        @SuppressWarnings("unchecked")
        private class_6862<class_2248> getForgeTag(String name) {
            try {
                name = name.toUpperCase(Locale.ENGLISH);
                return (class_6862<class_2248>) VTags.Blocks.class.getDeclaredField(name).get(null);
            } catch (IllegalArgumentException | IllegalAccessException | NoSuchFieldException | SecurityException e) {
                throw new IllegalStateException(VTags.Blocks.class.getName() + " is missing tag name: " + name);
            }
        }

    }

    private static class VBiomeTagsProvider extends class_2474<class_1959> {
        private VBiomeTagsProvider(FabricDataGenerator dataGenerator) {
            super(dataGenerator, class_5458.field_25933);
        }

        @Override
        protected void method_10514() {
            this.method_10512(VTags.Biomes.HILLS)
                .method_40565(class_1972.field_9414, class_1972.field_9453, class_1972.field_35116, class_1972.field_35111, class_1972.field_35112);
            this.method_10512(class_6908.field_36514).method_26792(VTags.Biomes.HILLS)
                .method_35923(ConventionalBiomeTags.EXTREME_HILLS.comp_327());
            this.method_10512(VTags.Biomes.PLATEAUS)
                .method_40565(class_1972.field_9430, class_1972.field_35110, class_1972.field_34470);
            this.method_10512(VTags.Biomes.RARE)
                .method_40565(class_1972.field_35118, class_1972.field_9430, class_1972.field_9455, class_1972.field_35111,
                    class_1972.field_9414, class_1972.field_9453, class_1972.field_35112, class_1972.field_35113,
                    class_1972.field_35114, class_1972.field_9443, class_1972.field_9440, class_1972.field_9462);

            this.method_10512(VTags.Biomes.OCEANS)
                .method_26792(VTags.Biomes.DEEP_OCEANS).method_26792(VTags.Biomes.SHALLOW_OCEANS);
            this.method_10512(VTags.Biomes.DEEP_OCEANS)
                .method_40565(class_1972.field_9470, class_1972.field_9418, class_1972.field_9439, class_1972.field_9446);
            this.method_10512(VTags.Biomes.SHALLOW_OCEANS)
                .method_40565(class_1972.field_9467, class_1972.field_9435, class_1972.field_9441, class_1972.field_9423, class_1972.field_9408);
            this.method_10512(VTags.Biomes.RIVERS)
                .method_40565(class_1972.field_9438, class_1972.field_9463);
            this.method_10512(VTags.Biomes.WATER)
                .method_26792(VTags.Biomes.OCEANS).method_26792(VTags.Biomes.RIVERS);
            this.method_10512(class_6908.field_36509).method_26792(VTags.Biomes.SHALLOW_OCEANS);
            this.method_10512(class_6908.field_36508).method_26792(VTags.Biomes.DEEP_OCEANS);
            this.method_10512(class_6908.field_36511)
                .method_35923(ConventionalBiomeTags.RIVER.comp_327())
                .method_26792(VTags.Biomes.RIVERS);


            this.method_10512(VTags.Biomes.BADLANDS)
                .method_35923(ConventionalBiomeTags.MESA.comp_327())
                .method_35923(ConventionalBiomeTags.BADLANDS.comp_327())
                .method_40565(class_1972.field_9415, class_1972.field_9443, class_1972.field_35110);
            this.method_10512(class_6908.field_36513).method_26792(VTags.Biomes.BADLANDS);
            this.method_10512(VTags.Biomes.BEACHES)
                .method_35923(ConventionalBiomeTags.STONY_SHORES.comp_327())
                .method_35923(ConventionalBiomeTags.BEACH.comp_327())
                .method_40565(class_1972.field_9434, class_1972.field_9478, class_1972.field_9419);
            this.method_10512(class_6908.field_36510).method_26792(VTags.Biomes.BEACHES);
            this.method_10512(VTags.Biomes.DESERTS)
                .method_35923(ConventionalBiomeTags.DESERT.comp_327())
                .method_40565(class_1972.field_9424);
            this.method_10512(VTags.Biomes.FORESTS)
                .method_35923(ConventionalBiomeTags.FOREST.comp_327())
                .method_35923(ConventionalBiomeTags.FLOWER_FORESTS.comp_327())
                .method_35923(ConventionalBiomeTags.TREE_SAVANNA.comp_327())
                .method_35923(ConventionalBiomeTags.TREE_CONIFEROUS.comp_327())
                .method_35923(ConventionalBiomeTags.TREE_DECIDUOUS.comp_327())
                .method_26792(VTags.Biomes.BIRCH_FORESTS).method_26792(VTags.Biomes.DARK_FORESTS)
                .method_26792(VTags.Biomes.JUNGLE_FORESTS).method_26792(VTags.Biomes.NETHER_FORESTS)
                .method_26792(VTags.Biomes.OAK_FORESTS).method_26792(VTags.Biomes.TAIGA_FORESTS);
            this.method_10512(VTags.Biomes.BIRCH_FORESTS)
                .method_40565(class_1972.field_9412, class_1972.field_35112);
            this.method_10512(VTags.Biomes.DARK_FORESTS)
                .method_40565(class_1972.field_9475);
            this.method_10512(VTags.Biomes.JUNGLE_FORESTS)
                .method_35923(ConventionalBiomeTags.TREE_JUNGLE.comp_327())
                .method_26792(VTags.Biomes.BAMBOO_JUNGLE_FORESTS)
                .method_40565(class_1972.field_9417, class_1972.field_35118);
            this.method_10512(VTags.Biomes.BAMBOO_JUNGLE_FORESTS)
                .method_40565(class_1972.field_9440);
            this.method_10512(class_6908.field_36516).method_26792(VTags.Biomes.JUNGLE_FORESTS);
            this.method_10512(VTags.Biomes.NETHER_FORESTS)
                .method_40565(class_1972.field_22077, class_1972.field_22075)
                .method_35923(ConventionalBiomeTags.NETHER_FORESTS.comp_327());
            this.method_10512(class_6908.field_36518).method_35923(ConventionalBiomeTags.IN_NETHER.comp_327()).method_26792(VTags.Biomes.NETHER_FORESTS);
            this.method_10512(VTags.Biomes.OAK_FORESTS)
                .method_40565(class_1972.field_9409, class_1972.field_9414);
            this.method_10512(VTags.Biomes.TAIGA_FORESTS)
                .method_35923(ConventionalBiomeTags.TAIGA.comp_327())
                .method_40565(class_1972.field_9420, class_1972.field_9454, class_1972.field_35113, class_1972.field_35119, class_1972.field_34471);
            this.method_10512(class_6908.field_36517).method_26792(VTags.Biomes.FORESTS);
            this.method_10512(VTags.Biomes.MUSHROOM)
                .method_40565(class_1972.field_9462);
            this.method_10512(VTags.Biomes.MOUNTAINS)
                .method_35923(ConventionalBiomeTags.MOUNTAIN.comp_327())
                .method_40565(class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_35114);
            this.method_10512(class_6908.field_36512).method_26792(VTags.Biomes.MOUNTAINS);
            this.method_10512(VTags.Biomes.PLAINS)
                .method_40565(class_1972.field_9451, class_1972.field_9449, class_1972.field_9430, class_1972.field_9455, class_1972.field_34470);
            this.method_10512(VTags.Biomes.GRASSLANDS)
                .method_26792(VTags.Biomes.PLAINS).method_26792(VTags.Biomes.SAVANNAS);
            this.method_10512(VTags.Biomes.SAVANNAS)
                .method_35923(ConventionalBiomeTags.SAVANNA.comp_327())
                .method_35923(ConventionalBiomeTags.TREE_SAVANNA.comp_327())
                .method_40565(class_1972.field_9449, class_1972.field_9430, class_1972.field_35114);
            this.method_10512(class_6908.field_37392).method_26792(VTags.Biomes.SAVANNAS);
            this.method_10512(VTags.Biomes.SNOWY)
                .method_35923(ConventionalBiomeTags.SNOWY.comp_327())
                .method_35923(ConventionalBiomeTags.SNOWY_PLAINS.comp_327())
                .method_40565(class_1972.field_9435, class_1972.field_9418, class_1972.field_9463,
                    class_1972.field_9478, class_1972.field_9454, class_1972.field_35117,
                    class_1972.field_34471, class_1972.field_34472, class_1972.field_34474, class_1972.field_35115);
            this.method_10512(class_6908.field_37386).method_26792(VTags.Biomes.SNOWY);
            this.method_10512(class_6908.field_37384).method_26792(VTags.Biomes.SNOWY);
            this.method_10512(VTags.Biomes.SWAMPS)
                .method_35923(ConventionalBiomeTags.SWAMP.comp_327())
                .method_40565(class_1972.field_9471);
            this.method_10512(class_6908.field_37391).method_26792(VTags.Biomes.SWAMPS);
            this.method_10512(VTags.Biomes.SLOPES)
                .method_35923(ConventionalBiomeTags.MOUNTAIN_SLOPE.comp_327())
                .method_40565(class_1972.field_34470, class_1972.field_34471, class_1972.field_34472);
            this.method_10512(VTags.Biomes.PEAKS)
                .method_35923(ConventionalBiomeTags.MOUNTAIN_PEAK.comp_327())
                .method_40565(class_1972.field_34474, class_1972.field_35115, class_1972.field_34475);
            this.method_10512(VTags.Biomes.VOIDS)
                .method_40565(class_1972.field_9473);

            this.method_10512(VTags.Biomes.OVERWORLD)
                .method_26792(VTags.Biomes.OVERWORLD_SURFACE).method_26792(VTags.Biomes.OVERWORLD_UNDERGROUND);
            this.method_10512(class_6908.field_37393).method_26792(VTags.Biomes.OVERWORLD);
            this.method_10512(VTags.Biomes.OVERWORLD_SURFACE)
                .method_40565(class_1972.field_9415,
                    class_1972.field_9440,
                    class_1972.field_9434,
                    class_1972.field_9412,
                    class_1972.field_9467,
                    class_1972.field_9475,
                    class_1972.field_9470,
                    class_1972.field_9418,
                    class_1972.field_9439,
                    class_1972.field_9446,
                    class_1972.field_9424,
                    class_1972.field_9443,
                    class_1972.field_9414,
                    class_1972.field_9409,
                    class_1972.field_9435,
                    class_1972.field_35115,
                    class_1972.field_9463,
                    class_1972.field_34471,
                    class_1972.field_9453,
                    class_1972.field_34474,
                    class_1972.field_9417,
                    class_1972.field_9441,
                    class_1972.field_34470,
                    class_1972.field_9462,
                    class_1972.field_9423,
                    class_1972.field_35112,
                    class_1972.field_35119,
                    class_1972.field_35113,
                    class_1972.field_9451,
                    class_1972.field_9438,
                    class_1972.field_9449,
                    class_1972.field_9430,
                    class_1972.field_9478,
                    class_1972.field_34472,
                    class_1972.field_9454,
                    class_1972.field_35117,
                    class_1972.field_35118,
                    class_1972.field_34475,
                    class_1972.field_9419,
                    class_1972.field_9455,
                    class_1972.field_9471,
                    class_1972.field_9420,
                    class_1972.field_9408,
                    class_1972.field_35110,
                    class_1972.field_35120,
                    class_1972.field_35111,
                    class_1972.field_35116,
                    class_1972.field_35114);
            this.method_10512(VTags.Biomes.OVERWORLD_UNDERGROUND)
                .method_35923(ConventionalBiomeTags.UNDERGROUND.comp_327())
                .method_40565(class_1972.field_29218, class_1972.field_28107);
            this.method_10512(VTags.Biomes.NETHER)
                .method_26792(VTags.Biomes.NETHER_FORESTS)
                .method_40565(class_1972.field_9461, class_1972.field_22076, class_1972.field_23859);
            this.method_10512(class_6908.field_36518).method_26792(VTags.Biomes.NETHER);
            this.method_10512(VTags.Biomes.END)
                .method_35923(ConventionalBiomeTags.END_ISLANDS.comp_327())
                .method_35923(ConventionalBiomeTags.IN_THE_END.comp_327())
                .method_40565(class_1972.field_9411, class_1972.field_9457, class_1972.field_9465, class_1972.field_9447, class_1972.field_9442);
            this.method_10512(class_6908.field_37394).method_26792(VTags.Biomes.END);
        }
    }

    private static class VItemTagsProvider extends CustomTagProviders.CustomItemTagProvider {
        private VItemTagsProvider(FabricDataGenerator dataGenerator, CustomTagProviders.CustomBlockTagProvider blockTagProvider) {
            super(dataGenerator, blockTagProvider);
        }

        @Override
        protected void generateTags() {
            copy(VTags.Blocks.BARRELS_WOODEN, VTags.Items.BARRELS_WOODEN);
            copy(VTags.Blocks.BARRELS, VTags.Items.BARRELS);
            tagCustom(VTags.Items.BONES).method_26793(class_1802.field_8606);
            tagCustom(VTags.Items.BOOKSHELVES).method_26793(class_1802.field_8536);
            copy(VTags.Blocks.CHESTS, VTags.Items.CHESTS);
            copy(VTags.Blocks.CHESTS_ENDER, VTags.Items.CHESTS_ENDER);
            copy(VTags.Blocks.CHESTS_TRAPPED, VTags.Items.CHESTS_TRAPPED);
            copy(VTags.Blocks.CHESTS_WOODEN, VTags.Items.CHESTS_WOODEN);
            copy(VTags.Blocks.COBBLESTONE_NORMAL, VTags.Items.COBBLESTONE_NORMAL);
            copy(VTags.Blocks.COBBLESTONE_INFESTED, VTags.Items.COBBLESTONE_INFESTED);
            copy(VTags.Blocks.COBBLESTONE_MOSSY, VTags.Items.COBBLESTONE_MOSSY);
            copy(VTags.Blocks.COBBLESTONE_DEEPSLATE, VTags.Items.COBBLESTONE_DEEPSLATE);
            tagCustom(VTags.Items.CROPS).addTags(VTags.Items.CROPS_BEETROOT, VTags.Items.CROPS_CARROT, VTags.Items.CROPS_NETHER_WART, VTags.Items.CROPS_POTATO, VTags.Items.CROPS_WHEAT);
            tagCustom(VTags.Items.CROPS_BEETROOT).method_26793(class_1802.field_8186);
            tagCustom(VTags.Items.CROPS_CARROT).method_26793(class_1802.field_8179);
            tagCustom(VTags.Items.CROPS_NETHER_WART).method_26793(class_1802.field_8790);
            tagCustom(VTags.Items.CROPS_POTATO).method_26793(class_1802.field_8567);
            tagCustom(VTags.Items.CROPS_WHEAT).method_26793(class_1802.field_8861);
            tagCustom(VTags.Items.DUSTS).addTags(VTags.Items.DUSTS_GLOWSTONE, VTags.Items.DUSTS_PRISMARINE, VTags.Items.DUSTS_REDSTONE);
            tagCustom(VTags.Items.DUSTS_GLOWSTONE).method_26793(class_1802.field_8601);
            tagCustom(VTags.Items.DUSTS_PRISMARINE).method_26793(class_1802.field_8662);
            tagCustom(VTags.Items.DUSTS_REDSTONE).method_26793(class_1802.field_8725);
            addColored(tagCustom(VTags.Items.DYES)::addTags, VTags.Items.DYES, "{color}_dye");
            tagCustom(VTags.Items.EGGS).method_26793(class_1802.field_8803);
            tagCustom(VTags.Items.ENCHANTING_FUELS).method_26792(VTags.Items.GEMS_LAPIS);
            copy(VTags.Blocks.END_STONES, VTags.Items.END_STONES);
            tagCustom(VTags.Items.ENDER_PEARLS).method_26793(class_1802.field_8634);
            tagCustom(VTags.Items.FEATHERS).method_26793(class_1802.field_8153);
            copy(VTags.Blocks.FENCE_GATES, VTags.Items.FENCE_GATES);
            copy(VTags.Blocks.FENCE_GATES_WOODEN, VTags.Items.FENCE_GATES_WOODEN);
            copy(VTags.Blocks.FENCES, VTags.Items.FENCES);
            copy(VTags.Blocks.FENCES_NETHER_BRICK, VTags.Items.FENCES_NETHER_BRICK);
            copy(VTags.Blocks.FENCES_WOODEN, VTags.Items.FENCES_WOODEN);
            tagCustom(VTags.Items.GEMS).addTags(VTags.Items.GEMS_AMETHYST, VTags.Items.GEMS_DIAMOND, VTags.Items.GEMS_EMERALD, VTags.Items.GEMS_LAPIS, VTags.Items.GEMS_PRISMARINE, VTags.Items.GEMS_QUARTZ);
            tagCustom(VTags.Items.GEMS_AMETHYST).method_26793(class_1802.field_27063);
            tagCustom(VTags.Items.GEMS_DIAMOND).method_26793(class_1802.field_8477);
            tagCustom(VTags.Items.GEMS_EMERALD).method_26793(class_1802.field_8687);
            tagCustom(VTags.Items.GEMS_LAPIS).method_26793(class_1802.field_8759);
            tagCustom(VTags.Items.GEMS_PRISMARINE).method_26793(class_1802.field_8434);
            tagCustom(VTags.Items.GEMS_QUARTZ).method_26793(class_1802.field_8155);
            copy(VTags.Blocks.GLASS, VTags.Items.GLASS);
            copy(VTags.Blocks.GLASS_SILICA, VTags.Items.GLASS_SILICA);
            copy(VTags.Blocks.GLASS_TINTED, VTags.Items.GLASS_TINTED);
            copy(VTags.Blocks.GLASS_COLORLESS, VTags.Items.GLASS_COLORLESS);
            copyColored(VTags.Blocks.GLASS, VTags.Items.GLASS);
            copy(VTags.Blocks.GLASS_PANES_COLORLESS, VTags.Items.GLASS_PANES_COLORLESS);
            copy(VTags.Blocks.GLASS_PANES, VTags.Items.GLASS_PANES);
            copy(VTags.Blocks.STAINED_GLASS_PANES, VTags.Items.STAINED_GLASS_PANES);
            copyColored(VTags.Blocks.GLASS_PANES, VTags.Items.GLASS_PANES);
            copy(VTags.Blocks.GRAVEL, VTags.Items.GRAVEL);
            tagCustom(VTags.Items.GUNPOWDER).method_26793(class_1802.field_8054);
            tagCustom(VTags.Items.HEADS).method_26795(class_1802.field_8681, class_1802.field_8712, class_1802.field_8575, class_1802.field_8398, class_1802.field_8791, class_1802.field_8470);
            tagCustom(VTags.Items.INGOTS).addTags(VTags.Items.INGOTS_BRICK, VTags.Items.INGOTS_COPPER, VTags.Items.INGOTS_GOLD, VTags.Items.INGOTS_IRON, VTags.Items.INGOTS_NETHERITE, VTags.Items.INGOTS_NETHER_BRICK);
            tagCustom(VTags.Items.INGOTS_BRICK).method_26793(class_1802.field_8621);
            tagCustom(VTags.Items.INGOTS_COPPER).method_26793(class_1802.field_27022);
            tagCustom(VTags.Items.INGOTS_GOLD).method_26793(class_1802.field_8695);
            tagCustom(VTags.Items.INGOTS_IRON).method_26793(class_1802.field_8620);
            tagCustom(VTags.Items.INGOTS_NETHERITE).method_26793(class_1802.field_22020);
            tagCustom(VTags.Items.INGOTS_NETHER_BRICK).method_26793(class_1802.field_8729);
            tagCustom(VTags.Items.LEATHER).method_26793(class_1802.field_8745);
            tagCustom(VTags.Items.MUSHROOMS).method_26795(class_1802.field_17516, class_1802.field_17517);
            tagCustom(VTags.Items.NETHER_STARS).method_26793(class_1802.field_8137);
            copy(VTags.Blocks.NETHERRACK, VTags.Items.NETHERRACK);
            tagCustom(VTags.Items.NUGGETS).addTags(VTags.Items.NUGGETS_IRON, VTags.Items.NUGGETS_GOLD);
            tagCustom(VTags.Items.NUGGETS_IRON).method_26793(class_1802.field_8675);
            tagCustom(VTags.Items.NUGGETS_GOLD).method_26793(class_1802.field_8397);
            copy(VTags.Blocks.OBSIDIAN, VTags.Items.OBSIDIAN);
            copy(VTags.Blocks.ORE_BEARING_GROUND_DEEPSLATE, VTags.Items.ORE_BEARING_GROUND_DEEPSLATE);
            copy(VTags.Blocks.ORE_BEARING_GROUND_NETHERRACK, VTags.Items.ORE_BEARING_GROUND_NETHERRACK);
            copy(VTags.Blocks.ORE_BEARING_GROUND_STONE, VTags.Items.ORE_BEARING_GROUND_STONE);
            copy(VTags.Blocks.ORE_RATES_DENSE, VTags.Items.ORE_RATES_DENSE);
            copy(VTags.Blocks.ORE_RATES_SINGULAR, VTags.Items.ORE_RATES_SINGULAR);
            copy(VTags.Blocks.ORE_RATES_SPARSE, VTags.Items.ORE_RATES_SPARSE);
            copy(VTags.Blocks.ORES, VTags.Items.ORES);
            copy(VTags.Blocks.ORES_COAL, VTags.Items.ORES_COAL);
            copy(VTags.Blocks.ORES_COPPER, VTags.Items.ORES_COPPER);
            copy(VTags.Blocks.ORES_DIAMOND, VTags.Items.ORES_DIAMOND);
            copy(VTags.Blocks.ORES_EMERALD, VTags.Items.ORES_EMERALD);
            copy(VTags.Blocks.ORES_GOLD, VTags.Items.ORES_GOLD);
            copy(VTags.Blocks.ORES_IRON, VTags.Items.ORES_IRON);
            copy(VTags.Blocks.ORES_LAPIS, VTags.Items.ORES_LAPIS);
            copy(VTags.Blocks.ORES_QUARTZ, VTags.Items.ORES_QUARTZ);
            copy(VTags.Blocks.ORES_REDSTONE, VTags.Items.ORES_REDSTONE);
            copy(VTags.Blocks.ORES_NETHERITE_SCRAP, VTags.Items.ORES_NETHERITE_SCRAP);
            copy(VTags.Blocks.ORES_IN_GROUND_DEEPSLATE, VTags.Items.ORES_IN_GROUND_DEEPSLATE);
            copy(VTags.Blocks.ORES_IN_GROUND_NETHERRACK, VTags.Items.ORES_IN_GROUND_NETHERRACK);
            copy(VTags.Blocks.ORES_IN_GROUND_STONE, VTags.Items.ORES_IN_GROUND_STONE);
            tagCustom(VTags.Items.RAW_MATERIALS).addTags(VTags.Items.RAW_MATERIALS_COPPER, VTags.Items.RAW_MATERIALS_GOLD, VTags.Items.RAW_MATERIALS_IRON);
            tagCustom(VTags.Items.RAW_MATERIALS_COPPER).method_26793(class_1802.field_33401);
            tagCustom(VTags.Items.RAW_MATERIALS_GOLD).method_26793(class_1802.field_33402);
            tagCustom(VTags.Items.RAW_MATERIALS_IRON).method_26793(class_1802.field_33400);
            tagCustom(VTags.Items.RODS).addTags(VTags.Items.RODS_BLAZE, VTags.Items.RODS_WOODEN);
            tagCustom(VTags.Items.RODS_BLAZE).method_26793(class_1802.field_8894);
            tagCustom(VTags.Items.RODS_WOODEN).method_26793(class_1802.field_8600);
            copy(VTags.Blocks.SAND, VTags.Items.SAND);
            copy(VTags.Blocks.SAND_COLORLESS, VTags.Items.SAND_COLORLESS);
            copy(VTags.Blocks.SAND_RED, VTags.Items.SAND_RED);
            copy(VTags.Blocks.SANDSTONE, VTags.Items.SANDSTONE);
            tagCustom(VTags.Items.SEEDS).addTags(VTags.Items.SEEDS_BEETROOT, VTags.Items.SEEDS_MELON, VTags.Items.SEEDS_PUMPKIN, VTags.Items.SEEDS_WHEAT);
            tagCustom(VTags.Items.SEEDS_BEETROOT).method_26793(class_1802.field_8309);
            tagCustom(VTags.Items.SEEDS_MELON).method_26793(class_1802.field_8188);
            tagCustom(VTags.Items.SEEDS_PUMPKIN).method_26793(class_1802.field_8706);
            tagCustom(VTags.Items.SEEDS_WHEAT).method_26793(class_1802.field_8317);
            tagCustom(VTags.Items.SHEARS).method_26793(class_1802.field_8868);
            tagCustom(VTags.Items.SLIMEBALLS).method_26793(class_1802.field_8777);
            copy(VTags.Blocks.STAINED_GLASS, VTags.Items.STAINED_GLASS);
            copy(VTags.Blocks.STAINED_GLASS_PANES, VTags.Items.STAINED_GLASS_PANES);
            copy(VTags.Blocks.STONE, VTags.Items.STONE);
            copy(VTags.Blocks.STORAGE_BLOCKS, VTags.Items.STORAGE_BLOCKS);
            copy(VTags.Blocks.STORAGE_BLOCKS_AMETHYST, VTags.Items.STORAGE_BLOCKS_AMETHYST);
            copy(VTags.Blocks.STORAGE_BLOCKS_COAL, VTags.Items.STORAGE_BLOCKS_COAL);
            copy(VTags.Blocks.STORAGE_BLOCKS_COPPER, VTags.Items.STORAGE_BLOCKS_COPPER);
            copy(VTags.Blocks.STORAGE_BLOCKS_DIAMOND, VTags.Items.STORAGE_BLOCKS_DIAMOND);
            copy(VTags.Blocks.STORAGE_BLOCKS_EMERALD, VTags.Items.STORAGE_BLOCKS_EMERALD);
            copy(VTags.Blocks.STORAGE_BLOCKS_GOLD, VTags.Items.STORAGE_BLOCKS_GOLD);
            copy(VTags.Blocks.STORAGE_BLOCKS_IRON, VTags.Items.STORAGE_BLOCKS_IRON);
            copy(VTags.Blocks.STORAGE_BLOCKS_LAPIS, VTags.Items.STORAGE_BLOCKS_LAPIS);
            copy(VTags.Blocks.STORAGE_BLOCKS_QUARTZ, VTags.Items.STORAGE_BLOCKS_QUARTZ);
            copy(VTags.Blocks.STORAGE_BLOCKS_REDSTONE, VTags.Items.STORAGE_BLOCKS_REDSTONE);
            copy(VTags.Blocks.STORAGE_BLOCKS_RAW_COPPER, VTags.Items.STORAGE_BLOCKS_RAW_COPPER);
            copy(VTags.Blocks.STORAGE_BLOCKS_RAW_GOLD, VTags.Items.STORAGE_BLOCKS_RAW_GOLD);
            copy(VTags.Blocks.STORAGE_BLOCKS_RAW_IRON, VTags.Items.STORAGE_BLOCKS_RAW_IRON);
            copy(VTags.Blocks.STORAGE_BLOCKS_NETHERITE, VTags.Items.STORAGE_BLOCKS_NETHERITE);
            tagCustom(VTags.Items.STRING).method_26793(class_1802.field_8276);
        }

        private void addColored(Consumer<class_6862<class_1792>> consumer, class_6862<class_1792> group, String pattern) {
            String prefix = group.comp_327().method_12832().toUpperCase(Locale.ENGLISH) + '_';
            for (class_1767 color : class_1767.values()) {
                class_2960 key = new class_2960("minecraft", pattern.replace("{color}", color.method_7792()));
                class_6862<class_1792> tag = getForgeItemTag(prefix + color.method_7792());
                class_1792 item = class_2378.field_11142.method_10223(key);
                if (item == null || item == class_1802.field_8162)
                    throw new IllegalStateException("Unknown vanilla item: " + key.toString());
                method_10512(tag).method_26793(item);
                consumer.accept(tag);
            }
        }

        private void copyColored(class_6862<class_2248> blockGroup, class_6862<class_1792> itemGroup) {
            String blockPre = blockGroup.comp_327().method_12832().toUpperCase(Locale.ENGLISH) + '_';
            String itemPre = itemGroup.comp_327().method_12832().toUpperCase(Locale.ENGLISH) + '_';
            for (class_1767 color : class_1767.values()) {
                class_6862<class_2248> from = getForgeBlockTag(blockPre + color.method_7792());
                class_6862<class_1792> to = getForgeItemTag(itemPre + color.method_7792());
//                copy(from, to);
            }
//            copy(getForgeBlockTag(blockPre + "colorless"), getForgeItemTag(itemPre + "colorless"));
        }

        @SuppressWarnings("unchecked")
        private class_6862<class_2248> getForgeBlockTag(String name) {
            try {
                name = name.toUpperCase(Locale.ENGLISH);
                return (class_6862<class_2248>) VTags.Blocks.class.getDeclaredField(name).get(null);
            } catch (IllegalArgumentException | IllegalAccessException | NoSuchFieldException | SecurityException e) {
                throw new IllegalStateException(VTags.Blocks.class.getName() + " is missing tag name: " + name);
            }
        }

        @SuppressWarnings("unchecked")
        private class_6862<class_1792> getForgeItemTag(String name) {
            try {
                name = name.toUpperCase(Locale.ENGLISH);
                return (class_6862<class_1792>) VTags.Items.class.getDeclaredField(name).get(null);
            } catch (IllegalArgumentException | IllegalAccessException | NoSuchFieldException | SecurityException e) {
                throw new IllegalStateException(VTags.Items.class.getName() + " is missing tag name: " + name);
            }
        }
    }

    private static class VEntityTypeTagsProvider extends CustomTagProviders.VEntityTagProvider {
        public VEntityTypeTagsProvider(FabricDataGenerator dataGenerator) {
            super(dataGenerator);
        }

        @Override
        protected void generateTags() {
            method_10512(VTags.EntityTypes.BOSSES).method_26792(VTags.EntityTypes.DRAGONS).method_26793(class_1299.field_6119);

            method_10512(VTags.EntityTypes.DRAGONS).method_26793(class_1299.field_6116);

            method_10512(VTags.EntityTypes.GOLEMS).method_26795(class_1299.field_6147, class_1299.field_6047);

            method_10512(VTags.EntityTypes.BUILDABLE_MOBS).method_26792(VTags.EntityTypes.GOLEMS).method_26793(class_1299.field_6119);

            method_10512(VTags.EntityTypes.BIG_NOSES).method_26792(VTags.EntityTypes.ILLAGERS).method_26795(class_1299.field_6145, class_1299.field_6077, class_1299.field_6054);
            method_10512(VTags.EntityTypes.ILLAGERS).method_26795(class_1299.field_6105, class_1299.field_6065, class_1299.field_6117, class_1299.field_6090);

            /*
             * Many of these mob types do not appear in vanilla Minecraft, and are thus left empty here
             */
            tagCustom(VTags.EntityTypes.ELEMENTAL).addTags(VTags.EntityTypes.ELEMENTAL_FIRE, VTags.EntityTypes.ELEMENTAL_ICE,
                VTags.EntityTypes.ELEMENTAL_METAL);
            method_10512(VTags.EntityTypes.ELEMENTAL_FIRE).method_26793(class_1299.field_6099);
            method_10512(VTags.EntityTypes.ELEMENTAL_ICE).method_26793(class_1299.field_6047);
            method_10512(VTags.EntityTypes.ELEMENTAL_METAL).method_26793(class_1299.field_6147);

            tagCustom(VTags.EntityTypes.ELEMENTAL_ATTACKS).addTags(VTags.EntityTypes.ELEMENTAL_ATTACKS_ELECTRIC, VTags.EntityTypes.ELEMENTAL_ATTACKS_FIRE,
                VTags.EntityTypes.ELEMENTAL_ATTACKS_ICE);
            method_10512(VTags.EntityTypes.ELEMENTAL_ATTACKS_ELECTRIC).method_26793(class_1299.field_6112);
            method_10512(VTags.EntityTypes.ELEMENTAL_ATTACKS_FIRE).method_26795(class_1299.field_6066, class_1299.field_6049);
            method_10512(VTags.EntityTypes.ELEMENTAL_ATTACKS_ICE).method_26793(class_1299.field_6068);

            method_10512(VTags.EntityTypes.ARTHROPODS).method_26795(class_1299.field_20346, class_1299.field_6084, class_1299.field_6128, class_1299.field_6125, class_1299.field_6079);

            method_10512(VTags.EntityTypes.AVIANS).method_26792(VTags.EntityTypes.AVIANS_FOWLS).method_26793(class_1299.field_6104);
            method_10512(VTags.EntityTypes.AVIANS_FOWLS).method_26793(class_1299.field_6132);

            method_10512(VTags.EntityTypes.AQUATIC).method_26795(class_1299.field_28315, class_1299.field_6070, class_1299.field_6087, class_1299.field_6086,
                class_1299.field_28402, class_1299.field_6118, class_1299.field_6062, class_1299.field_6073, class_1299.field_6114,
                class_1299.field_6111, class_1299.field_6113, class_1299.field_37419, class_1299.field_37420);
            method_10512(VTags.EntityTypes.FISH).method_26795(class_1299.field_6070, class_1299.field_6062, class_1299.field_6073, class_1299.field_6111);
            method_10512(VTags.EntityTypes.CEPHALOPODS).method_26795(class_1299.field_28402, class_1299.field_6114);
            method_10512(VTags.EntityTypes.GUARDIANS).method_26795(class_1299.field_6086, class_1299.field_6118);

            method_10512(VTags.EntityTypes.REPTILES).method_26793(class_1299.field_6113);

            tagCustom(VTags.EntityTypes.MAMMALS)
                .addTags(VTags.EntityTypes.MAMMALS_BOVINES, VTags.EntityTypes.MAMMALS_CAMELIDS, VTags.EntityTypes.MAMMALS_CANIDS,
                    VTags.EntityTypes.MAMMALS_CAPRINES, VTags.EntityTypes.MAMMALS_EQUINES, VTags.EntityTypes.MAMMALS_FELINES,
                    VTags.EntityTypes.MAMMALS_SWINES, VTags.EntityTypes.MAMMALS_URSIDS
                ).method_26795(class_1299.field_6108, class_1299.field_6140);
            method_10512(VTags.EntityTypes.MAMMALS_BOVINES).method_26792(VTags.EntityTypes.MAMMALS_BOVINES_CATTLE).method_26793(class_1299.field_6115);
            method_10512(VTags.EntityTypes.MAMMALS_BOVINES_CATTLE).method_26795(class_1299.field_6085, class_1299.field_6143);
            method_10512(VTags.EntityTypes.MAMMALS_CAMELIDS).method_26795(class_1299.field_6074, class_1299.field_17714);
            method_10512(VTags.EntityTypes.MAMMALS_CANIDS).method_26795(class_1299.field_17943, class_1299.field_6055);
            method_10512(VTags.EntityTypes.MAMMALS_CAPRINES).method_26793(class_1299.field_30052);
            method_10512(VTags.EntityTypes.MAMMALS_EQUINES).method_26795(class_1299.field_6067, class_1299.field_6139, class_1299.field_6048,
                class_1299.field_6075, class_1299.field_6057);
            method_10512(VTags.EntityTypes.MAMMALS_FELINES).method_26795(class_1299.field_16281, class_1299.field_6081);
            method_10512(VTags.EntityTypes.MAMMALS_SWINES).method_26795(class_1299.field_21973, class_1299.field_6093);
            method_10512(VTags.EntityTypes.MAMMALS_URSIDS).method_26795(class_1299.field_6146, class_1299.field_6042);

            method_10512(VTags.EntityTypes.GHOSTS).method_26795(class_1299.field_6059, class_1299.field_6078, class_1299.field_6107);

            tagCustom(VTags.EntityTypes.MILKABLE).addTags(VTags.EntityTypes.MAMMALS_BOVINES_CATTLE, VTags.EntityTypes.MAMMALS_CAPRINES);
            method_10512(VTags.EntityTypes.MUSHROOM_COWS).method_26793(class_1299.field_6143);

            method_10512(VTags.EntityTypes.BLIND_MOBS);

            tagCustom(VTags.EntityTypes.FLYING).addTags(VTags.EntityTypes.BOSSES, VTags.EntityTypes.GHOSTS).method_26795(class_1299.field_6108, class_1299.field_20346,
                class_1299.field_6116, class_1299.field_6104, class_1299.field_6119);
            tagCustom(VTags.EntityTypes.LAND).addTags(VTags.EntityTypes.CREEPERS, VTags.EntityTypes.SKELETONS, VTags.EntityTypes.ZOMBIES)
                .method_26795(class_1299.field_6099, class_1299.field_16281, class_1299.field_6084, class_1299.field_6132, class_1299.field_6067, class_1299.field_6091,
                    class_1299.field_6128, class_1299.field_6090, class_1299.field_17943, class_1299.field_30052, class_1299.field_21973, class_1299.field_6139, class_1299.field_6065,
                    class_1299.field_6147, class_1299.field_6074, class_1299.field_6102, class_1299.field_6057, class_1299.field_6081, class_1299.field_6146, class_1299.field_6093,
                    class_1299.field_22281, class_1299.field_25751, class_1299.field_6105, class_1299.field_6097, class_1299.field_6042, class_1299.field_6140,
                    class_1299.field_6134, class_1299.field_6115, class_1299.field_6109, class_1299.field_6125, class_1299.field_6069, class_1299.field_6047, class_1299.field_6079,
                    class_1299.field_17714, class_1299.field_6077, class_1299.field_6117, class_1299.field_17713, class_1299.field_6145, class_1299.field_6055
                );

            method_10512(VTags.EntityTypes.VOLCANIC).method_26793(class_1299.field_23214);
            method_10512(VTags.EntityTypes.HELL_MOBS).method_26792(VTags.EntityTypes.VOLCANIC)
                .method_26795(class_1299.field_6102, class_1299.field_6107, class_1299.field_22281, class_1299.field_25751,
                    class_1299.field_6099, class_1299.field_6076, class_1299.field_6050, class_1299.field_21973
                );

            tagCustom(VTags.EntityTypes.ENEMIES).addTags(VTags.EntityTypes.BOSSES, VTags.EntityTypes.CREEPERS/*, EntityTypeTags.RAIDERS*/)
                .method_26795(class_1299.field_6099, class_1299.field_6084, class_1299.field_6123, class_1299.field_6086, class_1299.field_6091, class_1299.field_6128,
                    class_1299.field_6107, class_1299.field_6118, class_1299.field_21973, class_1299.field_6071, class_1299.field_6102, class_1299.field_6078, class_1299.field_22281,
                    class_1299.field_25751, class_1299.field_6109, class_1299.field_6125, class_1299.field_6137, class_1299.field_6069, class_1299.field_6079, class_1299.field_6098,
                    class_1299.field_6059, class_1299.field_6076, class_1299.field_23696, class_1299.field_6051, class_1299.field_6054, class_1299.field_6050
                );
            method_10512(VTags.EntityTypes.CREEPERS).method_26793(class_1299.field_6046);

            tagCustom(VTags.EntityTypes.UNDEAD).addTags(VTags.EntityTypes.SKELETONS, VTags.EntityTypes.ZOMBIES)
                .method_26795(class_1299.field_6078, class_1299.field_6119);
            method_10512(VTags.EntityTypes.SKELETONS).method_26795(class_1299.field_6137, class_1299.field_6076, class_1299.field_6075);
            method_10512(VTags.EntityTypes.ZOMBIES).method_26795(class_1299.field_6123, class_1299.field_6071, class_1299.field_23696, class_1299.field_6051,
                class_1299.field_6048, class_1299.field_6054, class_1299.field_6050);

            method_10512(VTags.EntityTypes.NPC).method_26795(class_1299.field_22281, class_1299.field_6077, class_1299.field_17713);
        }
    }

    private static class VRecipeReplacementProvider extends FabricRecipesProvider {
        private final Map<class_1792, class_6862<class_1792>> replacements = new HashMap<>();
        private final Set<class_2960> excludes = new HashSet<>();

        private VRecipeReplacementProvider(FabricDataGenerator dataGenerator) {
            super(dataGenerator);
        }

        private void exclude(class_1935 item) {
            excludes.add(class_2378.field_11142.method_10221(item.method_8389()));
        }

        private void replace(class_1935 item, class_6862<class_1792> tag) {
            replacements.put(item.method_8389(), tag);
        }

        @Override
        protected void generateRecipes(Consumer<class_2444> exporter) {
            replace(class_1802.field_8600,  VTags.Items.RODS_WOODEN);
            replace(class_1802.field_8695,  VTags.Items.INGOTS_GOLD);
            replace(class_1802.field_8620,  VTags.Items.INGOTS_IRON);
            replace(class_1802.field_22020,  VTags.Items.INGOTS_NETHERITE);
            replace(class_1802.field_8477,  VTags.Items.GEMS_DIAMOND);
            replace(class_1802.field_8687,  VTags.Items.GEMS_EMERALD);
            replace(class_1802.field_8106,  VTags.Items.CHESTS_WOODEN);
            replace(class_2246.field_10445, VTags.Items.COBBLESTONE_NORMAL);
            replace(class_2246.field_29031, VTags.Items.COBBLESTONE_DEEPSLATE);

            exclude(class_2246.field_10205);
            exclude(class_1802.field_8397);
            exclude(class_2246.field_10085);
            exclude(class_1802.field_8675);
            exclude(class_2246.field_10201);
            exclude(class_2246.field_10234);
            exclude(class_2246.field_22108);

            exclude(class_2246.field_10596);
            exclude(class_2246.field_10351);
            exclude(class_2246.field_10625);
            exclude(class_2246.field_28889);
            exclude(class_2246.field_28890);
            exclude(class_2246.field_28891);

            method_10419(vanilla -> {
                class_2444 modified = enhance(vanilla);
                if (modified != null)
                    exporter.accept(modified);
            });
        }

        private class_2444 enhance(class_2444 vanilla) {
            if (vanilla instanceof class_2450.class_2451 result)
                return enhance(result);
            if (vanilla instanceof class_2447.class_2448 result)
                return enhance(result);
            return null;
        }

        private class_2444 enhance(class_2450.class_2451 vanilla) {
            List<class_1856> ingredients = ((ShapelessRecipeResultAccessor)vanilla).getIngredients();
            boolean modified = false;
            for (int x = 0; x < ingredients.size(); x++) {
                class_1856 ing = enhance(vanilla.method_10417(), ingredients.get(x));
                if (ing != null) {
                    ingredients.set(x, ing);
                    modified = true;
                }
            }
            return modified ? vanilla : null;
        }

        private class_2444 enhance(class_2447.class_2448 vanilla) {
            Map<Character, class_1856> ingredients = ((ShapedRecipeResultAccessor)vanilla).getKey();
            boolean modified = false;
            for (Character x : ingredients.keySet()) {
                class_1856 ing = enhance(vanilla.method_10417(), ingredients.get(x));
                if (ing != null) {
                    ingredients.put(x, ing);
                    modified = true;
                }
            }
            return modified ? vanilla : null;
        }

        private class_1856 enhance(class_2960 name, class_1856 vanilla) {
            if (excludes.contains(name))
                return null;

            boolean modified = false;
            List<class_1859> items = new ArrayList<>();
            for (class_1859 entry : ((IngredientAccessor)(Object)vanilla).getValues()) {
                if (entry instanceof class_1857) {
                    class_1799 stack = entry.method_8108().stream().findFirst().orElse(class_1799.field_8037);
                    class_6862<class_1792> replacement = replacements.get(stack.method_7909());
                    if (replacement != null) {
                        items.add(new class_1858(replacement));
                        modified = true;
                    } else
                        items.add(entry);
                } else
                    items.add(entry);
            }
            return modified ? class_1856.method_8092(items.stream()) : null;
        }
    }

    private static class VNoiseSettingsTagsProvider extends class_2474<class_5284> {
        private VNoiseSettingsTagsProvider(FabricDataGenerator dataGenerator) {
            super(dataGenerator, class_5458.field_26375);
        }

        @Override
        protected void method_10514() {
            this.method_10512(VTags.NoiseSettings.AMPLIFIED).method_40565(class_5284.field_26356);
            this.method_10512(VTags.NoiseSettings.CAVES).method_40565(class_5284.field_26359);
            this.method_10512(VTags.NoiseSettings.END).method_40565(class_5284.field_26358);
            this.method_10512(VTags.NoiseSettings.FLOATING_ISLANDS).method_40565(class_5284.field_26360);
            this.method_10512(VTags.NoiseSettings.NETHER).method_40565(class_5284.field_26357);
            this.method_10512(VTags.NoiseSettings.OVERWORLD).method_40565(class_5284.field_26355);
        }

    }

    private static class VDimensionTypeTagsProvider extends class_2474<class_2874> {
        private VDimensionTypeTagsProvider(FabricDataGenerator dataGenerator) {
            super(dataGenerator, class_5458.field_38009);
        }

        @Override
        protected void method_10514() {
            this.method_10512(VTags.DimensionTypes.END).method_40565(class_7134.field_37668);
            this.method_10512(VTags.DimensionTypes.NETHER).method_40565(class_7134.field_37667);
            this.method_10512(VTags.DimensionTypes.OVERWORLD)
                .method_26792(VTags.DimensionTypes.OVERWORLD_CAVES)
                .method_40565(class_7134.field_37666);
            this.method_10512(VTags.DimensionTypes.OVERWORLD_CAVES).method_40565(class_7134.field_37669);
        }
    }
}
