package io.github.vampirestudios.vampirelib.api;

import java.util.Locale;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_155;
import net.minecraft.class_2960;
import io.github.vampirestudios.vampirelib.modules.FeatureManager;
import io.github.vampirestudios.vampirelib.utils.Rands;

public abstract class BasicModClass implements ModInitializer, ClientModInitializer {

	private final String modId;
	private final String modName;
	private final String modVersion;

	private boolean printVersionMessage = true;

	public static FeatureManager FEATURE_MANAGER;
	private ConfigHolder<? extends CustomConfig> config;
	private final Logger LOGGER;

	protected BasicModClass(String modName, String modVersion) {
		this(modName, modVersion, false);
	}

	protected BasicModClass(String modId, String modName, String modVersion) {
		this(modId, modName, modVersion, false);
	}

	protected BasicModClass(String modName, String modVersion, boolean client) {
		this(modName, modName, modVersion, client);
	}

	protected BasicModClass(String modId, String modName, String modVersion, boolean client) {
		this.modId = modId.toLowerCase(Locale.ROOT);
		this.modName = modName;
		this.modVersion = modVersion;
		LOGGER = LoggerFactory.getLogger(this.modName + (client ? " Client" : ""));
		FEATURE_MANAGER = FeatureManager.createFeatureManager(new class_2960(this.modId,
				"feature_manager" + Rands.getRandom().nextInt()));
	}

	public void createConfig(Class<? extends CustomConfig> config) {
		AutoConfig.register(config, GsonConfigSerializer::new);
		this.config = AutoConfig.getConfigHolder(config);
	}

	public ConfigHolder<? extends CustomConfig> getConfig() {
		return config;
	}

	public class_2960 identifier(String path) {
		return new class_2960(modId(), path);
	}

	public class_2960 identifier(String namespace, String path) {
		return new class_2960(namespace, path);
	}

	public void registerFeatures() {

	}

	@Environment(EnvType.CLIENT)
	public void registerFeaturesClient() {

	}

	@Environment(EnvType.SERVER)
	public void registerFeaturesServer() {

	}

	public void commonPostRegisterFeatures() {
		FEATURE_MANAGER.initCommon(modId());
	}

	@Environment(EnvType.CLIENT)
	public void clientPostRegisterFeatures() {
		FEATURE_MANAGER.initClient(modId());
	}

	@Environment(EnvType.SERVER)
	public void serverPostRegisterFeatures() {
		FEATURE_MANAGER.initServer(modId());
	}

	public FeatureManager featureManager() {
		return FEATURE_MANAGER;
	}

	public Logger getLogger() {
		return LOGGER;
	}

	public String modId() {
		return modId;
	}

	public String modName() {
		return modName;
	}

	public String modVersion() {
		return modVersion;
	}

	public void shouldNotPrintVersionMessage() {
		this.printVersionMessage = false;
	}

	@Override
	public void onInitialize() {
		if (printVersionMessage) getLogger().info(String.format("You're now running %s v%s for %s", modName(), modVersion(), class_155.method_16673().getName()));
	}

	@Override
	public void onInitializeClient() {
		if (printVersionMessage) getLogger().info(String.format("You're now running %s v%s on Client-Side for %s", modName(), modVersion(), class_155.method_16673().getName()));
	}
}
